/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.AbstractBarRenderer;
import com.jidesoft.chart.render.BarRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.logging.Logger;

public class RaisedBarRenderer
extends AbstractBarRenderer
implements BarRenderer2D,
Serializable {
    private static final Logger \u013c = Logger.getLogger(RaisedBarRenderer.class.getName());
    private int \u013b = 20;

    public RaisedBarRenderer() {
    }

    public RaisedBarRenderer(int n2) {
        this();
        this.setEdgeSize(n2);
    }

    public int getEdgeSize() {
        return this.\u013b;
    }

    public void setEdgeSize(int n2) {
        assert (n2 >= 0);
        this.\u013b = n2;
    }

    @Override
    public Shape renderBar(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5) {
        Serializable serializable;
        Object object;
        Positionable positionable;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        boolean bl4 = false;
        ChartStyle chartStyle = chart.getStyle(chartModel);
        Orientation orientation = chartStyle == null ? Orientation.vertical : chartStyle.getBarOrientation();
        Positionable positionable2 = chartable == null ? null : chartable.getX();
        Positionable positionable3 = positionable = chartable == null ? null : chartable.getY();
        if (orientation == Orientation.vertical && positionable2 instanceof ChartCategory) {
            object = (ChartCategory)positionable2;
            serializable = ((ChartCategory)object).getHighlight();
            if (serializable != null) {
                chartStyle = chart.getHighlightStyle((Highlight)serializable);
            }
        } else if (orientation == Orientation.horizontal && positionable instanceof ChartCategory && (serializable = ((ChartCategory)(object = (ChartCategory)positionable)).getHighlight()) != null) {
            chartStyle = chart.getHighlightStyle((Highlight)serializable);
        }
        object = this.createBarPaint(chart, chartable, chartStyle, bl, bl2, bl3, (int)d2, (int)d3, (int)d4, (int)d5);
        if (object == null) {
            object = this.getBarColor(chart, chartable, chartStyle, bl, bl2, bl3);
        }
        if (orientation == Orientation.vertical) {
            if (d4 > (double)bl4) {
                d4 -= (double)bl4;
                d2 += (double)bl4 / 2.0;
            } else {
                d4 = 0.0;
            }
        }
        if (orientation == Orientation.horizontal) {
            if (d5 > (double)bl4) {
                d5 -= (double)bl4;
                d3 += (double)bl4 / 2.0;
            } else {
                d5 = 0.0;
            }
        }
        graphics2D2.setPaint((Paint)object);
        assert (d4 >= 0.0);
        if (d5 == 0.0) {
            if (this.isZeroHeightBarsVisible()) {
                serializable = new Rectangle2D.Double(d2, d3, d4, d5);
                graphics2D2.fill((Shape)((Object)serializable));
            }
        } else if (d5 > 0.0) {
            serializable = new Rectangle2D.Double(d2, d3, d4, d5);
            graphics2D2.fill((Shape)((Object)serializable));
        } else {
            d3 += d5;
            d5 = -d5;
            serializable = new Rectangle2D.Double(d2, d3, d4, d5);
            graphics2D2.fill((Shape)((Object)serializable));
        }
        double d6 = Math.min((double)this.\u013b, d5 / 2.0);
        double d7 = Math.min((double)this.\u013b, d4 / 2.0);
        double d8 = Math.min(d6, d7);
        this.\u0104(graphics2D2, (Paint)object, orientation, d2, d3, d4, d8);
        this.\u0103(graphics2D2, (Paint)object, orientation, d2, d3 + d5 - d8, d4, d8);
        this.\u0101(graphics2D2, (Paint)object, orientation, d2, d3, d8, d5);
        this.\u0102(graphics2D2, (Paint)object, orientation, d2 + d4 - d8, d3, d8, d5);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        if (this.alwaysShowOutlines || bl && chart.isSelectionShowsOutline()) {
            Color color = bl && chart.isSelectionShowsOutline() ? this.getSelectionColor() : (this.alwaysShowOutlines ? this.getOutlineColor() : chart.getBackground());
            graphics2D2.setColor(color);
            graphics2D2.setStroke(new BasicStroke(this.getOutlineWidth()));
            graphics2D2.draw(double_);
        }
        if (this.isLabelsVisible()) {
            this.renderBarLabel(graphics2D2, chart, chartModel, chartable, bl, bl2, bl3, d2, d3, d4, d5);
        }
        graphics2D2.dispose();
        return double_;
    }

    @Override
    public Shape renderBar(Graphics graphics, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return this.renderBar(graphics2D, chart, chartModel, chartable, bl, bl2, bl3, (double)n2, (double)n3, (double)n4, (double)n5);
    }

    protected Paint createUpperTopPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5) {
        return new GradientPaint(new Point(n2, n3), color.darker(), new Point(n2, n3 + n5 / 2), color.brighter());
    }

    protected Paint createLowerTopPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5) {
        return new GradientPaint(new Point(n2, n3 + n5 / 2), color.brighter(), new Point(n2, n3 + n5), color);
    }

    protected Paint createBottomPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5) {
        return new GradientPaint(new Point(n2, n3), color, new Point(n2, n3 + n5), color.darker());
    }

    protected Paint createLeftPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5) {
        return new GradientPaint(new Point(n2, n3), color.darker(), new Point(n2 + n4, n3), color);
    }

    protected Paint createRightPaint(Orientation orientation, Color color, int n2, int n3, int n4, int n5) {
        return new GradientPaint(new Point(n2, n3), color, new Point(n2 + n4, n3), color.darker());
    }

    private Shape \u0104(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2, d3);
        generalPath.lineTo(d2 + d4, d3);
        generalPath.lineTo(d2 + d4 - d5 / 2.0, d3 + d5 / 2.0);
        generalPath.lineTo(d2 + d5 / 2.0, d3 + d5 / 2.0);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createUpperTopPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, (int)d5) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(d2 + d5 / 2.0, d3 + d5 / 2.0);
        generalPath2.lineTo(d2 + d4 - d5 / 2.0, d3 + d5 / 2.0);
        generalPath2.lineTo(d2 + d4 - d5, d3 + d5);
        generalPath2.lineTo(d2 + d5, d3 + d5);
        generalPath2.closePath();
        Paint paint3 = paint instanceof Color ? this.createLowerTopPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, (int)d5) : paint;
        graphics2D.setPaint(paint3);
        graphics2D.fill(generalPath2);
        return generalPath;
    }

    private Shape \u0103(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2 + d5, d3);
        generalPath.lineTo(d2 + d4 - d5, d3);
        generalPath.lineTo(d2 + d4, d3 + d5);
        generalPath.lineTo(d2, d3 + d5);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createBottomPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, this.\u013b) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        return generalPath;
    }

    private Shape \u0101(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2, d3);
        generalPath.lineTo(d2 + d4, d3 + d4);
        generalPath.lineTo(d2 + d4, d3 + d5 - d4);
        generalPath.lineTo(d2, d3 + d5);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createLeftPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, this.\u013b) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        return generalPath;
    }

    private Shape \u0102(Graphics2D graphics2D, Paint paint, Orientation orientation, double d2, double d3, double d4, double d5) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(d2, d3 + d4);
        generalPath.lineTo(d2 + d4, d3);
        generalPath.lineTo(d2 + d4, d3 + d5);
        generalPath.lineTo(d2, d3 + d5 - d4);
        generalPath.closePath();
        Paint paint2 = paint instanceof Color ? this.createRightPaint(orientation, (Color)paint, (int)d2, (int)d3, (int)d4, this.\u013b) : paint;
        graphics2D.setPaint(paint2);
        graphics2D.fill(generalPath);
        return generalPath;
    }

    @Override
    public int getMinimumBreadth() {
        return 0;
    }
}

