/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.model;

import com.yworks.util.graph.Node;
import com.yworks.yshrink.model.AnnotationUsage;
import com.yworks.yshrink.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDescriptor {
    private boolean isEntryPoint;
    private boolean isReachable;
    private List<AnnotationUsage> annotations = new ArrayList<AnnotationUsage>();
    protected Node node;
    protected final int access;
    protected File sourceJar;
    private static final Pattern CLASS_PATTERN = Pattern.compile("L(.*);");

    protected AbstractDescriptor(int access, File sourceJar) {
        this.access = access;
        this.sourceJar = sourceJar;
    }

    public AnnotationUsage addAnnotation(String annotationName) {
        Matcher matcher = CLASS_PATTERN.matcher(annotationName);
        if (matcher.matches()) {
            AnnotationUsage usage = new AnnotationUsage(matcher.group(1));
            this.annotations.add(usage);
            return usage;
        }
        Logger.warn("Unexpected annotation name: " + annotationName);
        return new AnnotationUsage(annotationName);
    }

    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public boolean isEntryPoint() {
        return this.isEntryPoint;
    }

    public void setEntryPoint(boolean entryPoint) {
        this.isEntryPoint = entryPoint;
    }

    public boolean isReachable() {
        return this.isReachable;
    }

    public void setReachable(boolean reachable) {
        this.isReachable = reachable;
    }

    public int getAccess() {
        return this.access;
    }

    public boolean isSynthetic() {
        return (this.access & 0x1000) == 4096;
    }

    public boolean isAbstract() {
        return (0x400 & this.access) == 1024;
    }

    public File getSourceJar() {
        return this.sourceJar;
    }
}

