/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.LogParserView;
import com.yworks.yguard.ObfuscatorTask;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class YGuardLogParser {
    private DefaultTreeModel tree;
    private final MyContentHandler contentHandler = new MyContentHandler();

    public YGuardLogParser() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null, true);
        this.tree = new DefaultTreeModel(root, true);
    }

    protected DefaultMutableTreeNode findChild(TreeNode node, String name, Class ofType) {
        return this.findChild(node, name, ofType, false);
    }

    protected DefaultMutableTreeNode findChild(TreeNode node, String name, Class ofType, boolean useMap) {
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            Mapped m = (Mapped)child.getUserObject();
            if (ofType != null && !ofType.isAssignableFrom(m.getClass()) || !(useMap ? m.getMappedName().equals(name) : m.getName().equals(name))) continue;
            return child;
        }
        return null;
    }

    protected DefaultMutableTreeNode getPackageNode(String packageName) {
        return this.getPackageNode(packageName, false);
    }

    protected DefaultMutableTreeNode getPackageNode(String packageName, boolean useMap) {
        DefaultMutableTreeNode node = this.getRoot();
        if (packageName != null) {
            StringTokenizer st = new StringTokenizer(packageName, ".", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                DefaultMutableTreeNode child = this.findChild(node, token, PackageStruct.class, useMap);
                if (child == null) {
                    PackageStruct ps = new PackageStruct(token, token);
                    child = new DefaultMutableTreeNode(ps, true);
                    node.insert(child, this.calcChildIndex(node, child));
                }
                node = child;
            }
        }
        return node;
    }

    protected ClassStruct getClass(String fqn) {
        return (ClassStruct)this.getClassNode(fqn).getUserObject();
    }

    protected PackageStruct getPackage(String fqn) {
        return (PackageStruct)this.getPackageNode(fqn).getUserObject();
    }

    protected MethodStruct getMethod(String fqn, String signature) {
        return (MethodStruct)this.getMethodNode(fqn, signature).getUserObject();
    }

    protected FieldStruct getField(String fqn, String signature) {
        return (FieldStruct)this.getFieldNode(fqn, signature).getUserObject();
    }

    protected DefaultMutableTreeNode getClassNode(String fqn) {
        return this.getClassNode(fqn, false);
    }

    protected DefaultMutableTreeNode getClassNode(String fqn, boolean useMap) {
        String className;
        String packageName;
        if (fqn.indexOf(46) < 0) {
            packageName = null;
            className = fqn;
        } else {
            packageName = fqn.substring(0, fqn.lastIndexOf(46));
            className = fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        DefaultMutableTreeNode pn = this.getPackageNode(packageName);
        if (className.indexOf(36) > 0) {
            StringTokenizer st = new StringTokenizer(className, "$", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                DefaultMutableTreeNode child = this.findChild(pn, token, ClassStruct.class, useMap);
                if (child == null) {
                    child = new DefaultMutableTreeNode(new ClassStruct(token, token), true);
                    pn.insert(child, this.calcChildIndex(pn, child));
                }
                pn = child;
            }
            return pn;
        }
        DefaultMutableTreeNode child = this.findChild(pn, className, ClassStruct.class, useMap);
        if (child == null) {
            child = new DefaultMutableTreeNode(new ClassStruct(className, className), true);
            pn.insert(child, this.calcChildIndex(pn, child));
        }
        return child;
    }

    protected DefaultMutableTreeNode getMethodNode(String cname, String fqn) {
        return this.getMethodNode(cname, fqn, false);
    }

    protected DefaultMutableTreeNode getMethodNode(String cname, String fqn, boolean useMap) {
        DefaultMutableTreeNode cn = this.getClassNode(cname);
        DefaultMutableTreeNode child = this.findChild(cn, fqn, MethodStruct.class, useMap);
        if (child == null) {
            MethodStruct ms = new MethodStruct(fqn, fqn);
            child = new DefaultMutableTreeNode(ms, false);
            cn.insert(child, this.calcChildIndex(cn, child));
        }
        return child;
    }

    private int calcChildIndex(DefaultMutableTreeNode cn, DefaultMutableTreeNode child) {
        int left = 0;
        int right = cn.getChildCount() - 1;
        Object userObject = child.getUserObject();
        while (right >= left) {
            int test = (left + right) / 2;
            Object testObject = ((DefaultMutableTreeNode)cn.getChildAt(test)).getUserObject();
            int cmp = this.compare(userObject, testObject);
            if (cmp == 0) {
                return test;
            }
            if (cmp < 0) {
                right = test - 1;
                continue;
            }
            left = test + 1;
        }
        return left;
    }

    private int compare(Object o1, Object o2) {
        Mapped m1 = (Mapped)o1;
        Mapped m2 = (Mapped)o2;
        if (m1.getClass() != m2.getClass()) {
            if (m1.getClass() == PackageStruct.class) {
                return -1;
            }
            if (m2.getClass() == PackageStruct.class) {
                return 1;
            }
            if (m1.getClass() == ClassStruct.class) {
                return -1;
            }
            if (m2.getClass() == ClassStruct.class) {
                return 1;
            }
            if (m1.getClass() == MethodStruct.class) {
                return -1;
            }
            if (m2.getClass() == MethodStruct.class) {
                return 1;
            }
        }
        return m1.getName().compareTo(m2.getName());
    }

    protected DefaultMutableTreeNode getFieldNode(String cname, String fqn) {
        return this.getFieldNode(cname, fqn, false);
    }

    protected DefaultMutableTreeNode getFieldNode(String cname, String fqn, boolean useMap) {
        DefaultMutableTreeNode cn = this.getClassNode(cname);
        DefaultMutableTreeNode child = this.findChild(cn, fqn, FieldStruct.class, useMap);
        if (child == null) {
            FieldStruct ms = new FieldStruct(fqn, fqn);
            child = new DefaultMutableTreeNode(ms, false);
            cn.insert(child, this.calcChildIndex(cn, child));
        }
        return child;
    }

    void parse(File file) throws ParserConfigurationException, SAXException, IOException {
        if (file.getName().toLowerCase().endsWith(".gz")) {
            this.parse(new InputSource(new GZIPInputStream(new FileInputStream(file))));
        } else {
            URL url = file.toURI().toURL();
            if (url != null) {
                this.parse(url);
            }
        }
    }

    public void parse(URL url) throws ParserConfigurationException, SAXException, IOException {
        this.parse(new InputSource(url.openStream()));
    }

    public void parse(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        SAXParser parser = f.newSAXParser();
        XMLReader r = parser.getXMLReader();
        r.setContentHandler(this.contentHandler);
        r.parse(is);
    }

    public String translate(String fqn) {
        DefaultMutableTreeNode node = this.getRoot();
        StringBuffer ocnSb = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        boolean buildPrefix = true;
        StringTokenizer st = new StringTokenizer(fqn, "$.", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            sb.append(token);
            if ("$".equals(token) || ".".equals(token)) continue;
            boolean hasNext = st.hasMoreTokens();
            Class<ClassStruct> type = hasNext ? null : ClassStruct.class;
            DefaultMutableTreeNode child = this.findChild(node, sb.toString(), type, true);
            if (child == null) {
                if (buildPrefix && hasNext) {
                    st.nextToken();
                    sb.append('/');
                    continue;
                }
                if (hasNext) {
                    ocnSb.append(sb.toString().replace('/', '.'));
                    YGuardLogParser.append(ocnSb, st);
                } else if (buildPrefix) {
                    ocnSb.append(fqn);
                } else if (node.getUserObject().getClass() == ClassStruct.class) {
                    ocnSb.append(YGuardLogParser.translateMethodName(node, sb.toString()));
                } else {
                    ocnSb.append(sb.toString().replace('/', '.'));
                }
                node = null;
                break;
            }
            buildPrefix = false;
            sb.setLength(0);
            node = child;
            ocnSb.append(YGuardLogParser.getOriginalName(child));
            if (!st.hasMoreTokens()) continue;
            ocnSb.append(st.nextToken());
        }
        return ocnSb.toString();
    }

    public MyStackTraceElement translate(MyStackTraceElement ste) {
        try {
            DefaultMutableTreeNode child;
            String token;
            DefaultMutableTreeNode classNode = this.getRoot();
            int dollarPos = ste.getClassName().indexOf(36);
            if (dollarPos < 0) {
                dollarPos = ste.getClassName().length();
            }
            int lastDot = ste.getClassName().substring(0, dollarPos).lastIndexOf(46);
            String packageName = ste.getClassName().substring(0, lastDot + 1);
            String classAndInnerClassName = ste.getClassName().substring(lastDot + 1);
            StringBuffer ocnSb = new StringBuffer();
            StringBuffer sb = new StringBuffer();
            boolean buildPrefix = true;
            StringTokenizer st = new StringTokenizer(packageName, ".", true);
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                sb.append(token);
                child = this.findChild(classNode, sb.toString(), PackageStruct.class, true);
                if (child == null) {
                    if (buildPrefix && st.hasMoreTokens()) {
                        st.nextToken();
                        sb.append('/');
                        continue;
                    }
                    classNode = null;
                    break;
                }
                buildPrefix = false;
                sb.setLength(0);
                classNode = child;
                ocnSb.append(YGuardLogParser.getOriginalName(classNode));
                if (!st.hasMoreTokens()) continue;
                ocnSb.append(st.nextToken());
            }
            if (buildPrefix) {
                classNode = null;
            }
            sb.setLength(0);
            st = new StringTokenizer(classAndInnerClassName, "$.", true);
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                sb.append(token);
                if ("$".equals(token) || ".".equals(token)) continue;
                token = sb.toString();
                sb.setLength(0);
                child = this.findChild(classNode, token, ClassStruct.class, true);
                if (child == null) {
                    ocnSb.append(token);
                    YGuardLogParser.append(ocnSb, st);
                    classNode = null;
                    break;
                }
                classNode = child;
                ocnSb.append(YGuardLogParser.getOriginalName(classNode));
                if (!st.hasMoreTokens()) continue;
                ocnSb.append(st.nextToken());
            }
            String newMethodName = YGuardLogParser.translateMethodName(classNode, ste.getMethodName());
            int lineNumber = 0;
            String originalClassName = ocnSb.toString();
            try {
                lineNumber = ste.getLineNumber();
                if (lineNumber > 0) {
                    String saltString;
                    Map property = (Map)this.contentHandler.ownerProperties.get(originalClassName);
                    long salt = -1L;
                    if (property != null && (saltString = (String)property.get("scrambling-salt")) != null) {
                        try {
                            salt = Long.parseLong(saltString);
                            long seed = salt ^ (long)originalClassName.replace('$', '.').hashCode();
                            ObfuscatorTask.LineNumberScrambler scrambler = new ObfuscatorTask.LineNumberScrambler(3584, seed);
                            lineNumber = scrambler.unscramble(lineNumber);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String fileName = classNode == null ? "" : YGuardLogParser.buildFilename(originalClassName);
            return new MyStackTraceElement(originalClassName, newMethodName, fileName, lineNumber);
        }
        catch (Exception e) {
            return ste;
        }
    }

    private static String translateMethodName(DefaultMutableTreeNode node, String mappedName) {
        StringBuffer originalName = new StringBuffer();
        if (node != null) {
            String del = "";
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                int spaceIndex;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                Mapped mapped = (Mapped)child.getUserObject();
                if (mapped.getClass() != MethodStruct.class || !mapped.getMappedName().equals(mappedName)) continue;
                String name = mapped.getName();
                int braceIndex = name.indexOf(40);
                if (0 < braceIndex && braceIndex + 1 == name.indexOf(41)) {
                    name = name.substring(0, braceIndex);
                }
                if (0 < (spaceIndex = name.lastIndexOf(32, braceIndex < 0 ? name.length() : braceIndex))) {
                    name = name.substring(spaceIndex + 1);
                }
                originalName.append(del).append(name);
                del = "|";
            }
        }
        return originalName.length() < 1 ? mappedName : originalName.toString();
    }

    public static void main(String[] args) throws Exception {
        File file;
        if (args.length < 1) {
            System.out.println("Usage java -jar yguard.jar logfile.xml[.gz] [-pipe] [name]");
            System.out.println(" where 'logfile.xml' is the logfile that has been generated ");
            System.out.println(" during the obfuscation process");
            System.out.println(" and which may be gzipped (with .gz extension)");
            System.out.println(" and where 'name' is an optional string, which will be translated");
            System.out.println(" according to the logfile automatically.");
            System.out.println(" If no 'name' is given, a tiny GUI will popup that will help in translating");
            System.out.println(" stacktraces, fully qualified classnames etc.");
            System.out.println(" If '-pipe' is specified as the last argument after the logfile the tool");
            System.out.println(" will translate the input from standard in and output the translation to");
            System.out.println(" standard out until the input is closed.");
            System.exit(-1);
        }
        if (!(file = new File(args[0])).isFile() || !file.canRead()) {
            System.err.println("Could not open file " + args[0]);
            System.exit(-1);
        }
        if (args.length < 2) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new LogParserView().show(file);
                }
            });
        } else {
            YGuardLogParser parser = new YGuardLogParser();
            parser.parse(file);
            if (args[1].equals("-pipe")) {
                String s;
                InputStreamReader er = new InputStreamReader(System.in);
                BufferedReader br = new BufferedReader(er);
                while ((s = br.readLine()) != null) {
                    System.out.println(parser.translate(new String[]{s})[0]);
                }
            } else {
                String[] strings = new String[args.length - 1];
                System.arraycopy(args, 1, strings, 0, args.length - 1);
                String[] s = parser.translate(strings);
                for (int i = 0; i < s.length; ++i) {
                    System.out.println(s[i]);
                }
            }
        }
    }

    String[] translate(String[] args) {
        String[] resultArr = new String[args.length];
        Pattern jrockitPattern = Pattern.compile("(.*\\s+)?([^;()\\s]+)\\.([^;()\\s]+)\\(([^)]*)\\)(.+)\\(([^:)]+)(?::(\\d*))?\\)(.*)");
        Pattern stePattern = Pattern.compile("(.*\\s+)?([^(\\s]+)\\.([^(\\s]+)\\(([^:)]*)(?::(\\d*))?\\)(.*)");
        Pattern fqnPattern = Pattern.compile("([^:;()\\s]+\\.)+([^:;()\\s]+)");
        for (int i = 0; i < args.length; ++i) {
            args[i] = CharConverter.convert(args[i]);
            Matcher m2 = jrockitPattern.matcher(args[i]);
            if (m2.matches()) {
                String[] moduleAndType = YGuardLogParser.split(m2.group(2));
                MyStackTraceElement ste = m2.group(7) == null ? new MyStackTraceElement(moduleAndType[1], m2.group(3), "", 0) : new MyStackTraceElement(moduleAndType[1], m2.group(3), m2.group(6), Integer.parseInt(m2.group(7)));
                String params = m2.group(4);
                try {
                    params = Conversion.toJavaArguments(params);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                resultArr[i] = (m2.group(1) != null ? m2.group(1) : "") + moduleAndType[0] + YGuardLogParser.format(ste, m2.group(7) == null ? m2.group(6) : null) + " [" + params + "]" + m2.group(8);
                continue;
            }
            Matcher m = stePattern.matcher(args[i]);
            if (m.matches()) {
                String[] moduleAndType = YGuardLogParser.split(m.group(2));
                MyStackTraceElement ste = m.group(5) == null ? new MyStackTraceElement(moduleAndType[1], m.group(3), "", 0) : new MyStackTraceElement(moduleAndType[1], m.group(3), m.group(4), Integer.parseInt(m.group(5)));
                resultArr[i] = (m.group(1) != null ? m.group(1) : "") + moduleAndType[0] + YGuardLogParser.format(this.translate(ste), m.group(5) == null ? m.group(4) : null) + m.group(6);
                continue;
            }
            StringBuffer replacement = new StringBuffer();
            Matcher fqnMatcher = fqnPattern.matcher(args[i]);
            while (fqnMatcher.find()) {
                String result;
                String[] moduleAndType = YGuardLogParser.split(fqnMatcher.group());
                try {
                    result = this.translate(moduleAndType[1]);
                }
                catch (Exception ex) {
                    result = moduleAndType[1];
                }
                fqnMatcher.appendReplacement(replacement, moduleAndType[0] + YGuardLogParser.escapeReplacement(result));
            }
            fqnMatcher.appendTail(replacement);
            resultArr[i] = replacement.toString();
        }
        return resultArr;
    }

    private static String[] split(String moduleAndType) {
        int idx2;
        if (moduleAndType == null) {
            return new String[]{"", ""};
        }
        int idx1 = moduleAndType.indexOf(36);
        int n = idx2 = idx1 > -1 ? moduleAndType.lastIndexOf(47, idx1) : moduleAndType.lastIndexOf(47);
        if (idx2 > -1) {
            return new String[]{moduleAndType.substring(0, idx2 + 1), moduleAndType.substring(idx2 + 1)};
        }
        return new String[]{"", moduleAndType};
    }

    private static String format(MyStackTraceElement ste, String s) {
        String fn = ste.getFileName();
        if ((fn == null || fn.length() == 0) && s != null) {
            return ste.getClassName() + '.' + ste.getMethodName() + '(' + s + ')';
        }
        return ste.toString();
    }

    DefaultTreeModel getTreeModel() {
        return this.tree;
    }

    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.tree.getRoot();
    }

    private static String getOriginalName(DefaultMutableTreeNode node) {
        return ((Mapped)node.getUserObject()).getName();
    }

    private static String escapeReplacement(String replacementString) {
        if (replacementString.indexOf(92) == -1 && replacementString.indexOf(36) == -1) {
            return replacementString;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < replacementString.length(); ++i) {
            char c = replacementString.charAt(i);
            if (c == '\\') {
                result.append('\\').append('\\');
                continue;
            }
            if (c == '$') {
                result.append('\\').append('$');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static StringBuffer append(StringBuffer sb, StringTokenizer st) {
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        return sb;
    }

    private static String buildFilename(String qualifiedName) {
        String fileName = "";
        int idxDot = qualifiedName.lastIndexOf(46);
        fileName = idxDot > 0 ? qualifiedName.substring(idxDot + 1) : qualifiedName;
        int idxDollar = fileName.indexOf(36);
        if (idxDollar > 0) {
            fileName = fileName.substring(0, idxDollar);
        }
        return fileName + ".java";
    }

    public static final class Icons
    implements Icon {
        public static final Icon CLASS_ICON = new Icons(Color.blue, "C");
        public static final Icon METHOD_ICON = new Icons(Color.red, "M");
        public static final Icon PACKAGE_ICON = new Icons(Color.yellow, "P");
        public static final Icon FIELD_ICON = new Icons(Color.green, "F");
        private static final Ellipse2D circle = new Ellipse2D.Double(1.0, 1.0, 14.0, 14.0);
        protected Color color;
        protected String label;

        public Icons(Color color, String label) {
            this.color = color;
            this.label = label;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(this.color);
            Graphics2D g2d = (Graphics2D)g;
            Object a = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.fill(circle);
            g2d.setColor(this.color.darker());
            g2d.draw(circle);
            float width = (float)g2d.getFontMetrics().getStringBounds(this.label, g2d).getWidth();
            g2d.setColor(Color.black);
            g2d.drawString(this.label, 9.0f - width * 0.5f, 14.0f);
            g2d.setColor(Color.white);
            g2d.drawString(this.label, 8.0f - width * 0.5f, 13.0f);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, a);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static final class MyStackTraceElement {
        private String className;
        private String methodName;
        private String fileName;
        private int lineNumber;

        public MyStackTraceElement(String className, String methodName, String fileName, int lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        public String getClassName() {
            return this.className;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String toString() {
            return this.getClassName() + "." + this.getMethodName() + "(" + (this.fileName != null && this.lineNumber >= 0 ? this.fileName + ":" + this.lineNumber : "unknown source") + ")";
        }
    }

    public static final class CharConverter {
        private static final Pattern unicodeEscape = Pattern.compile("&#(\\d{1,5});");

        public static String convert(String s) {
            StringBuilder r = new StringBuilder();
            Matcher matcher = unicodeEscape.matcher(s);
            int lastMatchEnd = 0;
            while (matcher.find()) {
                String match = matcher.group(1);
                r.append(s.substring(lastMatchEnd, matcher.start()));
                r.append((char)Integer.parseInt(match));
                lastMatchEnd = matcher.end();
            }
            r.append(s.substring(lastMatchEnd, s.length()));
            return r.toString();
        }
    }

    private class MyContentHandler
    implements ContentHandler {
        private boolean inMapSection;
        private boolean inLogSection;
        final Map ownerProperties = new HashMap();

        private MyContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("map".equals(qName)) {
                this.inMapSection = false;
            }
            if ("yguard".equals(qName)) {
                this.inLogSection = false;
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
            this.ownerProperties.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("map".equals(qName)) {
                this.inMapSection = true;
            }
            if ("yguard".equals(qName)) {
                this.inLogSection = true;
                String version = attributes.getValue("version");
                if ("1.5".compareTo(version) < 0) {
                    throw new IllegalStateException("Version should not be greater than 1.5 but was " + version);
                }
            }
            if (this.inLogSection && !this.inMapSection && "property".equals(qName)) {
                String key = attributes.getValue("name");
                String value = attributes.getValue("value");
                String owner = attributes.getValue("owner");
                HashMap<String, String> map = (HashMap<String, String>)this.ownerProperties.get(owner);
                if (map == null) {
                    map = new HashMap<String, String>();
                    this.ownerProperties.put(owner, map);
                }
                map.put(key, value);
            }
            if (this.inMapSection) {
                String map;
                String name;
                AbstractMappedStruct fs;
                String map2;
                String name2;
                String className;
                if ("method".equals(qName)) {
                    className = attributes.getValue("class");
                    name2 = attributes.getValue("name");
                    map2 = attributes.getValue("map");
                    fs = YGuardLogParser.this.getMethod(className, name2);
                    fs.setMappedName(map2);
                }
                if ("field".equals(qName)) {
                    className = attributes.getValue("class");
                    name2 = attributes.getValue("name");
                    map2 = attributes.getValue("map");
                    fs = YGuardLogParser.this.getField(className, name2);
                    fs.setMappedName(map2);
                }
                if ("package".equals(qName)) {
                    name = attributes.getValue("name");
                    map = attributes.getValue("map");
                    PackageStruct ps = YGuardLogParser.this.getPackage(name);
                    ps.setMappedName(map);
                }
                if ("class".equals(qName)) {
                    name = attributes.getValue("name");
                    map = attributes.getValue("map");
                    ClassStruct cs = YGuardLogParser.this.getClass(name);
                    cs.setMappedName(map);
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    private static final class FieldStruct
    extends AbstractMappedStruct {
        FieldStruct(String name, String map) {
            super(name, map, Icons.FIELD_ICON);
        }

        @Override
        public String toString() {
            return this.getName() + " -> " + this.getMappedName();
        }
    }

    static final class MethodStruct
    extends AbstractMappedStruct {
        MethodStruct(String name, String map) {
            super(name, map, Icons.METHOD_ICON);
        }

        @Override
        public String toString() {
            return this.getName() + " -> " + this.getMappedName();
        }
    }

    static final class ClassStruct
    extends AbstractMappedStruct {
        ClassStruct(String name, String map) {
            super(name, map, Icons.CLASS_ICON);
        }

        @Override
        public String toString() {
            return this.getName() + " -> " + this.getMappedName();
        }
    }

    static final class PackageStruct
    extends AbstractMappedStruct {
        PackageStruct(String name, String map) {
            super(name, map, Icons.PACKAGE_ICON);
        }

        @Override
        public String toString() {
            return this.getName() + " -> " + this.getMappedName();
        }
    }

    private static class AbstractMappedStruct
    implements Mapped {
        private String name;
        private String mappedName;
        private Icon icon;

        public AbstractMappedStruct(String namePart, String mappedName, Icon icon) {
            this.name = namePart;
            this.mappedName = mappedName;
            this.icon = icon;
        }

        @Override
        public String getMappedName() {
            return this.mappedName;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setMappedName(String n) {
            this.mappedName = n;
        }

        public void setName(String n) {
            this.name = n;
        }

        public String toString() {
            return this.getName() + " -> " + this.getMappedName();
        }
    }

    static interface Mapped {
        public String getName();

        public String getMappedName();

        public Icon getIcon();
    }
}

