/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsbase.util.ScientificFormat;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsbase.util.images.ImageUtilities;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.ps.EPSIEncoder;
import org.freehep.graphicsio.ps.MappedColor;
import org.freehep.graphicsio.ps.PSFontTable;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.ps.PSPathConstructor;
import org.freehep.graphicsio.ps.PSStringStyler;

public abstract class AbstractPSGraphics2D
extends AbstractVectorGraphicsIO
implements FontUtilities.ShowString {
    private static final String rootKey = PSGraphics2D.class.getName();
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String PAGE_SIZE = rootKey + "." + "PageSize";
    public static final String CUSTOM_PAGE_SIZE = rootKey + "." + "Custom PageSize";
    public static final String PAGE_MARGINS = rootKey + "." + "PageMargins";
    public static final String ORIENTATION = rootKey + "." + "Orientation";
    public static final String FIT_TO_PAGE = rootKey + "." + "FitToPage";
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    public static final String EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
    public static final String FOR = rootKey + "." + "For";
    public static final String TITLE = rootKey + "." + "Title";
    public static final String PREVIEW = rootKey + ".Preview";
    public static final String PREVIEW_BITS = rootKey + ".PreviewBits";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 12753 $";
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    private PSFontTable fontTable;
    protected OutputStream ros;
    protected PrintStream os;
    private int postscriptLevel = 3;
    private ScientificFormat scientific = new ScientificFormat(6, 9, false);

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public AbstractPSGraphics2D(Dimension size, boolean doRestoreOnDispose) {
        super(size, doRestoreOnDispose);
    }

    public AbstractPSGraphics2D(Component component, boolean doRestoreOnDispose) {
        super(component, doRestoreOnDispose);
    }

    protected AbstractPSGraphics2D(AbstractPSGraphics2D graphics, boolean doRestoreOnDispose) {
        super(graphics, doRestoreOnDispose);
        this.ros = graphics.ros;
        this.os = graphics.os;
        this.fontTable = graphics.fontTable;
    }

    protected void init(OutputStream os) {
        this.ros = new BufferedOutputStream(os);
        this.initProperties(defaultProperties);
        this.fontTable = new PSFontTable(this.ros, this.getFontRenderContext());
    }

    public static void setClipEnabled(boolean enabled) {
        defaultProperties.setProperty(CLIP, enabled);
    }

    public void writeHeader() throws IOException {
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.println("%%Creator: " + this.getCreator());
        this.os.println("%%Producer: " + producer);
        this.os.println("%%For: " + this.getProperty(FOR));
        this.os.println("%%Title: " + this.getProperty(TITLE));
        if (!this.isDeviceIndependent()) {
            this.os.println("%%CreationDate: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        }
        this.os.println("%%LanguageLevel: " + this.postscriptLevel);
        this.os.println("%%EndComments");
        if (this.isProperty(PREVIEW) && this.getComponent() != null) {
            Rectangle size = this.getComponent().getBounds();
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics imageGraphics = image.getGraphics();
            this.getComponent().print(imageGraphics);
            EPSIEncoder encoder = new EPSIEncoder(image, this.ros, this.getPropertyInt(PREVIEW_BITS), this.getProperty(ORIENTATION).equals("Portrait"));
            encoder.encode();
        }
        this.os.println("%%BeginProlog");
        AbstractPSGraphics2D.copyResourceTo((Object)this, "PSProlog.txt", this.os);
        this.os.println("%%EndProlog");
        this.os.println();
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, (double)this.getSize().width, (double)this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        this.os.println();
        this.os.println("%%Trailer");
    }

    public void closeStream() throws IOException {
        this.ros.close();
        this.os.close();
    }

    protected Dimension getPageSize() {
        Dimension result;
        String pageSizeProperty = this.getProperty(PAGE_SIZE);
        Dimension dimension = result = CUSTOM_PAGE_SIZE.equals(pageSizeProperty) ? this.getPropertyDimension(CUSTOM_PAGE_SIZE) : PageConstants.getSize(this.getProperty(PAGE_SIZE));
        if (result == null) {
            result = PageConstants.getSize("A4");
        }
        return result;
    }

    protected void openPage(Dimension size, String title, Component component) {
        if (size == null) {
            size = component.getSize();
        }
        this.resetClip(new Rectangle(0, 0, size.width, size.height));
        Dimension pageSize = this.getPageSize();
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        this.os.println("save");
        this.os.println("procDict begin");
        this.os.println("printColorMap begin");
        this.os.println(pageSize.width + " " + pageSize.height + " setpagesize");
        this.os.println(margins.left + " " + margins.bottom + " " + margins.top + " " + margins.right + " setmargins");
        this.os.println("0 0 setorigin");
        this.os.println(size.width + " " + size.height + " setsize");
        this.os.println(this.isProperty(FIT_TO_PAGE) ? "fittopage" : "naturalsize");
        this.os.println(this.getProperty(ORIENTATION).equals("Portrait") ? "portrait" : "landscape");
        this.os.println("imagescale");
        this.os.println("cliptobounds");
        this.os.println("setbasematrix");
        this.os.println("/Helvetica 10 sf");
        this.os.println("defaultGraphicsState");
    }

    public void setHeader(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public void setFooter(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.println("q");
    }

    protected void writeGraphicsRestore() throws IOException {
        this.os.println("Q");
    }

    public void draw(Shape shape) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.writePath(shape);
                this.os.println("S");
            } else {
                boolean eofill = this.writePath(this.getStroke().createStrokedShape(shape));
                this.os.println(eofill ? "f*" : "f");
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            if (this.getPaint() instanceof Color || this.getPaint() instanceof GradientPaint && this.postscriptLevel >= 3) {
                boolean eofill = this.writePath(shape);
                this.os.println(eofill ? "f*" : "f");
            } else {
                this.writePaint(Color.black);
                this.fill(shape, this.getPaint());
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            if (this.getPaint() instanceof Color || this.getPaint() instanceof GradientPaint && this.postscriptLevel >= 3) {
                this.setPSColor(fillColor, true);
                boolean eofill = this.writePath(shape);
                this.os.println(eofill ? "B*" : "B");
            } else {
                this.writePaint(Color.black);
                this.fill(shape, this.getPaint());
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        byte[] imageBytes;
        String encode;
        this.writeGraphicsSave();
        if (bkg == null) {
            bkg = this.getBackground();
        }
        image = ImageUtilities.createRenderedImage(image, bkg);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform imageTransform = new AffineTransform((double)imageWidth, 0.0, 0.0, (double)imageHeight, 0.0, 0.0);
        xform.concatenate(imageTransform);
        this.writeTransform(xform);
        this.os.println("<<");
        this.os.println("/ImageType 1");
        this.os.println("/Width " + imageWidth + "  /Height " + imageHeight);
        this.os.println("/BitsPerComponent 8");
        this.os.println("/Decode [0 1 0 1 0 1]");
        this.os.println("/ImageMatrix [" + imageWidth + " 0 0 " + imageHeight + " 0 0]");
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        if ("ZLIB".equalsIgnoreCase(writeAs)) {
            encode = "Flate";
            imageBytes = ImageGraphics2D.toByteArray(image, "RAW", "Flate-ASCII85", ImageGraphics2D.getRAWProperties(bkg, "RGB"));
        } else if ("JPG".equalsIgnoreCase(writeAs)) {
            encode = "DCT";
            imageBytes = ImageGraphics2D.toByteArray(image, "JPG", "ASCII85", null);
        } else {
            byte[] flateBytes = ImageGraphics2D.toByteArray(image, "RAW", "Flate-ASCII85", ImageGraphics2D.getRAWProperties(bkg, "RGB"));
            byte[] jpgBytes = ImageGraphics2D.toByteArray(image, "JPG", "ASCII85", null);
            if ((double)jpgBytes.length < 0.5 * (double)flateBytes.length) {
                encode = "DCT";
                imageBytes = jpgBytes;
            } else {
                encode = "Flate";
                imageBytes = flateBytes;
            }
        }
        this.os.println("/DataSource currentfile /ASCII85Decode filter /" + encode + "Decode filter ");
        this.os.println(">> image");
        this.os.write(imageBytes);
        this.os.println("");
        this.writeGraphicsRestore();
    }

    protected void writeString(String str, double x, double y) throws IOException {
        this.showCharacterCodes(str, x, y);
    }

    protected void writeTransform(AffineTransform tx) throws IOException {
        this.os.println("[ " + this.fixedPrecision(tx.getScaleX()) + " " + this.fixedPrecision(tx.getShearY()) + " " + this.fixedPrecision(tx.getShearX()) + " " + this.fixedPrecision(tx.getScaleY()) + " " + this.fixedPrecision(tx.getTranslateX()) + " " + this.fixedPrecision(tx.getTranslateY()) + " ] concat");
    }

    protected void writeSetTransform(AffineTransform tx) throws IOException {
        this.os.println("[ " + this.fixedPrecision(tx.getScaleX()) + " " + this.fixedPrecision(tx.getShearY()) + " " + this.fixedPrecision(tx.getShearX()) + " " + this.fixedPrecision(tx.getScaleY()) + " " + this.fixedPrecision(tx.getTranslateX()) + " " + this.fixedPrecision(tx.getTranslateY()) + " ] defaultmatrix matrix concatmatrix setmatrix");
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null || !this.isProperty(CLIP)) {
            return;
        }
        if (s instanceof Rectangle) {
            this.os.println(((Rectangle)s).x + " " + ((Rectangle)s).y + " " + ((Rectangle)s).width + " " + ((Rectangle)s).height + " rc");
        } else if (s instanceof Rectangle2D) {
            this.os.println(this.fixedPrecision(((Rectangle2D)s).getX()) + " " + this.fixedPrecision(((Rectangle2D)s).getY()) + " " + this.fixedPrecision(((Rectangle2D)s).getWidth()) + " " + this.fixedPrecision(((Rectangle2D)s).getHeight()) + " rc");
        } else {
            boolean eofill = this.writePath(s);
            this.os.println(eofill ? "W*" : "W");
        }
    }

    protected void writeSetClip(Shape s) throws IOException {
        this.os.println("cliprestore");
        this.writeClip(s);
    }

    private boolean writePath(Shape s) throws IOException {
        this.os.println("newpath");
        PSPathConstructor path = new PSPathConstructor(this.os, true, false);
        return path.addPath(s);
    }

    protected void writeWidth(float width) throws IOException {
        this.os.println(this.fixedPrecision(width) + " w");
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            default: {
                this.os.println("0 J");
                break;
            }
            case 1: {
                this.os.println("1 J");
                break;
            }
            case 2: {
                this.os.println("2 J");
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.os.println("0 j");
                break;
            }
            case 1: {
                this.os.println("1 j");
                break;
            }
            case 2: {
                this.os.println("2 j");
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.println(this.fixedPrecision(limit) + " M");
    }

    protected void writeDash(float[] dash, float phase) throws IOException {
        this.os.print("[ ");
        for (int i = 0; i < dash.length; ++i) {
            this.os.print(this.fixedPrecision(dash[i]) + " ");
        }
        this.os.println("] " + this.fixedPrecision(phase) + " d");
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c) throws IOException {
        this.setPSColor(c, false);
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        if (this.postscriptLevel >= 3) {
            float[] rgb1 = paint.getColor1().getRGBColorComponents(null);
            float[] rgb2 = paint.getColor2().getRGBColorComponents(null);
            Point2D p1 = paint.getPoint1();
            Point2D p2 = paint.getPoint2();
            this.os.println("<< /PatternType 2");
            this.os.println("   /Shading");
            this.os.println("   << /ShadingType 2");
            this.os.println("      /ColorSpace /DeviceRGB");
            this.os.println("      /Coords [" + p1.getX() + " " + p1.getY() + " " + p2.getX() + " " + p2.getY() + "]");
            this.os.println("      /Function");
            this.os.println("      << /FunctionType 2");
            this.os.println("         /Domain [0 1]");
            this.os.println("         /Range [0 1 0 1 0 1]");
            this.os.println("         /C0 [" + rgb1[0] + " " + rgb1[1] + " " + rgb1[2] + "]");
            this.os.println("         /C1 [" + rgb2[0] + " " + rgb2[1] + " " + rgb2[2] + "]");
            this.os.println("         /N 1");
            this.os.println("      >>");
            this.os.println("      /Extend [true true]");
            this.os.println("   >>");
            this.os.println(">>");
            this.os.println("matrix makepattern setpattern");
        }
    }

    protected void writePaint(TexturePaint paint) throws IOException {
    }

    protected void writePaint(Paint p) throws IOException {
    }

    protected void writeFont(Font font) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public void writeComment(String s) throws IOException {
        this.os.println("% " + s);
    }

    public String toString() {
        return "PSGraphics2D";
    }

    public void showString(Font font, String str) {
        StringBuffer result = new StringBuffer();
        Hashtable<AttributedCharacterIterator.Attribute, Object> attributes = FontUtilities.getAttributes(font);
        PSFontTable.normalize(attributes);
        String fontName = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        result.append("/");
        result.append(fontName);
        result.append(" findfont ");
        result.append(font.getSize());
        result.append(" scalefont setfont");
        if (this.isProperty(EMBED_FONTS)) {
            result.append("\n");
            result.append(PSStringStyler.getEscaped(str));
            result.append(" show");
        } else {
            result.append(" ");
            result.append(PSStringStyler.getStyledString(attributes, str));
            result.append(" recshow");
        }
        this.os.println(result.toString());
    }

    private void showCharacterCodes(String str, double x, double y) throws IOException {
        boolean embedFonts = this.isProperty(EMBED_FONTS);
        this.writeGraphicsSave();
        AffineTransform at = new AffineTransform(1.0, 0.0, 0.0, 1.0, x, y);
        at.concatenate(this.getFont().getTransform());
        if (!embedFonts) {
            at.scale(1.0, -1.0);
        }
        this.writeTransform(at);
        this.os.println(this.fixedPrecision(0.0) + " " + this.fixedPrecision(0.0) + " moveto");
        if (embedFonts) {
            FontUtilities.showString(this.getFont(), str, this.fontTable.getEncodingTable(), this);
        } else {
            this.showString(this.getFont(), str);
        }
        this.writeGraphicsRestore();
    }

    private void setPSColor(Color c, boolean fillColor) {
        if (c != null) {
            if (c instanceof MappedColor) {
                MappedColor mc = (MappedColor)c;
                if (!fillColor) {
                    if (mc.getBrightness() == 0) {
                        this.os.println(mc.getColorTag() + " vg&C");
                    } else {
                        this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&C");
                    }
                } else if (mc.getBrightness() == 0) {
                    this.os.println(mc.getColorTag() + " vg&DFC");
                } else {
                    this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&DFC");
                }
            } else {
                Color pc = this.getPrintColor(c);
                double red = (double)pc.getRed() / 255.0;
                double green = (double)pc.getGreen() / 255.0;
                double blue = (double)pc.getBlue() / 255.0;
                this.os.print(this.fixedPrecision(red) + " " + this.fixedPrecision(green) + " " + this.fixedPrecision(blue) + " ");
                this.os.println(fillColor ? "rg" : "RG");
            }
        }
    }

    public String fixedPrecision(double d) {
        return this.scientific.format(d);
    }

    static {
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins("Small"));
        defaultProperties.setProperty(ORIENTATION, "Portrait");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(PREVIEW, false);
        defaultProperties.setProperty(PREVIEW_BITS, 8);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
    }
}

