/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.CMXException;
import com.ibm.db2.cmx.impl.CMXImplMessageHelper;
import com.ibm.db2.cmx.impl.ClientCacheFileImpl;
import com.ibm.db2.cmx.impl.DataSourceDescriptor;
import com.ibm.db2.cmx.impl.DriverDescriptor;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.GetSystemPropertyAction;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Utils {
    public static final String clientCacheFileBaseName__ = "cmxClientCacheFile";
    private static final String clientCacheLockFileBaseName__ = "cmxClientCacheFile.lock";
    private static File clientCacheLockFile__ = null;
    private static String clientCacheFilePath__ = null;
    private static DriverDescriptor driverDescriptor__ = null;
    private static int jreLevelMajor__ = 1;
    private static int jreLevelMinor__ = 5;
    private static Logger logger__ = Log.getCMXClientLogger();

    private static void initializeGlobalProperties() {
        String string = DataProperties.getProperty("pdq.cmx.clientCacheDirectory");
        if (string != null) {
            clientCacheLockFile__ = Utils.createNewFile(string + "/" + clientCacheLockFileBaseName__);
            clientCacheFilePath__ = string + "/" + clientCacheFileBaseName__;
        }
    }

    private static void initializeSystemProperties() {
        String string = Utils.getSystemProperty("java.version");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                int n3;
                try {
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                switch (n2++) {
                    case 0: {
                        jreLevelMajor__ = n3;
                        break;
                    }
                    case 1: {
                        jreLevelMinor__ = n3;
                        break;
                    }
                }
            }
        }
    }

    private static String getSystemProperty(String string) {
        String string2 = null;
        try {
            string2 = AccessController.doPrivileged(new GetSystemPropertyAction(string));
        }
        catch (AccessControlException accessControlException) {
            DataLogger.logThrowable(logger__, accessControlException);
            string2 = null;
        }
        return string2;
    }

    public static boolean jreVersion6OrGreaterPresent() {
        return jreLevelMajor__ > 1 || jreLevelMajor__ == 1 && jreLevelMinor__ >= 6;
    }

    public static boolean setFilePermission(File file) {
        try {
            Class<?> clazz = Class.forName("java.io.File");
            Method method = clazz.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, new Boolean(true), new Boolean(false));
            Method method2 = clazz.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            method2.invoke((Object)file, new Boolean(true), new Boolean(false));
            Method method3 = clazz.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            method3.invoke((Object)file, new Boolean(true), new Boolean(false));
            return true;
        }
        catch (Exception exception) {
            DataLogger.logThrowable(logger__, exception);
            return false;
        }
    }

    private static File createNewFile(final String string) {
        File file = null;
        try {
            file = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    File file = new File(string);
                    if (file.exists()) {
                        return file;
                    }
                    file.createNewFile();
                    if (Utils.jreVersion6OrGreaterPresent()) {
                        Utils.setFilePermission(file);
                    }
                    return file;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            DataLogger.logThrowable(logger__, privilegedActionException);
            file = null;
        }
        return file;
    }

    public static FileLock getLockOnLockFile(RandomAccessFile randomAccessFile) {
        FileChannel fileChannel = null;
        try {
            fileChannel = randomAccessFile.getChannel();
            if (fileChannel != null) {
                return fileChannel.lock();
            }
        }
        catch (Exception exception) {
            DataLogger.logThrowable(logger__, exception);
            return null;
        }
        return null;
    }

    private static RandomAccessFile getRandomAccessFile(final File file, final String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){

                @Override
                public RandomAccessFile run() throws FileNotFoundException {
                    return new RandomAccessFile(file, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            DataLogger.logThrowable(logger__, privilegedActionException);
            randomAccessFile = null;
        }
        return randomAccessFile;
    }

    private static FileLock getLock(File file) {
        RandomAccessFile randomAccessFile = Utils.getRandomAccessFile(file, "rw");
        if (randomAccessFile != null) {
            return Utils.getLockOnLockFile(randomAccessFile);
        }
        return null;
    }

    private static FileInputStream getFileInputStream(final String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    File file = new File(string);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    return fileInputStream;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            DataLogger.logThrowable(logger__, privilegedActionException);
            fileInputStream = null;
        }
        return fileInputStream;
    }

    private static FileOutputStream getFileOutputStream(final String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    File file = new File(string);
                    FileOutputStream fileOutputStream = null;
                    if (file.exists()) {
                        return new FileOutputStream(file);
                    }
                    fileOutputStream = new FileOutputStream(file);
                    if (Utils.jreVersion6OrGreaterPresent()) {
                        Utils.setFilePermission(file);
                    }
                    return fileOutputStream;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            DataLogger.logThrowable(logger__, privilegedActionException);
            fileOutputStream = null;
        }
        return fileOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Object[] readClientProfilesFromFile() {
        Object[] objectArray = new Object[1];
        File file = clientCacheLockFile__;
        String string = clientCacheFilePath__;
        FileLock fileLock = null;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, Utils.class, "readClientProfilesFromFile", "ENTRY ");
        }
        if (file != null) {
            fileLock = Utils.getLock(file);
        }
        if (fileLock != null) {
            ObjectInputStream objectInputStream = null;
            FileInputStream fileInputStream = Utils.getFileInputStream(string);
            if (fileInputStream != null) {
                try {
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    ClientCacheFileImpl clientCacheFileImpl = (ClientCacheFileImpl)objectInputStream.readObject();
                    objectArray[0] = clientCacheFileImpl;
                    objectInputStream.close();
                    objectInputStream = null;
                    fileInputStream.close();
                    fileInputStream = null;
                    fileLock.release();
                    fileLock = null;
                }
                catch (Exception exception) {
                    DataLogger.lowImpactLogger(logger__, Utils.class, "readClientProfilesFromFile", "WARNING: Unable to deserialize client cache file " + clientCacheFilePath__, exception);
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                            objectInputStream = null;
                        }
                        if (fileInputStream != null) {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                        fileLock.release();
                        fileLock = null;
                    }
                    catch (IOException iOException) {
                        DataLogger.logThrowable(logger__, iOException);
                    }
                    objectInputStream = null;
                    fileInputStream = null;
                    fileLock = null;
                }
                finally {
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                            fileLock = null;
                        }
                        catch (IOException iOException) {
                            DataLogger.logThrowable(logger__, iOException);
                        }
                        fileLock = null;
                    }
                }
            } else {
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, Utils.class, "readClientProfilesFromFile", "WARNING: Unable to read client cache file " + clientCacheFilePath__);
                }
                try {
                    fileLock.release();
                    fileLock = null;
                }
                catch (IOException iOException) {
                    DataLogger.logThrowable(logger__, iOException);
                }
                fileLock = null;
            }
        } else if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, Utils.class, "readClientProfilesFromFile", "WARNING: Unable to obtain lock file cmxClientCacheFile.lock to read client profiles from file.  Destination directory specified by property pdq.cmx.clientCacheDirectory=" + DataProperties.getProperty("pdq.cmx.clientCacheDirectory"));
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeClientProfilesToFile(boolean bl2) {
        FileLock fileLock = null;
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ClientCacheFileImpl clientCacheFileImpl = null;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, Utils.class, "writeClientProfilesToFile", "ENTRY " + Arrays.deepToString(new Object[]{bl2}));
        }
        if (clientCacheLockFile__ != null) {
            fileLock = Utils.getLock(clientCacheLockFile__);
        }
        if (fileLock != null) {
            Set<String> set = null;
            ControlDataSourceImpl controlDataSourceImpl = null;
            Map<String, ControlDataSourceImpl> map = ControlDataSourcePool.getInstance().getPool();
            try {
                clientCacheFileImpl = new ClientCacheFileImpl(clientCacheFilePath__, 12);
            }
            catch (CMXException cMXException) {
                DataLogger.lowImpactLogger(logger__, Utils.class, "writeClientProfilesToFile", "WARNING: Client cache file " + clientCacheFilePath__ + " does not have read and write permissions.", cMXException);
                try {
                    if (fileLock != null) {
                        fileLock.release();
                        fileLock = null;
                    }
                }
                catch (IOException iOException) {
                    DataLogger.logThrowable(logger__, iOException);
                }
                return;
            }
            if (driverDescriptor__ == null) {
                driverDescriptor__ = CMXImplMessageHelper.getInstance().newDriverDescriptor();
            }
            if (!bl2) {
                clientCacheFileImpl.writeDriver(driverDescriptor__, ControlDriver.getInstance().getDriverProfile());
                Map<String, ControlDataSourceImpl> map2 = map;
                synchronized (map2) {
                    set = map.keySet();
                    for (String string : set) {
                        controlDataSourceImpl = map.get(string);
                        if (controlDataSourceImpl.getControllerType() != Service.ControllerType.OCM) continue;
                        DataSourceDescriptor dataSourceDescriptor = CMXImplMessageHelper.getInstance().newDataSourceDescriptor(controlDataSourceImpl.getDataSourceDescriptorMap());
                        clientCacheFileImpl.writeDataSource(dataSourceDescriptor, controlDataSourceImpl.getDataSourceProfile());
                    }
                }
            }
            if ((fileOutputStream = Utils.getFileOutputStream(clientCacheFilePath__)) != null) {
                try {
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(clientCacheFileImpl);
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                        objectOutputStream = null;
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    fileLock.release();
                    fileLock = null;
                }
                catch (IOException iOException) {
                    DataLogger.lowImpactLogger(logger__, Utils.class, "writeClientProfilesToFile", "WARNING: Unable to serialize to client cache file " + clientCacheFilePath__, iOException);
                    try {
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                            objectOutputStream = null;
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                            fileOutputStream = null;
                        }
                        fileLock.release();
                        fileLock = null;
                    }
                    catch (IOException iOException2) {
                        DataLogger.logThrowable(logger__, iOException2);
                    }
                    objectOutputStream = null;
                    fileOutputStream = null;
                    fileLock = null;
                }
                finally {
                    try {
                        if (fileLock != null) {
                            fileLock.release();
                            fileLock = null;
                        }
                    }
                    catch (IOException iOException) {
                        DataLogger.logThrowable(logger__, iOException);
                    }
                    fileLock = null;
                }
            } else {
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, Utils.class, "writeClientProfilesToFile", "WARNING: Unable to write client cache file " + clientCacheFilePath__);
                }
                try {
                    fileLock.release();
                    fileLock = null;
                }
                catch (IOException iOException) {
                    DataLogger.logThrowable(logger__, iOException);
                }
                fileLock = null;
            }
        } else if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, Utils.class, "writeClientProfilesToFile", "WARNING: Unable to obtain lock file cmxClientCacheFile.lock to persist client profiles.  Destination directory specified by property pdq.cmx.clientCacheDirectory=" + DataProperties.getProperty("pdq.cmx.clientCacheDirectory"));
        }
    }

    public static boolean areStringsEqual(String string, String string2) {
        if (null == string && null == string2) {
            return true;
        }
        return null != string && string.equals(string2);
    }

    static {
        Utils.initializeSystemProperties();
        Utils.initializeGlobalProperties();
    }
}

