/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.shadow.com.formdev.flatlaf.ui;

import com.install4j.shadow.com.formdev.flatlaf.ui.FlatStylingSupport;
import com.install4j.shadow.com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FlatToolBarUI
extends BasicToolBarUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected boolean focusableButtons;
    @FlatStylingSupport.Styleable
    protected boolean arrowKeysOnlyNavigation;
    @FlatStylingSupport.Styleable
    protected Insets borderMargins;
    @FlatStylingSupport.Styleable
    protected Color gripColor;
    private FocusTraversalPolicy focusTraversalPolicy;
    private Boolean oldFloatable;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c) {
        return new FlatToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installFocusTraversalPolicy();
        this.installStyle();
        if (!this.focusableButtons) {
            this.setButtonsFocusable(false);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (!this.focusableButtons) {
            this.setButtonsFocusable(true);
        }
        this.uninstallFocusTraversalPolicy();
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.focusableButtons = UIManager.getBoolean("ToolBar.focusableButtons");
        this.arrowKeysOnlyNavigation = UIManager.getBoolean("ToolBar.arrowKeysOnlyNavigation");
        if (!UIManager.getBoolean("ToolBar.floatable")) {
            this.oldFloatable = this.toolBar.isFloatable();
            this.toolBar.setFloatable(false);
        } else {
            this.oldFloatable = null;
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.oldFloatable != null) {
            this.toolBar.setFloatable(this.oldFloatable);
            this.oldFloatable = null;
        }
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new BasicToolBarUI.ToolBarContListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                super.componentAdded(e);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(e.getChild(), false);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                super.componentRemoved(e);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(e.getChild(), true);
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.toolBar, this::installStyle, super.createPropertyListener());
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.toolBar, "ToolBar"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        boolean oldFocusableButtons = this.focusableButtons;
        boolean oldArrowKeysOnlyNavigation = this.arrowKeysOnlyNavigation;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
        if (this.focusableButtons != oldFocusableButtons) {
            this.setButtonsFocusable(this.focusableButtons);
        }
        if (this.arrowKeysOnlyNavigation != oldArrowKeysOnlyNavigation || this.focusableButtons != oldFocusableButtons) {
            if (this.arrowKeysOnlyNavigation) {
                this.installFocusTraversalPolicy();
            } else {
                this.uninstallFocusTraversalPolicy();
            }
        }
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.toolBar, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    protected void setButtonsFocusable(boolean focusable) {
        for (Component c : this.toolBar.getComponents()) {
            this.setButtonFocusable(c, focusable);
        }
    }

    private void setButtonFocusable(Component c, boolean focusable) {
        if (c instanceof AbstractButton && focusable != c.isFocusable()) {
            c.setFocusable(focusable);
        }
    }

    protected void installFocusTraversalPolicy() {
        if (!this.arrowKeysOnlyNavigation || !this.focusableButtons || this.toolBar.getFocusTraversalPolicy() != null) {
            return;
        }
        this.focusTraversalPolicy = this.createFocusTraversalPolicy();
        if (this.focusTraversalPolicy != null) {
            this.toolBar.setFocusTraversalPolicy(this.focusTraversalPolicy);
            this.toolBar.setFocusTraversalPolicyProvider(true);
        }
    }

    protected void uninstallFocusTraversalPolicy() {
        if (this.focusTraversalPolicy != null && this.toolBar.getFocusTraversalPolicy() == this.focusTraversalPolicy) {
            this.toolBar.setFocusTraversalPolicy(null);
            this.toolBar.setFocusTraversalPolicyProvider(false);
        }
        this.focusTraversalPolicy = null;
    }

    protected FocusTraversalPolicy createFocusTraversalPolicy() {
        return new FlatToolBarFocusTraversalPolicy();
    }

    @Override
    protected void navigateFocusedComp(int direction) {
        int add;
        int count = this.toolBar.getComponentCount();
        if (this.focusedCompIndex < 0 || this.focusedCompIndex >= count) {
            return;
        }
        switch (direction) {
            case 3: 
            case 5: {
                add = 1;
                break;
            }
            case 1: 
            case 7: {
                add = -1;
                break;
            }
            default: {
                return;
            }
        }
        for (int i = this.focusedCompIndex + add; i != this.focusedCompIndex; i += add) {
            if (i < 0) {
                i = count - 1;
            } else if (i >= count) {
                i = 0;
            }
            Component c = this.toolBar.getComponentAtIndex(i);
            if (!FlatToolBarUI.canBeFocusOwner(c)) continue;
            c.requestFocus();
            return;
        }
    }

    private static boolean canBeFocusOwner(Component c) {
        if (!(c != null && c.isEnabled() && c.isVisible() && c.isDisplayable() && c.isFocusable())) {
            return false;
        }
        if (c instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c;
            return comboBox.getUI().isFocusTraversable(comboBox);
        }
        if (c instanceof JComponent) {
            InputMap inputMap;
            for (inputMap = ((JComponent)c).getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
            }
            if (inputMap == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    protected void installRolloverBorders(JComponent c) {
    }

    @Override
    protected void installNonRolloverBorders(JComponent c) {
    }

    @Override
    protected void installNormalBorders(JComponent c) {
    }

    @Override
    protected Border createRolloverBorder() {
        return null;
    }

    @Override
    protected Border createNonRolloverBorder() {
        return null;
    }

    @Override
    public void setOrientation(int orientation) {
        Insets margin;
        Insets newMargin;
        if (orientation != this.toolBar.getOrientation() && !(newMargin = new Insets(margin.left, margin.top, margin.right, margin.bottom)).equals(margin = this.toolBar.getMargin())) {
            this.toolBar.setMargin(newMargin);
        }
        super.setOrientation(orientation);
    }

    protected class FlatToolBarFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected FlatToolBarFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (!(aComponent instanceof AbstractButton)) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            Component c = aComponent;
            while ((c = super.getComponentAfter(aContainer, c)) != null) {
                if (c instanceof AbstractButton) continue;
                return c;
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (!(aComponent instanceof AbstractButton)) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            Component c = aComponent;
            while ((c = super.getComponentBefore(aContainer, c)) != null) {
                if (c instanceof AbstractButton) continue;
                return c;
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.getRecentComponent(aContainer, true);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.getRecentComponent(aContainer, false);
        }

        private Component getRecentComponent(Container aContainer, boolean first) {
            if (FlatToolBarUI.this.focusedCompIndex >= 0 && FlatToolBarUI.this.focusedCompIndex < FlatToolBarUI.this.toolBar.getComponentCount()) {
                return FlatToolBarUI.this.toolBar.getComponent(FlatToolBarUI.this.focusedCompIndex);
            }
            return first ? super.getFirstComponent(aContainer) : super.getLastComponent(aContainer);
        }
    }
}

