/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.jydocking.ActiveDockableTracker;
import de.javasoft.swing.jydocking.DockableComponentWrapper;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockingEvent;
import de.javasoft.swing.jydocking.DockingPath;
import de.javasoft.swing.jydocking.DockingPortTracker;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.DockingStrategy;
import de.javasoft.swing.jydocking.DockingStrategyClassMapping;
import de.javasoft.swing.jydocking.DockingUtility;
import de.javasoft.swing.jydocking.DragManager;
import de.javasoft.swing.jydocking.FloatPolicyManager;
import de.javasoft.swing.jydocking.FloatingDialog;
import de.javasoft.swing.jydocking.FloatingFrame;
import de.javasoft.swing.jydocking.FloatingGroup;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockableFactory;
import de.javasoft.swing.jydocking.IDockingConstants;
import de.javasoft.swing.jydocking.IDockingEventListener;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IDockingStrategy;
import de.javasoft.swing.jydocking.IFloatingDockingPort;
import de.javasoft.swing.jydocking.IMinimizationManager;
import de.javasoft.swing.jydocking.IPerspectiveManager;
import de.javasoft.swing.jydocking.MinimizationManager;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveManager;
import de.javasoft.swing.jydocking.RegionChecker;
import de.javasoft.swing.jydocking.RestorationManager;
import de.javasoft.swing.jydocking.RootWindow;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingManager
implements IDockingConstants {
    private static final DockingManager INSTANCE = new DockingManager();
    private static final HashMap<String, IDockable> DOCKABLES_BY_ID = new HashMap();
    private static final WeakHashMap<JComponent, IDockable> DOCKABLES_BY_COMPONENT = new WeakHashMap();
    private static final DockingStrategyClassMapping DOCKING_STRATEGIES = new DockingStrategyClassMapping(DockingStrategy.class, new DockingStrategy());
    private static final WeakHashMap<IDockingPort, MaximizedState> maximizedStatesByRootPort = new WeakHashMap();
    private IDockableFactory dockableFactory;
    private IMinimizationManager minimizeManager;
    private AutoPersist autoPersister = new AutoPersist();
    private float defaultSiblingSize;
    private static boolean tabReorderEnabled;

    static {
        DockingManager.init();
    }

    private DockingManager() {
    }

    private static DockingManager getInstance() {
        return INSTANCE;
    }

    private static void init() {
        DragManager.prime();
        tabReorderEnabled = true;
        DockingManager.setMinimizeManager(MinimizationManager.class.getName());
        ActiveDockableTracker.getInstance();
        float f = 0.5f;
        String string = System.getProperty("docking.defaultSiblingSize");
        if (string != null) {
            f = Float.parseFloat(string);
        }
        DockingManager.setDefaultSiblingSize(f);
        Runtime.getRuntime().addShutdownHook(DockingManager.getInstance().autoPersister);
    }

    public static IDockable registerDockableComponent(JComponent jComponent) {
        if (jComponent instanceof IDockable) {
            return DockingManager.registerDockable((IDockable)((Object)jComponent));
        }
        return DockingManager.registerDockableComponent(jComponent, null);
    }

    public static void clear() {
        DockingManager.removeAll();
        for (String string : DockingManager.getDockableIDs()) {
            DockingManager.undock(DockingManager.getDockable(string));
        }
        IPerspectiveManager iPerspectiveManager = DockingManager.getPerspectiveManager();
        for (Perspective perspective : iPerspectiveManager.getPerspectives()) {
            iPerspectiveManager.removePerspective(perspective);
        }
        PerspectiveManager.setCurrentPerspectiveID(null, true);
        for (String string : DockingManager.getDockableIDs()) {
            DockingManager.unregisterDockable(DockingManager.getDockable(string));
        }
    }

    private static void removeAll() {
        Frame[] frameArray = JFrame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            if (frame instanceof JFrame) {
                JFrame jFrame = (JFrame)frame;
                IDockingPort iDockingPort = DockingManager.getRootDockingPort(jFrame);
                if (iDockingPort != null) {
                    iDockingPort.getComponent().getParent().remove(iDockingPort.getComponent());
                }
                ArrayList arrayList = new ArrayList();
                SyntheticaLookAndFeel.findComponents(Dockbar.class, (Container)jFrame, arrayList);
                for (Dockbar dockbar : arrayList) {
                    Container container = dockbar.getParent().getParent();
                    container.remove(dockbar.getParent());
                }
            }
            ++n2;
        }
    }

    public static IDockable registerDockableComponent(JComponent jComponent, String string) {
        return DockingManager.registerDockableComponent(jComponent, string, null);
    }

    private static IDockable registerDockableComponent(JComponent jComponent, String string, String string2) {
        IDockable iDockable;
        if (string == null) {
            string = DockingManager.determineTabText(jComponent, string2);
        }
        if ((iDockable = DockingManager.getDockable(jComponent)) == null) {
            String string3 = string2 == null ? DockingManager.generatePersistentId(jComponent, null) : string2;
            iDockable = new DockableComponentWrapper(jComponent, string3, string, true);
            if (string != null) {
                iDockable.setTabText(string);
            }
        }
        return DockingManager.registerDockable(iDockable);
    }

    private static String generatePersistentId(Object object, String string) {
        String string2 = string == null ? object.getClass().getName() : string;
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = 1;
        while (DockingManager.hasRegisteredDockableId(string2)) {
            stringBuffer.append("_").append(n);
            string2 = stringBuffer.toString();
            ++n;
        }
        return string2;
    }

    public static void unregisterDockableComponent(JComponent jComponent) {
        IDockable iDockable = DockingManager.getDockable(jComponent);
        DockingManager.unregisterDockable(iDockable);
    }

    public static IDockable registerDockable(IDockable iDockable) {
        if (iDockable.getComponent() == null || iDockable.getDragSources() == null) {
            throw new IllegalArgumentException("Dockable is invalid.");
        }
        if (iDockable.getID() == null) {
            throw new IllegalArgumentException("Dockable must have a non-null ID.");
        }
        DOCKABLES_BY_COMPONENT.put(iDockable.getComponent(), iDockable);
        iDockable.getComponent().putClientProperty(DockingUtility.DOCKABLE_INDICATOR, true);
        iDockable.getComponent().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CancelDockingDragOperation");
        iDockable.getComponent().getActionMap().put("CancelDockingDragOperation", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DragManager.getCurrentDragOperation() != null) {
                    DragManager.cancelCurrentDragOperation();
                }
            }
        });
        DockingManager.updateDragListeners(iDockable);
        iDockable.addDockingListener(iDockable);
        iDockable.addDockingListener(PerspectiveManager.getDockingStateListener());
        iDockable.addDockingListener(FloatPolicyManager.getInstance());
        DOCKABLES_BY_ID.put(iDockable.getID(), iDockable);
        DockingManager.dispatchEvent(new DockingEvent(iDockable, 0));
        return iDockable;
    }

    public static void unregisterDockable(IDockable iDockable) {
        DOCKABLES_BY_COMPONENT.remove(iDockable.getComponent());
        DockingManager.removeDragListeners(iDockable);
        iDockable.removeDockingListener(iDockable);
        iDockable.removeDockingListener(PerspectiveManager.getDockingStateListener());
        iDockable.removeDockingListener(FloatPolicyManager.getInstance());
        for (Perspective perspective : PerspectiveManager.getInstance().getPerspectives()) {
            perspective.getModel().remove(iDockable.getID());
        }
        DOCKABLES_BY_ID.remove(iDockable.getID());
        DockingManager.dispatchEvent(new DockingEvent(iDockable, 1));
    }

    public static void unregisterDockable(String string) {
        DockingManager.unregisterDockable(DockingManager.getDockable(string));
    }

    public static void removePerspective(String string) {
        IPerspectiveManager iPerspectiveManager = DockingManager.getPerspectiveManager();
        iPerspectiveManager.removePerspective(iPerspectiveManager.getPerspective(string));
    }

    public static void setDockableFactory(IDockableFactory iDockableFactory) {
        DockingManager.INSTANCE.dockableFactory = iDockableFactory;
    }

    public static IDockableFactory getDockableFactory() {
        return DockingManager.INSTANCE.dockableFactory;
    }

    public static void close(IDockable iDockable) {
        DockingManager.close(iDockable, DockingManager.getPerspective(iDockable));
    }

    static void close(IDockable iDockable, Perspective perspective) {
        if (DockingManager.isMaximized(iDockable)) {
            DockingManager.toggleMaximized(iDockable, perspective);
        }
        if (DockingManager.isDocked(iDockable)) {
            DockingManager.undock(iDockable);
        } else if (DockingManager.isMinimized(iDockable, perspective)) {
            DockingManager.getMinimizeManager().close(iDockable);
        }
    }

    public static boolean dockComponent(JComponent jComponent, IDockingPort iDockingPort) {
        return DockingManager.dockComponent(jComponent, iDockingPort, "CENTER");
    }

    public static boolean dockComponent(JComponent jComponent, IDockingPort iDockingPort, String string) {
        IDockable iDockable = DockingManager.resolveDockableComponent(jComponent);
        IDockingStrategy iDockingStrategy = DockingManager.getDockingStrategy(iDockingPort);
        if (iDockingStrategy != null) {
            return iDockingStrategy.dock(iDockable, iDockingPort, DockingManager.getPerspectiveManager().getCurrentPerspective(), string);
        }
        return false;
    }

    public static boolean dockComponent(JComponent jComponent, JComponent jComponent2) {
        return DockingManager.dockComponent(jComponent, jComponent2, null, -1.0f);
    }

    public static boolean dockComponent(JComponent jComponent, JComponent jComponent2, String string) {
        return DockingManager.dockComponent(jComponent, jComponent2, string, 0.5f);
    }

    public static boolean dockComponent(JComponent jComponent, JComponent jComponent2, String string, float f) {
        return DockingManager.dockComponent(jComponent, jComponent2, DockingManager.getPerspectiveManager().getCurrentPerspective(), string, f);
    }

    static boolean dockComponent(JComponent jComponent, JComponent jComponent2, Perspective perspective, String string, float f) {
        return DockingManager.dock(DockingManager.resolveDockableComponent(jComponent), DockingManager.resolveDockableComponent(jComponent2), perspective, string, f);
    }

    public static boolean undockComponent(JComponent jComponent) {
        return DockingManager.undock(DockingManager.getDockable(jComponent));
    }

    private static IDockable resolveDockableComponent(JComponent jComponent) {
        IDockable iDockable = DockingManager.getDockable(jComponent);
        return iDockable == null ? DockingManager.registerDockableComponent(jComponent) : iDockable;
    }

    public static boolean dock(IDockable iDockable, IDockingPort iDockingPort, String string) {
        return DockingManager.dock(iDockable, iDockingPort, DockingManager.getPerspectiveManager().getCurrentPerspective(), string);
    }

    static boolean dock(IDockable iDockable, IDockingPort iDockingPort, Perspective perspective, String string) {
        IDockingStrategy iDockingStrategy;
        IDockingPort iDockingPort2 = DockingManager.getRootDockingPort(iDockable.getComponent());
        IDockable iDockable2 = DockingManager.getMaximizedDockable(iDockingPort2);
        if (iDockable2 != null) {
            DockingManager.toggleMaximized(iDockable2, perspective);
        }
        if ((iDockingStrategy = DockingManager.getDockingStrategy(iDockingPort)) != null) {
            return iDockingStrategy.dock(iDockable, iDockingPort, perspective, string);
        }
        return false;
    }

    public static boolean dock(IDockable iDockable, IDockable iDockable2, String string) {
        return DockingManager.dock(iDockable, iDockable2, string, 0.5f);
    }

    public static boolean dock(IDockable iDockable, IDockable iDockable2, String string, float f) {
        return DockingManager.dock(iDockable, iDockable2, DockingManager.getPerspectiveManager().getCurrentPerspective(), string, f);
    }

    static boolean dock(IDockable iDockable, IDockable iDockable2, Perspective perspective, String string, float f) {
        return DockingManager.dockRelative(iDockable, iDockable2, perspective, string, f);
    }

    static boolean dockRelative(IDockable iDockable, IDockable iDockable2, Perspective perspective, String string) {
        return DockingManager.dockRelative(iDockable2, iDockable, perspective, string, -1.0f);
    }

    static boolean dockRelative(final IDockable iDockable, final IDockable iDockable2, final Perspective perspective, String string, float f) {
        IDockingPort iDockingPort;
        if (iDockable2 == null || iDockable == null || !DockingManager.isValidDockingRegion(string)) {
            return false;
        }
        if (DockingManager.isFloating(iDockable2)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DockingState dockingState = perspective.getModel().getDockingState(iDockable, false);
                    if (dockingState.getPath() == null) {
                        DockingState dockingState2 = perspective.getModel().getDockingState(iDockable2, false);
                        dockingState.setPath((DockingPath)dockingState2.getPath().clone());
                        dockingState.setFloatingGroupID(dockingState2.getFloatingGroupID());
                    }
                }
            });
        }
        if (f == -1.0f) {
            f = 0.5f;
        }
        if (string == null) {
            string = "CENTER";
        }
        if (f != -1.0f && !"CENTER".equals(string) && DockingManager.isValidDockingRegion(string)) {
            iDockable2.setSiblingSize(string, RegionChecker.validateSiblingSize(f));
        }
        if ((iDockingPort = iDockable2.getDockingPort()) != null) {
            return DockingManager.dock(iDockable, iDockingPort, perspective, string);
        }
        return false;
    }

    public static boolean undock(String string) {
        return DockingManager.undock(DockingManager.getDockable(string));
    }

    public static boolean undock(IDockable iDockable) {
        if (iDockable == null) {
            return false;
        }
        IDockingStrategy iDockingStrategy = DockingManager.findDockingStrategy(iDockable);
        if (iDockingStrategy != null) {
            return iDockingStrategy.undock(iDockable);
        }
        return false;
    }

    public static void setMinimized(IDockable iDockable, boolean bl) {
        DockingManager.setMinimized(iDockable, DockingManager.getPerspective(iDockable), bl);
    }

    static void setMinimized(IDockable iDockable, Perspective perspective, boolean bl) {
        DockingManager.setMinimized(iDockable, perspective, bl, -1);
    }

    public static void setMinimized(IDockable iDockable, boolean bl, int n) {
        DockingManager.setMinimized(iDockable, DockingManager.getPerspective(iDockable), bl, n);
    }

    static void setMinimized(IDockable iDockable, Perspective perspective, boolean bl, int n) {
        JComponent jComponent = iDockable == null ? null : iDockable.getComponent();
        Window window = jComponent == null ? null : SwingUtilities.getWindowAncestor(jComponent);
        DockingManager.setMinimized(iDockable, perspective, bl, window, n);
    }

    static void setMinimized(IDockable iDockable, Perspective perspective, boolean bl, Component component, int n) {
        Component component2;
        Window window = SwingUtilities.getWindowAncestor(iDockable.getComponent());
        Component component3 = component2 = window == null ? null : window.getFocusOwner();
        if (DockingManager.getMaximizedDockable(DockingManager.getRootDockingPort(iDockable.getComponent())) != null) {
            DockingManager.setMaximized(DockingManager.getMaximizedDockable(DockingManager.getRootDockingPort(iDockable.getComponent())), perspective, false);
        } else if (DockingManager.isFloating(iDockable)) {
            DockingManager.setFloating(iDockable, perspective, false, null);
        }
        if (component == null) {
            component = DockingUtility.getActiveWindow();
        }
        DockingManager.getMinimizeManager().setMinimized(iDockable, perspective, bl, component, n);
        ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), component2, true);
    }

    public static void setMaximized(IDockable iDockable, boolean bl) {
        DockingManager.setMaximized(iDockable, DockingManager.getPerspective(iDockable), bl);
    }

    static void setMaximized(IDockable iDockable, Perspective perspective, boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(iDockable.getComponent());
        Component component = window == null ? null : window.getFocusOwner();
        DockingState dockingState = perspective.getDockingState(iDockable, false);
        if (!(dockingState.isMaximized() || DockingManager.isFloating(iDockable) || DockingManager.isMinimized(iDockable))) {
            perspective.updateRestorationLayoutNode(DockingManager.getRootDockingPort(iDockable.getComponent()));
        }
        DockingManager.toggleMaximized(iDockable, perspective);
        SwingUtilities.getRootPane(iDockable.getComponent()).repaint();
        dockingState.setMaximized(bl);
        if (bl) {
            ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), component, true);
        }
    }

    static void toggleMaximized(IDockable iDockable, Perspective perspective) {
        IDockable iDockable2;
        IDockingPort iDockingPort = DockingManager.getRootDockingPort(iDockable.getComponent());
        if (DockingManager.isFloating(iDockable)) {
            iDockingPort = DockingManager.getDockingState(iDockable, perspective).getPath().getRootDockingPort();
        }
        if ((iDockable2 = DockingManager.getMaximizedDockable(iDockingPort)) == null) {
            if (DockingManager.isMinimized(iDockable, perspective)) {
                DockingManager.setMinimized(iDockable, perspective, false);
            } else if (DockingManager.isFloating(iDockable)) {
                DockingManager.setFloating(iDockable, perspective, false, null);
            }
        }
        if (iDockable2 != null) {
            if (iDockable2 != iDockable) {
                DockingManager.setMaximized(iDockable2, perspective, false);
                DockingManager.setMaximized(iDockable, perspective, true);
            } else {
                DockingManager.restore(iDockable);
            }
        } else {
            IDockingPort iDockingPort2 = iDockable.getDockingPort();
            MaximizedState maximizedState = new MaximizedState(iDockable, iDockingPort2);
            if (iDockingPort2 != null) {
                iDockingPort2.releaseForMaximization(iDockable);
            } else {
                iDockingPort = DockingManager.getDockingState(iDockable, perspective).getPath().getRootDockingPort();
            }
            iDockingPort.installMaximizedDockable(iDockable);
            maximizedStatesByRootPort.put(iDockingPort, maximizedState);
        }
    }

    public static void setFloating(IDockable iDockable, boolean bl) {
        DockingManager.setFloating(iDockable, bl, null);
    }

    public static void setFloating(IDockable iDockable, boolean bl, Rectangle rectangle) {
        DockingManager.setFloating(iDockable, DockingManager.getPerspective(iDockable), bl, rectangle);
    }

    static void setFloating(IDockable iDockable, Perspective perspective, boolean bl, Rectangle rectangle) {
        if (bl) {
            Component component;
            Object object;
            JComponent jComponent = iDockable.getComponent();
            if (jComponent.isShowing() && rectangle == null) {
                object = jComponent.getLocationOnScreen();
                rectangle = new Rectangle(((Point)object).x, ((Point)object).y, jComponent.getWidth(), jComponent.getHeight());
            }
            if (DockingManager.isMaximized(iDockable)) {
                DockingManager.setMaximized(iDockable, perspective, false);
            } else if (DockingManager.isMinimized(iDockable, perspective)) {
                DockingManager.setMinimized(iDockable, perspective, false);
            }
            object = RootWindow.getRootWindow(jComponent);
            Component component2 = component = object != null ? ((RootWindow)object).getRootComponent() : DockingPortTracker.getDockingRootWindows().get(0).getRootComponent();
            if (rectangle == null) {
                DockingManager.floatDockable(iDockable, component, perspective);
            } else {
                DockingManager.floatDockable(iDockable, component, perspective, rectangle);
            }
        } else {
            DockingPath dockingPath = DockingManager.getDockingState(iDockable, perspective).getPath();
            IDockingPort iDockingPort = dockingPath.getRootDockingPort();
            IDockable iDockable2 = DockingManager.getMaximizedDockable(iDockingPort);
            if (iDockable2 != null) {
                DockingManager.toggleMaximized(iDockable2, perspective);
                perspective.getDockingState(iDockable2, false).setMaximized(false);
            }
            Component component = SwingUtilities.getWindowAncestor(iDockable.getComponent()).getFocusOwner();
            DockingManager.undock(iDockable);
            if (dockingPath != null) {
                dockingPath.restore(iDockable, perspective);
            }
            DockingManager.removeFromFloatingGroup(iDockable);
            ActiveDockableTracker.requestDockableActivation(iDockable.getComponent(), component, true);
            iDockable.getComponent().firePropertyChange("floating", true, false);
        }
    }

    static void addToFloatingGroup(IDockable iDockable, String string) {
        FloatingGroup floatingGroup = DockingManager.getFloatingGroup(string);
        if (iDockable != null && floatingGroup != null && !floatingGroup.hasDockable(iDockable.getID())) {
            DockingManager.removeFromFloatingGroup(iDockable);
            floatingGroup.addDockable(iDockable.getID());
            DockingManager.setCurrentFloatingGroupID(iDockable, floatingGroup.getID());
        }
    }

    static void removeFromFloatingGroup(IDockable iDockable) {
        FloatingGroup floatingGroup = DockingManager.getFloatingGroup(iDockable);
        if (iDockable != null) {
            if (floatingGroup != null) {
                floatingGroup.removeDockable(iDockable.getID());
            }
            DockingManager.setCurrentFloatingGroupID(iDockable, null);
        }
        if (floatingGroup != null && floatingGroup.getDockableCount() == 0) {
            DockingManager.getPerspective(iDockable).getModel().removeFloatingGroup(floatingGroup.getID());
            floatingGroup.destroy();
        }
    }

    static Window floatDockable(IDockable iDockable, Component component, Perspective perspective) {
        Rectangle rectangle;
        FloatingGroup floatingGroup = DockingManager.getFloatingGroup(iDockable);
        Rectangle rectangle2 = rectangle = floatingGroup == null ? null : floatingGroup.getBounds();
        if (rectangle == null) {
            rectangle = iDockable.getComponent().isValid() ? iDockable.getComponent().getBounds() : new Rectangle(0, 0, 200, 200);
            boolean bl = component instanceof FloatingDialog || component instanceof FloatingFrame;
            Window window = null;
            if (bl) {
                window = ((Window)component).getOwner();
            }
            Rectangle rectangle3 = window != null && window.getBounds() != null ? window.getBounds() : RootWindow.getRootWindow(component).getRootComponent().getBounds();
            int n = rectangle3.x + rectangle3.width / 2 - rectangle.width / 2;
            int n2 = rectangle3.y + rectangle3.height / 2 - rectangle.height / 2;
            rectangle.setLocation(n, n2);
        }
        return DockingManager.floatDockable(iDockable, component, perspective, rectangle);
    }

    static Window floatDockable(IDockable iDockable, Component component, Perspective perspective, Rectangle rectangle) {
        if (iDockable == null || rectangle == null) {
            return null;
        }
        Window window = DockingManager.getDockingWindow(iDockable, component);
        if (rectangle != null) {
            rectangle = SyntheticaLookAndFeel.validateWindowBounds(rectangle);
            window.setBounds(rectangle);
        }
        DockingManager.undock(iDockable);
        if (window instanceof FloatingDialog) {
            ((FloatingDialog)window).addDockable(iDockable, perspective);
        }
        if (window instanceof FloatingFrame) {
            ((FloatingFrame)window).addDockable(iDockable, perspective);
        }
        iDockable.getComponent().firePropertyChange("floatingWindowAncestor", false, true);
        if (!window.isVisible()) {
            window.setVisible(true);
        }
        RootWindow.getRootWindow(iDockable.getComponent()).setPerspectiveID(perspective.getID());
        iDockable.getComponent().firePropertyChange("floating", false, true);
        return window;
    }

    private static Window getDockingWindow(IDockable iDockable, Component component) {
        Perspective perspective = DockingManager.getPerspective(iDockable);
        FloatingGroup floatingGroup = DockingManager.getFloatingGroup(iDockable);
        if (floatingGroup == null) {
            floatingGroup = new FloatingGroup(perspective.getModel().getDockingState(iDockable, false).getFloatingGroupID());
        } else if (floatingGroup != null && !perspective.isLoading()) {
            floatingGroup.removeDockable(iDockable.getID());
            floatingGroup = new FloatingGroup(null);
        }
        Window window = floatingGroup.getFloatingWindow();
        if (window == null) {
            boolean bl = SyntheticaLookAndFeel.getBoolean("JYDocking.floatingWindow.isDialog", null, true);
            window = DockingManager.createFloatingWindow(component, floatingGroup.getID(), bl);
            floatingGroup.setFloatingWindow(window);
            perspective.getModel().addFloatingGroup(floatingGroup);
        }
        return window;
    }

    private static Window createFloatingWindow(Component component, String string, boolean bl) {
        RootWindow rootWindow = RootWindow.getRootWindow(component);
        Component component2 = rootWindow.getRootComponent();
        if (component2 instanceof FloatingDialog || component2 instanceof FloatingFrame) {
            Component component3 = component2 = ((Window)component2).getOwner() == null ? component2 : ((Window)component2).getOwner();
        }
        if (component2 instanceof Applet) {
            component2 = SwingUtilities.windowForComponent(component2);
        }
        if (component2 instanceof Frame) {
            return bl ? new FloatingDialog((Frame)component2, string) : new FloatingFrame((Frame)component2, string);
        }
        if (component2 instanceof Dialog) {
            return bl ? new FloatingDialog((Dialog)component2, string) : new FloatingFrame(string);
        }
        return null;
    }

    public static FloatingGroup getFloatingGroup(IDockable iDockable) {
        Perspective perspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        DockingState dockingState = perspective.getModel().getDockingState(iDockable, false);
        return dockingState == null ? null : DockingManager.getFloatingGroup(dockingState.getFloatingGroupID());
    }

    static FloatingGroup getFloatingGroup(String string) {
        return DockingManager.getPerspectiveManager().getCurrentPerspective().getModel().getFloatingGroup(string);
    }

    private static void setCurrentFloatingGroupID(IDockable iDockable, String string) {
        DockingState dockingState = DockingManager.getPerspectiveManager().getCurrentPerspective().getModel().getDockingState(iDockable, false);
        if (dockingState != null) {
            dockingState.setFloatingGroupID(string);
        }
    }

    public static boolean restore(IDockable iDockable) {
        return RestorationManager.getInstance().restore(iDockable, DockingManager.getPerspective(iDockable));
    }

    public static boolean isComponentDocked(JComponent jComponent) {
        return DockingManager.getDockingPort(jComponent) != null;
    }

    public static boolean isDocked(IDockable iDockable) {
        return DockingManager.getDockingPort(iDockable) != null;
    }

    public static boolean isDocked(IDockingPort iDockingPort, IDockable iDockable) {
        return iDockingPort == null || iDockable == null ? false : iDockingPort.isParentDockingPort(iDockable.getComponent());
    }

    public static boolean isMaximized(IDockable iDockable) {
        IDockingPort iDockingPort = DockingManager.getRootDockingPort(iDockable.getComponent());
        IDockable iDockable2 = DockingManager.getMaximizedDockable(iDockingPort);
        return iDockable2 != null && iDockable2.equals(iDockable);
    }

    public static boolean isMinimized(IDockable iDockable) {
        return DockingManager.isMinimized(iDockable, DockingManager.getPerspective(iDockable));
    }

    static boolean isMinimized(IDockable iDockable, Perspective perspective) {
        DockingState dockingState = DockingManager.getDockingState(iDockable, perspective);
        return dockingState == null ? false : dockingState.isMinimized();
    }

    public static boolean isFloating(IDockable iDockable) {
        return DockingManager.getRootDockingPort(iDockable.getComponent()) instanceof IFloatingDockingPort;
    }

    public static boolean isFloatingEnabled() {
        return FloatPolicyManager.getInstance().isGlobalFloatingEnabled();
    }

    public static void setFloatingEnabled(boolean bl) {
        FloatPolicyManager.getInstance().setGlobalFloatingEnabled(bl);
    }

    public static boolean isTabReorderByDraggingEnabled() {
        return tabReorderEnabled;
    }

    public static void setTabReorderByDraggingEnabled(boolean bl) {
        tabReorderEnabled = bl;
    }

    public static IPerspectiveManager getPerspectiveManager() {
        return PerspectiveManager.getInstance();
    }

    private static Perspective getPerspective(IDockable iDockable) {
        RootWindow rootWindow = RootWindow.getRootWindow(iDockable.getComponent());
        if (rootWindow != null) {
            return DockingManager.getPerspectiveManager().getPerspective(rootWindow.getPerspectiveID());
        }
        return DockingManager.getPerspectiveManager().getCurrentPerspective();
    }

    public static void setDockingStrategy(Class<?> clazz, IDockingStrategy iDockingStrategy) {
        if (iDockingStrategy == null) {
            DOCKING_STRATEGIES.removeStrategyClassMapping(clazz);
        } else {
            DOCKING_STRATEGIES.addStrategyClassMapping(clazz, iDockingStrategy.getClass(), iDockingStrategy);
        }
    }

    public static IDockingStrategy getDockingStrategy(Object object) {
        Class<?> clazz = object == null ? null : object.getClass();
        return DockingManager.getDockingStrategy(clazz);
    }

    public static IDockingStrategy getDockingStrategy(Class<?> clazz) {
        IDockingStrategy iDockingStrategy = DOCKING_STRATEGIES.getStrategy(clazz);
        return iDockingStrategy;
    }

    private static IDockingStrategy findDockingStrategy(IDockable iDockable) {
        IDockingStrategy iDockingStrategy;
        IDockingPort iDockingPort = iDockable.getDockingPort();
        IDockingStrategy iDockingStrategy2 = iDockingStrategy = iDockingPort == null ? null : iDockingPort.getDockingStrategy();
        if (iDockingStrategy == null) {
            iDockingStrategy = DockingManager.getDockingStrategy(DockingStrategy.class);
        }
        return iDockingStrategy;
    }

    public static void updateDragListeners(IDockable iDockable) {
        DragManager dragManager = DockingManager.getDragListener(iDockable);
        if (dragManager == null) {
            dragManager = new DragManager(iDockable);
        }
        for (JComponent jComponent : iDockable.getDragSources()) {
            DockingManager.updateDragListeners(jComponent, dragManager);
        }
    }

    private static void updateDragListeners(JComponent jComponent, DragManager dragManager) {
        EventListener eventListener;
        MouseMotionListener mouseMotionListener = null;
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        int n = mouseMotionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            eventListener = mouseMotionListenerArray[n2];
            if (eventListener instanceof DragManager) {
                mouseMotionListener = eventListener;
                break;
            }
            ++n2;
        }
        if (mouseMotionListener != dragManager) {
            if (mouseMotionListener != null) {
                jComponent.removeMouseMotionListener(mouseMotionListener);
            }
            jComponent.addMouseMotionListener(dragManager);
        }
        eventListener = null;
        MouseListener[] mouseListenerArray = jComponent.getMouseListeners();
        int n3 = mouseListenerArray.length;
        n = 0;
        while (n < n3) {
            MouseListener mouseListener = mouseListenerArray[n];
            if (mouseListener instanceof DragManager) {
                eventListener = mouseListener;
                break;
            }
            ++n;
        }
        if (eventListener != dragManager) {
            if (eventListener != null) {
                jComponent.removeMouseListener((MouseListener)eventListener);
            }
            jComponent.addMouseListener(dragManager);
        }
    }

    public static void removeDragListeners(JComponent jComponent) {
        EventListener eventListener;
        EventListener[] eventListenerArray = jComponent.getMouseMotionListeners();
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            eventListener = eventListenerArray[n2];
            if (eventListener instanceof DragManager) {
                jComponent.removeMouseMotionListener((MouseMotionListener)eventListener);
                break;
            }
            ++n2;
        }
        eventListenerArray = jComponent.getMouseListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            eventListener = eventListenerArray[n2];
            if (eventListener instanceof DragManager) {
                jComponent.removeMouseListener((MouseListener)eventListener);
                break;
            }
            ++n2;
        }
    }

    static IDockable getMaximizedDockable(IDockingPort iDockingPort) {
        MaximizedState maximizedState = maximizedStatesByRootPort.get(iDockingPort);
        return maximizedState == null ? null : maximizedState.getDockable();
    }

    static void returnFromMaximization(IDockingPort iDockingPort) {
        MaximizedState maximizedState = maximizedStatesByRootPort.get(iDockingPort);
        if (maximizedState != null && maximizedState.getOriginalPort() != null) {
            maximizedState.getOriginalPort().returnFromMaximization();
        }
    }

    static void removeMaximizedState(IDockingPort iDockingPort) {
        maximizedStatesByRootPort.remove(iDockingPort);
    }

    static IMinimizationManager getMinimizeManager() {
        return DockingManager.getInstance().minimizeManager;
    }

    static DockingState getDockingState(IDockable iDockable, Perspective perspective) {
        return perspective.getDockingState(iDockable, false);
    }

    public static void setAutoPersist(boolean bl) {
        DockingManager.getInstance().autoPersister.setEnabled(bl);
    }

    public static void setDockableComponentSplitProportion(JComponent jComponent, float f) {
        DockingManager.setSplitProportion(DockingManager.getDockable(jComponent), f);
    }

    public static void setSplitProportion(IDockable iDockable, float f) {
        DockingUtility.setSplitProportion(iDockable, f);
    }

    public static void setSplitProportion(IDockingPort iDockingPort, float f) {
        DockingUtility.setSplitProportion(iDockingPort, f);
    }

    static void setMinimizeManager(IMinimizationManager iMinimizationManager) {
        DockingManager.getInstance().minimizeManager = iMinimizationManager;
    }

    static void setMinimizeManager(String string) {
        Object object = DockingUtility.getInstance(string);
        DockingManager.setMinimizeManager((IMinimizationManager)object);
    }

    public static void removeDragListeners(IDockable iDockable) {
        for (JComponent jComponent : iDockable.getDragSources()) {
            if (!(jComponent instanceof JComponent)) continue;
            DockingManager.removeDragListeners(jComponent);
        }
    }

    public static float getDefaultSiblingSize() {
        return DockingManager.getInstance().defaultSiblingSize;
    }

    public static void setDefaultSiblingSize(float f) {
        f = Math.max(f, 0.0f);
        DockingManager.getInstance().defaultSiblingSize = f = Math.min(f, 1.0f);
    }

    public static IDockingPort getRootDockingPort(Component component) {
        return DockingPortTracker.getRootDockingPort(component);
    }

    public static IDockingPort getDockingPort(Component component) {
        return DockingUtility.getParentDockingPort(component);
    }

    public static IDockingPort getDockingPort(IDockable iDockable) {
        return DockingUtility.getParentDockingPort(iDockable);
    }

    public static IDockable getDockable(Component component) {
        return DOCKABLES_BY_COMPONENT.get(component);
    }

    public static IDockable getDockable(String string) {
        return DOCKABLES_BY_ID.get(string);
    }

    public static Set<String> getDockableIDs() {
        return new HashSet<String>(DOCKABLES_BY_ID.keySet());
    }

    static void setDockbarManager(String string) {
        DockbarManager.setDockbarManager(string);
    }

    static DockbarManager getDockbarManager() {
        return DockbarManager.getCurrent();
    }

    static DragManager getDragListener(IDockable iDockable) {
        if (iDockable == null || iDockable.getDragSources() == null) {
            return null;
        }
        for (JComponent jComponent : iDockable.getDragSources()) {
            DragManager dragManager = DockingManager.getDragListener(jComponent);
            if (dragManager == null) continue;
            return dragManager;
        }
        return null;
    }

    static boolean storeLayoutModel() throws IOException {
        IPerspectiveManager iPerspectiveManager = DockingManager.getPerspectiveManager();
        return iPerspectiveManager == null ? false : iPerspectiveManager.storePerspectives(null, null);
    }

    static void dispatchEvent(DockingEvent dockingEvent) {
        DockingManager.dispatchEvent(dockingEvent, false, false);
    }

    static void dispatchEvent(DockingEvent dockingEvent, boolean bl, boolean bl2) {
        IDockable iDockable = dockingEvent.getDockable();
        List<IDockingEventListener> list = iDockable.getDockingListeners();
        DockingManager.dispatchEvent(dockingEvent, list);
        if (bl && dockingEvent.getOldDockingPort() != null) {
            list = dockingEvent.getOldDockingPort().getDockingListeners();
            DockingManager.dispatchEvent(dockingEvent, list);
        }
        if (bl2 && dockingEvent.getNewDockingPort() != null) {
            list = dockingEvent.getNewDockingPort().getDockingListeners();
            DockingManager.dispatchEvent(dockingEvent, list);
        }
    }

    static boolean isValidDockingRegion(String string) {
        return "CENTER".equals(string) || "NORTH".equals(string) || "SOUTH".equals(string) || "EAST".equals(string) || "WEST".equals(string);
    }

    private static String determineTabText(JComponent jComponent, String string) {
        String string2 = null;
        if (string2 == null) {
            string2 = jComponent.getName();
        }
        if (string2 == null) {
            string2 = string;
        }
        String string3 = string2 = string2 == null ? "null" : string2.trim();
        if (string2.length() == 0) {
            string2 = "null";
        }
        return string2;
    }

    private static boolean hasRegisteredDockableId(String string) {
        return DOCKABLES_BY_ID.containsKey(string);
    }

    private static DragManager getDragListener(JComponent jComponent) {
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        int n = 0;
        while (n < mouseMotionListenerArray.length) {
            if (mouseMotionListenerArray[n] instanceof DragManager) {
                return (DragManager)mouseMotionListenerArray[n];
            }
            ++n;
        }
        return null;
    }

    private static void dispatchEvent(DockingEvent dockingEvent, List<IDockingEventListener> list) {
        for (IDockingEventListener iDockingEventListener : list) {
            switch (dockingEvent.getEventType()) {
                case 0: {
                    iDockingEventListener.dockableRegistered(dockingEvent);
                    break;
                }
                case 1: {
                    iDockingEventListener.dockableUnregistered(dockingEvent);
                    break;
                }
                case 2: {
                    iDockingEventListener.dragStarted(dockingEvent);
                    break;
                }
                case 3: {
                    iDockingEventListener.dropStarted(dockingEvent);
                    break;
                }
                case 4: {
                    iDockingEventListener.dockingCompleted(dockingEvent);
                    break;
                }
                case 5: {
                    iDockingEventListener.dockingCanceled(dockingEvent);
                    break;
                }
                case 6: {
                    iDockingEventListener.undockingCompleted(dockingEvent);
                    break;
                }
                case 7: {
                    iDockingEventListener.undockingStarted(dockingEvent);
                }
            }
        }
    }

    private static class AutoPersist
    extends Thread {
        private boolean enabled;

        private AutoPersist() {
        }

        public void run() {
            this.store();
        }

        private void store() {
            try {
                if (this.isEnabled()) {
                    DockingManager.storeLayoutModel();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    private static class MaximizedState {
        private final IDockable dockable;
        private final IDockingPort originalPort;

        public MaximizedState(IDockable iDockable, IDockingPort iDockingPort) {
            this.dockable = iDockable;
            this.originalPort = iDockingPort;
        }

        public IDockable getDockable() {
            return this.dockable;
        }

        public IDockingPort getOriginalPort() {
            return this.originalPort;
        }
    }
}

