/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.Event;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.Perspective;
import java.awt.AWTEvent;
import java.awt.Component;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockingEvent
extends Event {
    private static final long serialVersionUID = 6068788655735960200L;
    public static final int DOCKABLE_REGISTERED = 0;
    public static final int DOCKABLE_UNREGISTERED = 1;
    public static final int DRAG_STARTED = 2;
    public static final int DROP_STARTED = 3;
    public static final int DOCKING_COMPLETED = 4;
    public static final int DOCKING_CANCELED = 5;
    public static final int UNDOCKING_COMPLETED = 6;
    public static final int UNDOCKING_STARTED = 7;
    private IDockingPort oldPort;
    private IDockingPort newPort;
    private boolean consumed;
    private AWTEvent trigger;
    private String region;
    private boolean overWindow;
    private Map<Object, Object> dragContext;
    private Perspective perspective;

    public DockingEvent(IDockable iDockable, int n) {
        this(iDockable, null, null, n, null, null);
    }

    public DockingEvent(IDockable iDockable, IDockingPort iDockingPort, IDockingPort iDockingPort2, int n, Map<Object, Object> map) {
        this(iDockable, iDockingPort, iDockingPort2, n, null, map);
    }

    public DockingEvent(IDockable iDockable, IDockingPort iDockingPort, IDockingPort iDockingPort2, int n, AWTEvent aWTEvent, Map<Object, Object> map) {
        super(iDockable, n);
        this.oldPort = iDockingPort;
        this.newPort = iDockingPort2;
        this.trigger = aWTEvent;
        this.region = "UNKNOWN";
        this.dragContext = map;
        this.setOverWindow(true);
    }

    public IDockingPort getOldDockingPort() {
        return this.oldPort;
    }

    public IDockingPort getNewDockingPort() {
        return this.newPort;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public AWTEvent getTrigger() {
        return this.trigger;
    }

    public void setTrigger(AWTEvent aWTEvent) {
        this.trigger = aWTEvent;
    }

    public Object getTriggerSource() {
        return this.trigger == null ? null : this.trigger.getSource();
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String string) {
        if (!DockingManager.isValidDockingRegion(string)) {
            string = "UNKNOWN";
        }
        this.region = string;
    }

    public boolean isOverWindow() {
        return this.overWindow;
    }

    public void setOverWindow(boolean bl) {
        this.overWindow = bl;
    }

    public IDockable getDockable() {
        return (IDockable)this.getSource();
    }

    public Component getComponent() {
        return this.getDockable().getComponent();
    }

    public Map<Object, Object> getDragContext() {
        return this.dragContext;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public Perspective getPerspective() {
        return this.perspective;
    }
}

