/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.awt.Color;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.InteractiveForm;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.ContentParserFactory;

public class VariableTextFieldDictionary
extends FieldDictionary {
    private static final Logger logger = Logger.getLogger(VariableTextFieldDictionary.class.toString());
    public static final Name DA_KEY = new Name("DA");
    public static final Name Q_KEY = new Name("Q");
    public static final Name DS_KEY = new Name("DS");
    private String defaultAppearance;
    private String defaultStyle;
    private String defaultRichText;
    public static final Name RV_KEY = new Name("RV");
    protected Quadding quadding = Quadding.LEFT_JUSTIFIED;
    protected float size = 12.0f;
    protected Name fontName = new Name("Helv");
    protected Font font = null;
    protected Color color = Color.BLACK;

    public VariableTextFieldDictionary(Library library, HashMap entries) {
        super(library, entries);
        Integer value = library.getInt(entries, Q_KEY);
        int quad = value;
        switch (quad) {
            case 0: {
                this.quadding = Quadding.LEFT_JUSTIFIED;
                break;
            }
            case 1: {
                this.quadding = Quadding.CENTERED;
                break;
            }
            case 2: {
                this.quadding = Quadding.RIGHT_JUSTIFIED;
                break;
            }
            default: {
                this.quadding = Quadding.LEFT_JUSTIFIED;
            }
        }
        Object tmp = library.getObject(entries, DS_KEY);
        if (tmp != null) {
            this.defaultStyle = Utils.convertStringObject(library, (StringObject)tmp);
        }
        if ((tmp = library.getObject(entries, RV_KEY)) != null) {
            if (tmp instanceof StringObject) {
                this.defaultStyle = Utils.convertStringObject(library, (StringObject)tmp);
            } else if (tmp instanceof Stream) {
                this.defaultStyle = new String(((Stream)tmp).getDecodedStreamBytes());
            }
        }
        if ((tmp = library.getObject(entries, DA_KEY)) instanceof StringObject) {
            this.defaultAppearance = Utils.convertStringObject(library, (StringObject)tmp);
            Resources resources = library.getResources(entries, InteractiveForm.DR_KEY);
            if (resources != null) {
                try {
                    ContentParser cp = ContentParserFactory.getInstance().getContentParser(library, resources);
                    cp.parseTextBlocks(new byte[][]{this.defaultAppearance.getBytes()});
                    GraphicsState gs = cp.getGraphicsState();
                    if (gs != null) {
                        this.color = gs.getFillColor();
                        this.size = gs.getTextState().tsize;
                        if (gs.getTextState().font != null && gs.getTextState().font.getSubTypeFormat() != 2) {
                            this.font = gs.getTextState().font;
                            this.fontName = gs.getTextState().fontName;
                        }
                    }
                }
                catch (Throwable e) {
                    logger.warning("Could not validate default appearance, defaulting.");
                }
            }
        }
    }

    public String generateDefaultAppearance(String content, Resources resources) {
        block12: {
            try {
                String possibleContent;
                if (this.library.getObject(this.entries, DA_KEY) != null) {
                    possibleContent = this.library.getString(this.entries, DA_KEY);
                } else if (this.parentField != null && this.library.getObject(this.parentField.getEntries(), DA_KEY) != null) {
                    possibleContent = this.library.getString(this.parentField.getEntries(), DA_KEY);
                } else {
                    String string = possibleContent = content != null ? content : "";
                }
                if (resources == null) {
                    resources = this.library.getCatalog().getInteractiveForm().getResources();
                }
                ContentParser cp = ContentParserFactory.getInstance().getContentParser(this.library, resources);
                cp.parseTextBlocks(new byte[][]{possibleContent.getBytes()});
                GraphicsState gs = cp.getGraphicsState();
                if (gs != null) {
                    if (gs.getFillColor() != null) {
                        this.color = gs.getFillColor();
                    }
                    this.size = gs.getTextState().tsize > 0.0f ? gs.getTextState().tsize : 10.0f;
                    if (gs.getTextState().font != null && gs.getTextState().font.getSubTypeFormat() != 2) {
                        if (gs.getTextState().font != null) {
                            this.font = gs.getTextState().font;
                        }
                        if (gs.getTextState().fontName != null) {
                            this.fontName = gs.getTextState().fontName;
                        }
                    }
                }
            }
            catch (Throwable e) {
                logger.warning("Could not generate default appearance stream.");
                if (!logger.isLoggable(Level.FINEST)) break block12;
                logger.log(Level.FINEST, "Error parsing text feld content stream", e);
            }
        }
        return (float)this.color.getRed() / 255.0f + " " + (float)this.color.getGreen() / 255.0f + " " + (float)this.color.getBlue() / 255.0f + " rg " + "/" + this.fontName + " " + this.size + " Tf ";
    }

    public String getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public float getDefaultFontSize() {
        return this.size;
    }

    public Name getFontName() {
        return this.fontName;
    }

    public float getSize() {
        return this.size;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColor() {
        return this.color;
    }

    public Quadding getQuadding() {
        return this.quadding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quadding {
        LEFT_JUSTIFIED,
        CENTERED,
        RIGHT_JUSTIFIED;

    }
}

