/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.ext.aetree;

import com.vertica.dsi.ext.aetree.AEAdd;
import com.vertica.dsi.ext.aetree.AEAggrFunction;
import com.vertica.dsi.ext.aetree.AEAggregate;
import com.vertica.dsi.ext.aetree.AEAnd;
import com.vertica.dsi.ext.aetree.AEBooleanTrue;
import com.vertica.dsi.ext.aetree.AEColumn;
import com.vertica.dsi.ext.aetree.AEComparison;
import com.vertica.dsi.ext.aetree.AECountStarAggrFunction;
import com.vertica.dsi.ext.aetree.AECrossJoin;
import com.vertica.dsi.ext.aetree.AEDistinct;
import com.vertica.dsi.ext.aetree.AEDivide;
import com.vertica.dsi.ext.aetree.AEDummyTable;
import com.vertica.dsi.ext.aetree.AEExistsPredicate;
import com.vertica.dsi.ext.aetree.AEInPredicate;
import com.vertica.dsi.ext.aetree.AEJoin;
import com.vertica.dsi.ext.aetree.AELikePredicate;
import com.vertica.dsi.ext.aetree.AELiteral;
import com.vertica.dsi.ext.aetree.AEMultiply;
import com.vertica.dsi.ext.aetree.AENegate;
import com.vertica.dsi.ext.aetree.AENode;
import com.vertica.dsi.ext.aetree.AENodeType;
import com.vertica.dsi.ext.aetree.AENot;
import com.vertica.dsi.ext.aetree.AENull;
import com.vertica.dsi.ext.aetree.AENullPredicate;
import com.vertica.dsi.ext.aetree.AEOr;
import com.vertica.dsi.ext.aetree.AEProcedure;
import com.vertica.dsi.ext.aetree.AEProject;
import com.vertica.dsi.ext.aetree.AEProxyColumn;
import com.vertica.dsi.ext.aetree.AEQuantifiedComparison;
import com.vertica.dsi.ext.aetree.AERename;
import com.vertica.dsi.ext.aetree.AEScalarFn;
import com.vertica.dsi.ext.aetree.AESelect;
import com.vertica.dsi.ext.aetree.AESubQuery;
import com.vertica.dsi.ext.aetree.AESubtract;
import com.vertica.dsi.ext.aetree.AETable;
import com.vertica.dsi.ext.aetree.AETop;
import com.vertica.dsi.ext.aetree.AEValueList;
import com.vertica.dsi.ext.aetree.AEValueSubQuery;
import com.vertica.dsi.ext.aetree.AggrFunctionID;
import com.vertica.dsi.ext.aetree.ComparisonType;
import com.vertica.dsi.ext.aetree.JoinType;
import com.vertica.dsi.ext.aetree.LiteralType;
import com.vertica.dsi.ext.aetree.ScalarFunctionID;
import java.security.InvalidParameterException;

public final class AENodeFactory {
    private static final INodeCreator[] s_mappingTable = new INodeCreator[AENodeType.values().length - 1];

    public static final AENode createNode(long l) {
        return AENodeFactory.createNode(l, AENode.getNodeType(l));
    }

    public static final AENode createNode(long l, int n) {
        INodeCreator iNodeCreator;
        if (0 <= n && s_mappingTable.length > n && null != (iNodeCreator = s_mappingTable[n])) {
            AENode aENode = iNodeCreator.create(l);
            assert (null != aENode);
            assert (aENode.getNodeType() == AENodeType.getType(n));
            return aENode;
        }
        throw new InvalidParameterException();
    }

    static {
        AENodeFactory.s_mappingTable[0] = new INodeCreator(){

            public AENode create(long l) {
                return new AEAnd(l);
            }
        };
        AENodeFactory.s_mappingTable[1] = null;
        AENodeFactory.s_mappingTable[2] = new INodeCreator(){

            public AENode create(long l) {
                return new AEBooleanTrue(l);
            }
        };
        AENodeFactory.s_mappingTable[3] = new INodeCreator(){

            public AENode create(long l) {
                ComparisonType comparisonType = ComparisonType.getType(AEComparison.getComparisonType(l));
                return new AEComparison(l, comparisonType);
            }
        };
        AENodeFactory.s_mappingTable[4] = new INodeCreator(){

            public AENode create(long l) {
                return new AEExistsPredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[5] = new INodeCreator(){

            public AENode create(long l) {
                return new AEInPredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[6] = new INodeCreator(){

            public AENode create(long l) {
                return new AELikePredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[7] = new INodeCreator(){

            public AENode create(long l) {
                return new AENot(l);
            }
        };
        AENodeFactory.s_mappingTable[8] = new INodeCreator(){

            public AENode create(long l) {
                return new AENullPredicate(l);
            }
        };
        AENodeFactory.s_mappingTable[9] = new INodeCreator(){

            public AENode create(long l) {
                return new AEOr(l);
            }
        };
        AENodeFactory.s_mappingTable[10] = new INodeCreator(){

            public AENode create(long l) {
                return new AEQuantifiedComparison(l);
            }
        };
        AENodeFactory.s_mappingTable[11] = new INodeCreator(){

            public AENode create(long l) {
                return new AEAggregate(l);
            }
        };
        AENodeFactory.s_mappingTable[12] = new INodeCreator(){

            public AENode create(long l) {
                return new AECrossJoin(l);
            }
        };
        AENodeFactory.s_mappingTable[13] = new INodeCreator(){

            public AENode create(long l) {
                return new AEDistinct(l);
            }
        };
        AENodeFactory.s_mappingTable[14] = new INodeCreator(){

            public AENode create(long l) {
                return new AEDummyTable(l);
            }
        };
        AENodeFactory.s_mappingTable[15] = null;
        AENodeFactory.s_mappingTable[16] = null;
        AENodeFactory.s_mappingTable[17] = new INodeCreator(){

            public AENode create(long l) {
                return new AEJoin(l, JoinType.getType(AEJoin.getJoinType(l)));
            }
        };
        AENodeFactory.s_mappingTable[18] = new INodeCreator(){

            public AENode create(long l) {
                AEValueList aEValueList = AEProcedure.getArguments(l);
                boolean bl = AEProcedure.hasReturnValue(l);
                return new AEProcedure(l, aEValueList, bl);
            }
        };
        AENodeFactory.s_mappingTable[19] = new INodeCreator(){

            public AENode create(long l) {
                return new AEProject(l);
            }
        };
        AENodeFactory.s_mappingTable[20] = new INodeCreator(){

            public AENode create(long l) {
                return new AESelect(l);
            }
        };
        AENodeFactory.s_mappingTable[21] = new INodeCreator(){

            public AENode create(long l) {
                boolean bl = AESubQuery.isCorrelated(l);
                boolean bl2 = AESubQuery.isInFromClause(l);
                return new AESubQuery(l, bl, bl2);
            }
        };
        AENodeFactory.s_mappingTable[22] = new INodeCreator(){

            public AENode create(long l) {
                return new AETable(l, AETable.getDSITable(l));
            }
        };
        AENodeFactory.s_mappingTable[23] = null;
        AENodeFactory.s_mappingTable[24] = new INodeCreator(){

            public AENode create(long l) {
                return new AETop(l, AETop.isPercent(l));
            }
        };
        AENodeFactory.s_mappingTable[25] = null;
        AENodeFactory.s_mappingTable[26] = new INodeCreator(){

            public AENode create(long l) {
                return new AEAdd(l);
            }
        };
        AENodeFactory.s_mappingTable[27] = new INodeCreator(){

            public AENode create(long l) {
                AggrFunctionID aggrFunctionID = AggrFunctionID.getID(AEAggrFunction.getFunctionID(l));
                boolean bl = AEAggrFunction.isDistinctSet(l);
                return new AEAggrFunction(l, aggrFunctionID, bl);
            }
        };
        AENodeFactory.s_mappingTable[28] = new INodeCreator(){

            public AENode create(long l) {
                return new AEColumn(l, AEColumn.getColumnNum(l));
            }
        };
        AENodeFactory.s_mappingTable[29] = new INodeCreator(){

            public AENode create(long l) {
                return new AECountStarAggrFunction(l);
            }
        };
        AENodeFactory.s_mappingTable[30] = null;
        AENodeFactory.s_mappingTable[31] = new INodeCreator(){

            public AENode create(long l) {
                return new AEDivide(l);
            }
        };
        AENodeFactory.s_mappingTable[32] = null;
        AENodeFactory.s_mappingTable[33] = new INodeCreator(){

            public AENode create(long l) {
                return new AELiteral(l, LiteralType.getType(AELiteral.getLiteralType(l)));
            }
        };
        AENodeFactory.s_mappingTable[34] = new INodeCreator(){

            public AENode create(long l) {
                return new AEMultiply(l);
            }
        };
        AENodeFactory.s_mappingTable[35] = new INodeCreator(){

            public AENode create(long l) {
                return new AENegate(l);
            }
        };
        AENodeFactory.s_mappingTable[36] = new INodeCreator(){

            public AENode create(long l) {
                return new AENull(l);
            }
        };
        AENodeFactory.s_mappingTable[37] = null;
        AENodeFactory.s_mappingTable[38] = new INodeCreator(){

            public AENode create(long l) {
                return new AEProxyColumn(l, AEProxyColumn.getColumnNum(l));
            }
        };
        AENodeFactory.s_mappingTable[39] = new INodeCreator(){

            public AENode create(long l) {
                return new AERename(l);
            }
        };
        AENodeFactory.s_mappingTable[40] = new INodeCreator(){

            public AENode create(long l) {
                ScalarFunctionID scalarFunctionID = ScalarFunctionID.getID(AEScalarFn.getScalarFnID(l));
                return new AEScalarFn(l, scalarFunctionID);
            }
        };
        AENodeFactory.s_mappingTable[41] = null;
        AENodeFactory.s_mappingTable[42] = null;
        AENodeFactory.s_mappingTable[43] = null;
        AENodeFactory.s_mappingTable[44] = null;
        AENodeFactory.s_mappingTable[45] = new INodeCreator(){

            public AENode create(long l) {
                return new AEValueSubQuery(l, AEValueSubQuery.isCorrelated(l));
            }
        };
        AENodeFactory.s_mappingTable[46] = new INodeCreator(){

            public AENode create(long l) {
                return new AESubtract(l);
            }
        };
        AENodeFactory.s_mappingTable[47] = new INodeCreator(){

            public AENode create(long l) {
                return new AEValueList(l);
            }
        };
        AENodeFactory.s_mappingTable[48] = null;
        AENodeFactory.s_mappingTable[49] = null;
        AENodeFactory.s_mappingTable[50] = null;
        AENodeFactory.s_mappingTable[51] = null;
        AENodeFactory.s_mappingTable[52] = null;
        AENodeFactory.s_mappingTable[53] = null;
        AENodeFactory.s_mappingTable[54] = null;
        AENodeFactory.s_mappingTable[55] = null;
        AENodeFactory.s_mappingTable[56] = null;
        AENodeFactory.s_mappingTable[57] = null;
        AENodeFactory.s_mappingTable[58] = null;
        AENodeFactory.s_mappingTable[59] = null;
        AENodeFactory.s_mappingTable[60] = null;
        AENodeFactory.s_mappingTable[61] = null;
        AENodeFactory.s_mappingTable[62] = null;
        AENodeFactory.s_mappingTable[63] = null;
        AENodeFactory.s_mappingTable[64] = null;
        AENodeFactory.s_mappingTable[65] = null;
        AENodeFactory.s_mappingTable[66] = null;
        AENodeFactory.s_mappingTable[67] = null;
        AENodeFactory.s_mappingTable[68] = null;
    }

    private static interface INodeCreator {
        public AENode create(long var1);
    }
}

