/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ColorFactory {
    private static final Logger \u010e = Logger.getLogger(ColorFactory.class.getName());
    private static final double \u0109 = Math.sqrt(5.0);
    private static final double \u0106 = 2.0 / (1.0 + \u0109);
    private float \u0108;
    private float \u0107;
    private float \u010a;
    private Color[] \u010b = new Color[0];
    private List<Color> \u0102 = new ArrayList<Color>();
    private int \u0105 = 255;
    private double \u010d = 0.8;
    private double \u0104 = 1.0;
    private double \u010c = 0.5;
    private double \u0103 = 1.0;

    public ColorFactory() {
        this.\u0108 = (float)Math.random();
        this.\u0107 = (float)(this.\u010d + Math.random() * (this.\u0104 - this.\u010d));
        this.\u010a = (float)(this.\u010c + Math.random() * (this.\u0103 - this.\u010c));
    }

    public ColorFactory(int n2, Color ... colorArray) {
        this();
        this.setTransparency(n2);
        this.\u010b = colorArray;
    }

    public ColorFactory(Color ... colorArray) {
        this();
        this.\u010b = colorArray;
    }

    public void clear() {
        this.\u0102.clear();
    }

    public int getTransparency() {
        return this.\u0105;
    }

    public void setTransparency(int n2) {
        this.\u0105 = n2;
    }

    public double getMinSaturation() {
        return this.\u010d;
    }

    public void setMinSaturation(double d2) {
        this.\u010d = d2;
    }

    public double getMaxSaturation() {
        return this.\u0104;
    }

    public void setMaxSaturation(double d2) {
        this.\u0104 = d2;
    }

    public double getMinBrightness() {
        return this.\u010c;
    }

    public void setMinBrightness(double d2) {
        this.\u010c = d2;
    }

    public double getMaxBrightness() {
        return this.\u0103;
    }

    public void setMaxBrightness(double d2) {
        this.\u0103 = d2;
    }

    public static double distance(Color color, Color color2) {
        if (color2 == null) {
            return 0.0;
        }
        return ColorFactory.\u0101(color, color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    private static int \u0101(Color color, int n2, int n3, int n4) {
        if (color == null) {
            return 0;
        }
        int n5 = Math.abs(color.getRed() - n2);
        int n6 = Math.abs(color.getGreen() - n3);
        int n7 = Math.abs(color.getBlue() - n4);
        return n5 + n6 + n7;
    }

    public double closest(Color color) {
        double d2 = Double.MAX_VALUE;
        for (Color color2 : this.\u0102) {
            double d3 = ColorFactory.distance(color, color2);
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    private Color \u0101() {
        int n2 = this.\u0102.size();
        if (n2 < this.\u010b.length) {
            return this.\u010b[n2];
        }
        this.\u0108 = (float)((double)this.\u0108 + \u0106);
        this.\u0108 %= 1.0f;
        this.\u0107 = (float)(this.\u010d + Math.random() * (this.\u0104 - this.\u010d));
        this.\u010a = (float)(this.\u010c + Math.random() * (this.\u0103 - this.\u010c));
        return Color.getHSBColor(this.\u0108, this.\u0107, this.\u010a);
    }

    public Color create() {
        Color color;
        int n2;
        int n3 = 0;
        do {
            color = this.\u0101();
            assert (color.getAlpha() == 255);
            n2 = (int)this.closest(color);
            if (n2 != 0) continue;
            ++n3;
        } while (n2 == 0 && n3 < 10);
        this.\u0102.add(color);
        if (this.\u0105 != 255) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), this.\u0105);
        }
        return color;
    }

    private static int \u0101(int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        return n4;
    }

    public static Color intensify(Color color, int n2) {
        return new Color(ColorFactory.\u0101(color.getRed(), n2), ColorFactory.\u0101(color.getGreen(), n2), ColorFactory.\u0101(color.getBlue(), n2), color.getAlpha());
    }

    public static Color intensify2(Color color, int n2) {
        int n3 = color == null ? 0 : color.getRed();
        int n4 = color == null ? 0 : color.getGreen();
        int n5 = color == null ? 0 : color.getBlue();
        int n6 = color == null ? 255 : color.getAlpha();
        int n7 = 3 * n2;
        while (n7 > 0 && (n3 < 255 || n4 < 255 || n5 < 255)) {
            if (n3 < 255) {
                ++n3;
                --n7;
            }
            if (n4 < 255) {
                ++n4;
                --n7;
            }
            if (n5 >= 255) continue;
            ++n5;
            --n7;
        }
        return new Color(n3, n4, n5, n6);
    }

    public static Color transitionColor(Color color, Color color2, double d2) {
        int n2 = color.getRed() + (int)(d2 * (double)(color2.getRed() - color.getRed()));
        int n3 = color.getGreen() + (int)(d2 * (double)(color2.getGreen() - color.getGreen()));
        int n4 = color.getBlue() + (int)(d2 * (double)(color2.getBlue() - color.getBlue()));
        int n5 = color.getAlpha() + (int)(d2 * (double)(color2.getAlpha() - color.getAlpha()));
        return new Color(n2, n3, n4, n5);
    }
}

