/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Chartable3D;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.AbstractRenderer;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;

public abstract class AbstractBarRenderer
extends AbstractRenderer
implements BarRenderer {
    private boolean \u0137 = false;
    private boolean \u0136 = false;
    private LabelStyle \u0134 = new LabelStyle();
    private PointLabeler \u0138 = null;
    private Color \u0135 = Color.LIGHT_GRAY;

    public Color getDefaultBarColor() {
        return this.\u0135;
    }

    public void setDefaultBarColor(Color color) {
        this.\u0135 = color;
    }

    public boolean isLabelsVisible() {
        return this.\u0136;
    }

    public void setLabelsVisible(boolean bl) {
        this.\u0136 = bl;
    }

    public LabelStyle getLabelStyle() {
        return this.\u0134;
    }

    public void setLabelStyle(LabelStyle labelStyle) {
        this.\u0134 = labelStyle;
    }

    public PointLabeler getPointLabeler() {
        return this.\u0138;
    }

    public void setPointLabeler(PointLabeler pointLabeler) {
        this.\u0138 = pointLabeler;
    }

    public boolean isZeroHeightBarsVisible() {
        return this.\u0137;
    }

    public void setZeroHeightBarsVisible(boolean bl) {
        this.\u0137 = bl;
    }

    protected void renderBarLabel(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Chartable chartable, boolean bl, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5) {
        String string = this.computeLabel(chartable);
        if (string == null) {
            return;
        }
        ChartStyle chartStyle = chart.getStyle(chartModel);
        if (chartStyle == null) {
            chartStyle = new ChartStyle();
        }
        Orientation orientation = chartStyle.getBarOrientation();
        LabelStyle labelStyle = this.getLabelStyle();
        if (labelStyle == null) {
            labelStyle = new LabelStyle();
        }
        Color color = labelStyle.getColor();
        graphics2D.setColor(color);
        Font font = labelStyle.getFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        if (orientation == Orientation.vertical) {
            int n2 = fontMetrics.stringWidth(string);
            double d6 = d2 + d4 / 2.0;
            int n3 = fontMetrics.getDescent();
            graphics2D.drawString(string, (float)(d6 - (double)n2 / 2.0), (float)(d3 - (double)n3));
        } else {
            int n4 = fontMetrics.charWidth('o');
            double d7 = d3 + d5 / 2.0 + (double)fontMetrics.getAscent() / 2.0 - (double)fontMetrics.getDescent();
            graphics2D.drawString(string, (float)(d2 + d4 + (double)n4 / 2.0), (float)d7);
        }
    }

    protected String computeLabel(Chartable chartable) {
        if (chartable == null) {
            return "";
        }
        PointLabeler pointLabeler = this.getPointLabeler();
        if (pointLabeler != null) {
            return this.\u0138.getDisplayText(chartable);
        }
        if (chartable instanceof Chartable3D) {
            Positionable positionable = ((Chartable3D)chartable).getZ();
            return positionable == null ? "" : "" + positionable.position();
        }
        Positionable positionable = chartable.getY();
        return positionable == null ? "" : "" + positionable.position();
    }

    protected Paint createBarPaint(Chart chart, Chartable chartable, ChartStyle chartStyle, boolean bl, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5) {
        return null;
    }

    protected Paint getBarColor(Chart chart, Chartable chartable, ChartStyle chartStyle, boolean bl, boolean bl2, boolean bl3) {
        Paint paint = Color.lightGray;
        if (chartStyle != null && chartStyle.isBarsVisible()) {
            ChartStyle chartStyle2;
            Highlightable highlightable;
            Highlight highlight;
            Paint paint2 = chartStyle.getBarPaint();
            paint = paint2 != null ? paint2 : this.\u0135;
            if (chartable instanceof Highlightable && (highlight = (highlightable = (Highlightable)((Object)chartable)).getHighlight()) != null && (chartStyle2 = chart.getHighlightStyle(highlight)) != null) {
                paint = chartStyle2.getBarPaint();
            }
        }
        if (bl2) {
            if (paint instanceof Color) {
                paint = ColorFactory.intensify2(paint, 50);
            } else if (paint instanceof TexturePaint) {
                paint = this.\u0101((TexturePaint)paint);
            }
        }
        return paint;
    }

    private TexturePaint \u0101(TexturePaint texturePaint) {
        BufferedImage bufferedImage = texturePaint.getImage();
        A a2 = new A();
        BufferedImage bufferedImage2 = a2.filter(bufferedImage, null);
        return new TexturePaint(bufferedImage2, new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
    }

    class A
    implements BufferedImageOp {
        A() {
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            if (colorModel == null) {
                colorModel = bufferedImage.getColorModel();
            }
            return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        }

        @Override
        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            if (bufferedImage2 == null) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            int[] nArray = new int[n2 * n3];
            ChartUtils.getPixels(bufferedImage, 0, 0, n2, n3, nArray);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Color color = new Color(nArray[i2], true);
                nArray[i2] = color.brighter().getRGB();
            }
            ChartUtils.setPixels(bufferedImage2, 0, 0, n2, n3, nArray);
            return bufferedImage2;
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        @Override
        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            return (Point2D)point2D.clone();
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }
}

