/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AzureCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_IDP_TENANT = "idp_tenant";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_CLIENT_ID = "client_id";
    private String m_idpTenant;
    private String m_clientSecret;
    private String m_clientId;

    @Override
    protected String getSamlAssertion() throws IOException {
        if (StringUtils.isNullOrEmpty((String)this.m_idpTenant)) {
            throw new IOException("Missing required property: idp_tenant");
        }
        if (StringUtils.isNullOrEmpty((String)this.m_userName)) {
            throw new IOException("Missing required property: " + RedshiftProperty.UID.getName() + " or " + RedshiftProperty.USER.getName());
        }
        if (StringUtils.isNullOrEmpty((String)this.m_password)) {
            throw new IOException("Missing required property: " + RedshiftProperty.PWD.getName() + " or " + RedshiftProperty.PASSWORD.getName());
        }
        if (StringUtils.isNullOrEmpty((String)this.m_clientSecret)) {
            throw new IOException("Missing required property: client_secret");
        }
        if (StringUtils.isNullOrEmpty((String)this.m_clientId)) {
            throw new IOException("Missing required property: client_id");
        }
        return this.azureOauthBasedAuthentication();
    }

    @Override
    public void addParameter(String key, String value) {
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("key: {0}", key);
        }
        if (KEY_IDP_TENANT.equalsIgnoreCase(key)) {
            this.m_idpTenant = value;
        } else if (KEY_CLIENT_SECRET.equalsIgnoreCase(key)) {
            this.m_clientSecret = value;
        } else if (KEY_CLIENT_ID.equalsIgnoreCase(key)) {
            this.m_clientId = value;
        } else {
            super.addParameter(key, value);
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return (this.m_idpTenant != null ? this.m_idpTenant : "") + (this.m_clientId != null ? this.m_clientId : "") + (this.m_clientSecret != null ? this.m_clientSecret : "");
    }

    private String azureOauthBasedAuthentication() throws IOException, SdkClientException {
        String string;
        String uri = "https://login.microsoftonline.com/" + this.m_idpTenant + "/oauth2/token";
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("uri: {0}", uri);
        }
        CloseableHttpClient client = null;
        CloseableHttpResponse resp = null;
        try {
            String encodedSamlAssertion;
            JsonNode accessTokenField;
            client = this.getHttpClient();
            HttpPost post = new HttpPost(uri);
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>(7);
            parameters.add(new BasicNameValuePair("grant_type", "password"));
            parameters.add(new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:saml2"));
            parameters.add(new BasicNameValuePair("username", this.m_userName));
            parameters.add(new BasicNameValuePair("password", this.m_password));
            parameters.add(new BasicNameValuePair(KEY_CLIENT_SECRET, this.m_clientSecret));
            parameters.add(new BasicNameValuePair(KEY_CLIENT_ID, this.m_clientId));
            parameters.add(new BasicNameValuePair("resource", this.m_clientId));
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            post.addHeader("Accept", "application/json");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, Charset.forName("UTF-8")));
            resp = client.execute((HttpUriRequest)post);
            String content = EntityUtils.toString((HttpEntity)resp.getEntity());
            JsonNode entityJson = Jackson.jsonNodeOf((String)content);
            if (resp.getStatusLine().getStatusCode() != 200) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.DEBUG, "azureOauthBasedAuthentication https response: " + content, new Object[0]);
                }
                String errorMessage = "Authentication failed on the Azure server. Please check the tenant, user, password, client secret, and client id.";
                JsonNode errorDescriptionNode = entityJson.findValue("error_description");
                if (errorDescriptionNode != null && !StringUtils.isNullOrEmpty((String)errorDescriptionNode.textValue())) {
                    String errorDescription = errorDescriptionNode.textValue().replaceAll("\r\n", " ");
                    JsonNode errorCodeNode = entityJson.findValue("error");
                    errorMessage = errorCodeNode != null && !StringUtils.isNullOrEmpty((String)errorCodeNode.textValue()) ? errorCodeNode.textValue() + ": " + errorDescription : "Unexpected response: " + errorDescription;
                }
                throw new IOException(errorMessage);
            }
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("content: {0}", content);
            }
            if ((accessTokenField = entityJson.findValue("access_token")) != null) {
                encodedSamlAssertion = accessTokenField.textValue();
                if (StringUtils.isNullOrEmpty((String)encodedSamlAssertion)) {
                    throw new IOException("Invalid Azure access_token response");
                }
            } else {
                throw new IOException("Failed to find Azure access_token");
            }
            String samlAssertion = new String(Base64.decodeBase64((String)encodedSamlAssertion), Charset.forName("UTF-8"));
            StringBuilder sb = new StringBuilder();
            sb.append("<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\">");
            sb.append("<samlp:Status>");
            sb.append("<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/>");
            sb.append("</samlp:Status>");
            sb.append(samlAssertion);
            sb.append("</samlp:Response>");
            string = new String(Base64.encodeBase64((byte[])sb.toString().getBytes()));
        }
        catch (GeneralSecurityException e) {
            try {
                throw new SdkClientException("Failed to create SSLContext", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resp, null);
                IOUtils.closeQuietly((Closeable)client, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)resp, null);
        IOUtils.closeQuietly((Closeable)client, null);
        return string;
    }
}

