/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.newdataimp.target;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.onseven.dbvis.newdataimp.analyze.DataRecordColumnInfo;
import com.onseven.dbvis.newdataimp.analyze.DataRecordColumnInfoSet;
import com.onseven.dbvis.newdataimp.f;
import com.onseven.dbvis.newdataimp.g.e;
import com.onseven.dbvis.newdataimp.g.g;
import com.onseven.dbvis.newdataimp.target.SqlStatistics;
import com.onseven.dbvis.newdataimp.target.Table;
import com.onseven.dbvis.newdataimp.target.b;
import com.onseven.dbvis.newdataimp.target.c;
import com.onseven.dbvis.newdataimp.target.d;
import com.onseven.dbvis.newdataimp.target.h;
import com.onseven.dbvis.newdataimp.target.i;
import com.onseven.dbvis.newdataimp.target.j;
import com.onseven.dbvis.newdataimp.target.k;
import com.onseven.dbvis.newdataimp.target.l;
import com.onseven.dbvis.newdataimp.target.m;
import com.onseven.dbvis.newdataimp.target.o;
import com.onseven.dbvis.util.u;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class TableImportTarget
implements j {
    private static Logger LOG = Logger.getLogger(TableImportTarget.class.getName());
    private Table table = null;
    private String ddl = null;
    k columnValidator;
    @JsonIgnore
    private com.onseven.dbvis.db.n.k dbConnection = null;
    @JsonIgnore
    private f importContext = null;
    private boolean statementDropTableDone;
    private boolean statementCreateTableDone;
    private boolean statementClearedTableDone;
    private String clearMessage;
    private boolean isDryRun = false;
    private static d._b PARAM_FAULT = d._b.e;

    public TableImportTarget() {
    }

    public TableImportTarget(Table table) {
        this.table = table;
    }

    @Override
    public com.onseven.dbvis.newdataimp.record.d createRecordHandler() {
        return new m(this.importContext, this);
    }

    @Override
    public void init(com.onseven.dbvis.db.n.k k2, f f2) throws l {
        this.dbConnection = k2;
        this.importContext = f2;
        this.isDryRun = f2.o();
    }

    @Override
    public void checkPrerequisites() throws l {
        if (this.getMappings() == null || this.getMappings().b.size() == 0) {
            throw new l(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoMapping", new Object[0]));
        }
        if (this.table == null) {
            throw new l(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoTable", new Object[0]));
        }
        if (this.table.getColumns().isEmpty()) {
            throw new l(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoColumnsFound", this.table.getFullyQualifiedTableName()));
        }
    }

    private DataRecordColumnInfoSet getSourceColumnInfo() {
        return this.importContext.c();
    }

    @Override
    public h checkDataCompatibility() throws l {
        h h2 = new h();
        if (this.getSourceColumnInfo() == null || this.getMappings() == null || this.table.getColumns() == null) {
            return h2;
        }
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.getSourceColumnInfo().getInfoMap().entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            this.check(entry, h2);
        }
        return h2;
    }

    private o getMappings() {
        return this.importContext.l();
    }

    public Table getTable() {
        return this.table;
    }

    public com.onseven.dbvis.db.n.k getDbConnection() {
        return this.dbConnection;
    }

    private void check(Map.Entry<Integer, DataRecordColumnInfo> entry, h h2) {
        DataRecordColumnInfo dataRecordColumnInfo = entry.getValue();
        String string = dataRecordColumnInfo.getColumnName();
        String string2 = this.getTargetColumnName(dataRecordColumnInfo);
        if (string2 == null) {
            return;
        }
        b b2 = this.table.getColumn(string2);
        if (b2 == null) {
            this.fail(h2, "ColumnNotFound", h._b._b.e, string, string2, this.table.getFullyQualifiedTableName());
            return;
        }
        if (this.columnValidator.b(b2)) {
            return;
        }
        h._b _b2 = this.columnValidator.b(this.table, b2, dataRecordColumnInfo);
        if (_b2 != null) {
            h2.b(_b2);
        }
    }

    private o createAutoMapping(DataRecordColumnInfoSet dataRecordColumnInfoSet, Table table) {
        o o2 = new o();
        o2.b(dataRecordColumnInfoSet, table);
        LOG.log(Level.FINE, "Automapping of colums created. " + o2.b().size() + " columns mapped");
        this.importContext.b(o2);
        return o2;
    }

    @Override
    public d prepareTargetForImport(boolean bl) throws l {
        boolean bl2;
        d d2 = new d();
        e e2 = this.importContext.k();
        com.onseven.dbvis.newdataimp.g.f f2 = null;
        if (bl) {
            f2 = com.onseven.dbvis.newdataimp.g.f.g;
            this.initDefaultColumnValidator();
        } else {
            f2 = this.getCleanData(e2);
        }
        if (!this.initDDL(this.importContext, f2, d2)) {
            return d2;
        }
        if (f2 == com.onseven.dbvis.newdataimp.g.f.e) {
            if (this.dropAndCreateTable(this.dbConnection, this.importContext, d2)) {
                bl2 = this.initTableColumnInfo(d2, this.dbConnection);
                if (!d2.i()) {
                    return d2;
                }
                if (bl2) {
                    if (this.getMappings() == null) {
                        this.createAutoMapping(this.getSourceColumnInfo(), this.table);
                    } else {
                        this.resolveTargetMappings(d2);
                    }
                    this.checkSourceDataAgainstTable(d2);
                } else {
                    String string = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoColumnInfoAfterCreatTable", this.table.getFullyQualifiedTableName());
                    d2.b(string, d._b.b);
                }
            }
        } else if (f2 == com.onseven.dbvis.newdataimp.g.f.b) {
            bl2 = this.initTableColumnInfo(d2, this.dbConnection);
            if (!bl2) {
                String string = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoColumnInfoWhenClear", this.table.getFullyQualifiedTableName());
                d2.b(string, d._b.b);
                return d2;
            }
            if (this.getMappings() == null) {
                this.createAutoMapping(this.getSourceColumnInfo(), this.table);
            }
            this.resolveTargetMappings(d2);
            if (this.checkSourceDataAgainstTable(d2)) {
                this.clearTableData(this.dbConnection, this.importContext, d2);
            }
        } else if (f2 == com.onseven.dbvis.newdataimp.g.f.g || f2 == com.onseven.dbvis.newdataimp.g.f.d) {
            bl2 = this.initTableColumnInfo(d2, this.dbConnection);
            if (!bl2 && bl) {
                if (this.is(com.onseven.dbvis.newdataimp.g.d.dc)) {
                    String string = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoColumnsFound", this.table.getFullyQualifiedTableName());
                    d2.b(string, d._b.b);
                    return d2;
                }
            } else if (!bl2) {
                if (!this.initDDLFromFileOrParam(this.importContext, d2, e2)) {
                    return d2;
                }
                if (u.i(this.ddl)) {
                    if (!this.isDryRun) {
                        long l2 = i.b(this.table, this.dbConnection, this.ddl, d2, "RunDDL");
                        if (!d2.i()) {
                            return d2;
                        }
                        this.addUpdateRowsToStats(l2, this.importContext);
                        bl2 = this.initTableColumnInfo(d2, this.dbConnection);
                        if (!bl2 && this.is(com.onseven.dbvis.newdataimp.g.d.dc)) {
                            String string = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoColumnInfoAfterCreatTable", this.table.getFullyQualifiedTableName());
                            d2.b(string, d._b.b);
                            return d2;
                        }
                    } else {
                        LOG.log(Level.FINE, "Dry Run: SQL not run: " + this.ddl);
                        d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.DryNoCreateTable", new Object[0]));
                    }
                } else if (this.is(com.onseven.dbvis.newdataimp.g.d.dc)) {
                    String string = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.NoColumnsFound", this.table.getFullyQualifiedTableName());
                    d2.b(string, d._b.b);
                    return d2;
                }
            } else {
                this.resolveTargetMappings(d2);
            }
            if (this.getMappings() == null) {
                this.createAutoMapping(this.getSourceColumnInfo(), this.table);
            }
            this.checkSourceDataAgainstTable(d2);
        }
        if (d2.i()) {
            String string = null;
            if (this.statementDropTableDone && this.statementCreateTableDone) {
                string = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.ResultDropAndCreate", new Object[0]);
            } else if (this.statementClearedTableDone) {
                string = this.clearMessage;
            }
            if (string != null) {
                d2.c(string);
            }
        }
        return d2;
    }

    private void resolveTargetMappings(d d2) {
        if (this.table != null && this.getMappings() != null) {
            this.getMappings().b(this.table);
        }
    }

    private boolean is(com.onseven.dbvis.newdataimp.g.d d2) {
        return this.importContext.k().c(d2);
    }

    private boolean clearTableData(com.onseven.dbvis.db.n.k k2, f f2, d d2) {
        String string = null;
        String string2 = null;
        if (f2.k().e(com.onseven.dbvis.newdataimp.g.d.jc)) {
            LOG.log(Level.FINE, "Using SQL from parameter ClearTableSQL for clear");
            string = f2.k().h(com.onseven.dbvis.newdataimp.g.d.jc);
            string2 = "ClearMsgCustom";
        } else {
            LOG.log(Level.FINE, "Using SQL from Generator for clear data");
            g g2 = g.b(f2.k());
            if (g2 == g.b) {
                string = c.b(k2, this.table, f2.ab());
                string2 = "ClearMsgTruncate";
            } else if (g2 == g.e) {
                string = c.d(k2, this.table, f2.ab());
                string2 = "ClearMsgDelete";
            } else if (g2 == g.g) {
                if (c.b(k2)) {
                    string = c.b(k2, this.table, f2.ab());
                    string2 = "ClearMsgTruncate";
                } else {
                    LOG.log(Level.FINE, "Truncate not supported using Delete");
                    string = c.d(k2, this.table, f2.ab());
                    string2 = "ClearMsgDelete";
                }
            } else {
                d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.BothDDLSpecified", new Object[0]), PARAM_FAULT);
                return false;
            }
        }
        if (string == null) {
            return false;
        }
        long l2 = 0L;
        if (!this.isDryRun) {
            l2 = i.b(this.table, k2, string, d2, "RunClearSQL");
            this.addUpdateRowsToStats(l2, f2);
        } else {
            LOG.log(Level.FINE, "Dry Run: SQL not executed: " + string);
            d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.DryNoClear", new Object[0]));
        }
        this.statementClearedTableDone = d2.i();
        if (this.statementClearedTableDone) {
            String string3 = string2 = string2 != null ? string2 : "ResultClearOK";
            if (l2 > 0L) {
                string2 = string2 + "WithRows";
            }
            this.clearMessage = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget." + string2, l2);
        }
        return this.statementClearedTableDone;
    }

    private boolean checkSourceDataAgainstTable(d d2) {
        h h2 = new h();
        if (this.getSourceColumnInfo() == null || this.getMappings() == null || this.table.getColumns() == null) {
            d2.b(h2);
            return false;
        }
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.getSourceColumnInfo().getInfoMap().entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            this.check(entry, h2);
        }
        d2.b(h2);
        return h2.b();
    }

    private void fail(h h2, String string, h._b._b _b2, String string2, String string3, Object ... objectArray) {
        Object[] objectArray2 = new Object[2 + objectArray.length];
        objectArray2[0] = string2;
        objectArray2[1] = string3;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        String string4 = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget." + string, objectArray2);
        h2.b(string2, string3, string4, _b2);
    }

    private String getTargetColumnName(DataRecordColumnInfo dataRecordColumnInfo) {
        String string = this.getMappings().c(dataRecordColumnInfo.getIndex());
        if (string == null) {
            string = this.getMappings().b(dataRecordColumnInfo.getColumnName());
        }
        return string;
    }

    private boolean initTableColumnInfo(d d2, com.onseven.dbvis.db.n.k k2) {
        try {
            this.table.clearColumns();
            boolean bl = i.b(k2, this.table);
            if (bl) {
                LOG.log(Level.FINE, "Initiated table information. Got " + this.table.getColumnCount() + " columns");
            }
            return bl;
        }
        catch (l l2) {
            d2.b(l2.getMessage(), l2.f(), l2);
            return false;
        }
    }

    private boolean dropAndCreateTable(com.onseven.dbvis.db.n.k k2, f f2, d d2) {
        long l2;
        String string = this.getDropSql(k2, f2);
        if (!u.i(string)) {
            String string2 = com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.FailedGetDrop", this.table.getFullyQualifiedTableName());
            d2.b(string2, d._b.b);
            LOG.log(Level.FINE, string2 + " Catalog: " + this.table.getCatalog() + " Schema: " + this.table.getSchema());
            return false;
        }
        if (!this.isDryRun) {
            l2 = i.b(this.table, k2, string, d2, "RunDropSQL", com.onseven.dbvis.newdataimp.g.d.ub, f2.k());
            this.addUpdateRowsToStats(l2, f2);
        } else {
            LOG.log(Level.FINE, "Dry Run: Drop SQL not run: " + string);
        }
        if (d2.i() && !this.isDryRun) {
            this.statementDropTableDone = true;
            l2 = i.b(this.table, k2, this.ddl, d2, "RunDDL");
            this.addUpdateRowsToStats(l2, f2);
            this.statementCreateTableDone = d2.i();
        }
        if (this.isDryRun) {
            d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.DryDropCreate", new Object[0]));
        }
        return d2.i();
    }

    private void addUpdateRowsToStats(long l2, f f2) {
        SqlStatistics sqlStatistics = f2.cb();
        if (sqlStatistics != null) {
            sqlStatistics.addUpdateCount(l2);
        }
    }

    private String getDropSql(com.onseven.dbvis.db.n.k k2, f f2) {
        String string = null;
        if (f2.k().e(com.onseven.dbvis.newdataimp.g.d.fc)) {
            LOG.log(Level.FINE, "Using SQL from parameter DropTableSQL for drop");
            string = f2.k().h(com.onseven.dbvis.newdataimp.g.d.fc);
        } else {
            LOG.log(Level.FINE, "Using SQL from Generator for drop");
            string = c.c(k2, this.table, f2.ab());
        }
        return string;
    }

    private com.onseven.dbvis.newdataimp.g.f getCleanData(e e2) {
        com.onseven.dbvis.newdataimp.g.f f2 = com.onseven.dbvis.newdataimp.g.f.b(e2);
        if (f2 == com.onseven.dbvis.newdataimp.g.f.d) {
            f2 = com.onseven.dbvis.newdataimp.g.f.g;
        }
        return f2;
    }

    private boolean initDDL(f f2, com.onseven.dbvis.newdataimp.g.f f3, d d2) {
        e e2 = f2.k();
        if (f3 == com.onseven.dbvis.newdataimp.g.f.e) {
            if (!e2.h(com.onseven.dbvis.newdataimp.g.d.h) && !e2.h(com.onseven.dbvis.newdataimp.g.d.yb)) {
                d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.DDLNotSpecified", new Object[0]), PARAM_FAULT);
                return false;
            }
            if (e2.h(com.onseven.dbvis.newdataimp.g.d.h) && e2.h(com.onseven.dbvis.newdataimp.g.d.yb)) {
                d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.BothDDLSpecified", new Object[0]), PARAM_FAULT);
                return false;
            }
            return this.initDDLFromFileOrParam(f2, d2, e2);
        }
        return true;
    }

    private boolean initDDLFromFileOrParam(f f2, d d2, e e2) {
        boolean bl = true;
        if (e2.h(com.onseven.dbvis.newdataimp.g.d.h)) {
            String string = e2.h(com.onseven.dbvis.newdataimp.g.d.h);
            if (u.i(string)) {
                this.ddl = string;
            } else {
                d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.EmptyDDL", this.table.getFullyQualifiedTableName()), PARAM_FAULT);
                bl = false;
            }
        } else if (e2.h(com.onseven.dbvis.newdataimp.g.d.yb)) {
            String string = e2.h(com.onseven.dbvis.newdataimp.g.d.yb);
            bl = this.getDdlFromFile(string, f2, d2);
        }
        return bl;
    }

    private k initColumnValidator(e e2, DataRecordColumnInfoSet dataRecordColumnInfoSet) {
        String string = e2.h(com.onseven.dbvis.newdataimp.g.d.vb);
        String string2 = e2.h(com.onseven.dbvis.newdataimp.g.d.i);
        String string3 = e2.h(com.onseven.dbvis.newdataimp.g.d.kb);
        k k2 = k.d(string2, string, string3);
        return k2;
    }

    private boolean getDdlFromFile(String string, f f2, d d2) {
        File file = f2.d(string);
        try {
            String string2 = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (!u.i(string2)) {
                d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.EmptyDDL", this.table.getFullyQualifiedTableName()), PARAM_FAULT);
                return false;
            }
            this.ddl = string2;
        }
        catch (IOException iOException) {
            d2.b(com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget.FailReadDDLFile", string, iOException), PARAM_FAULT);
            return false;
        }
        return true;
    }

    public void initDefaultColumnValidator() {
        this.setColumnValidator(this.initColumnValidator(this.importContext.k(), this.importContext.d().getAnalyzeColumnInfoSet()));
    }

    private void setColumnValidator(k k2) {
        this.columnValidator = k2;
    }

    public String toString() {
        return "TableImportTarget [table=" + this.table + ", statementDropTableDone=" + this.statementDropTableDone + ", statementCreateTableDone=" + this.statementCreateTableDone + ", statementClearedTableDone=" + this.statementClearedTableDone + "]";
    }
}

