/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.jpeg;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

class JPEGDecoder {
    private JPEGDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage decode(InputStream inputStream) throws IOException {
        ImageReader imageReader = JPEGDecoder.findImageReader("jpeg");
        if (imageReader == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.batik.ext.awt.image.codec.jpeg.FallbackJPEGDecoder");
                Method method = clazz.getDeclaredMethod("decode", InputStream.class);
                return (BufferedImage)method.invoke(null, inputStream);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("Could not decode JPEG image.");
            }
        }
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        try {
            imageReader.setInput(imageInputStream, true, true);
            BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
            return bufferedImage;
        }
        finally {
            imageInputStream.close();
            imageReader.dispose();
        }
    }

    private static ImageReader findImageReader(String string) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

