/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.IOUtils;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.xml.Tag;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;

public class StringUtils {
    static final Pattern dbNamePattern = Pattern.compile("[a-z0-9_.\\-]*", 2);
    private static final String invalidFrm = "Warning: database name \"%s\" will fail to be accepted in the next release. Please see documentation.\n";

    public static boolean isEmpty(CharSequence string) {
        return StringUtils.size(string) == 0;
    }

    public static boolean isBlank(CharSequence string) {
        return StringUtils.isEmpty(string) ? true : StringUtils.isEmpty(string.toString().trim());
    }

    public static int size(CharSequence string) {
        return string == null ? 0 : string.length();
    }

    public static String substring(String string, int len) {
        if (string == null || string.length() < len) {
            return string;
        }
        return string.substring(0, len);
    }

    public static String overwrite(String origString, int pos, String newString) {
        return StringUtils.overwrite(origString, pos, newString, 0, newString.length());
    }

    public static String overwrite(String origString, int pos, String newString, int newPos, int newLength) {
        if (pos > origString.length()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("position {0} exceeds the length of the string {1}", pos, origString.length()));
        }
        StringBuilder result = new StringBuilder(pos == 0 ? "" : origString.substring(0, pos));
        result.append(newString.substring(newPos, newLength + newPos));
        if (result.length() < origString.length()) {
            result.append(origString.substring(result.length()));
        }
        return result.toString();
    }

    public static String mangle(String input) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) {
                out.append("_");
                continue;
            }
            if (c == '_') {
                out.append("__");
                continue;
            }
            if (Character.isISOControl(c)) {
                out.append("_");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String randomString(int maxLength, Random r) {
        StringBuilder builder = new StringBuilder(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            char c = (char)(97 + r.nextInt(26));
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean equals(String one, String two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null || one != null && two == null) {
            return false;
        }
        return one.equals(two);
    }

    public static StringBuilder drainStream(Reader in) throws IOException {
        return StringUtils.drainStream(in, Integer.MAX_VALUE);
    }

    public static StringBuilder drainStream(Reader in, int maxLength) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while (buf.length() < maxLength && (c = in.read()) != -1) {
            buf.append((char)c);
        }
        IOUtils.close(in);
        return buf;
    }

    public static String trimPrefix(String option) {
        if (option != null && option.startsWith("--")) {
            return option.substring(2);
        }
        return option;
    }

    public static String warningText(String dbName) {
        return String.format(invalidFrm, dbName);
    }

    public static boolean isValidDbName(String dbName) {
        return !StringUtils.isBlank(dbName) && dbNamePattern.matcher(dbName).matches();
    }

    public static String assertValidDbName(String dbName) {
        Preconditions.checkArgument(StringUtils.isValidDbName(dbName), "invalid database name \"%s\", valid: %s", dbName, dbNamePattern.pattern());
        return dbName;
    }

    public static List<String> split(String csv) {
        ArrayList<String> set = new ArrayList<String>();
        if (!StringUtils.isBlank(csv)) {
            StringTokenizer tok = new StringTokenizer(csv, ",");
            while (tok.hasMoreTokens()) {
                set.add(tok.nextToken().trim());
            }
        }
        return set;
    }

    public static Map<String, String> asKeyValueMap(String csv) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.isBlank(csv)) {
            for (String kv : StringUtils.split(csv)) {
                StringTokenizer tok = new StringTokenizer(kv, "=");
                result.put(tok.nextToken().trim(), tok.hasMoreTokens() ? tok.nextToken().trim() : null);
            }
        }
        return result;
    }

    public static String joiner(Map<String, String> map, String kvSep, String elemSep) {
        return StringUtils.joiner(map, kvSep, elemSep, null);
    }

    public static String joiner(Map<String, String> map, String kvSep, String elemSep, String keyPrefix) {
        StringBuilder b = new StringBuilder();
        if (map != null && !map.isEmpty()) {
            Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                String value;
                Map.Entry<String, String> var = iter.next();
                String string = value = var.getValue() != null ? var.getValue() : "";
                if (keyPrefix != null) {
                    b.append(keyPrefix);
                }
                b.append(var.getKey()).append(kvSep).append(value).append(iter.hasNext() ? elemSep : "");
            }
        }
        return b.toString();
    }

    public static String tagValue(String val) {
        return val != null ? val : "";
    }

    public static String tagValue(Tag tag) {
        return StringUtils.tagValue(tag.getAttribute("Value", null));
    }

    public static long stableLong(String stableId) {
        String[] splitId = stableId.split(":");
        Preconditions.checkArgument(splitId.length > 1, "invalid stableId: %s", stableId);
        return UUID.fromString(splitId[1]).getLeastSignificantBits();
    }

    public static String toHashCode(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static Properties asProps(Map<String, String> map) {
        Properties props = new Properties();
        props.putAll(map);
        return props;
    }

    public static String centered(Object o, int width) {
        int i;
        String s = o.toString();
        if (s.length() >= width) {
            return s;
        }
        int paddingRight = (width - s.length()) / 2;
        int paddingLeft = width - s.length() - paddingRight;
        StringBuilder ret = new StringBuilder();
        for (i = 0; i != paddingLeft; ++i) {
            ret.append(" ");
        }
        ret.append(s);
        for (i = 0; i != paddingRight; ++i) {
            ret.append(" ");
        }
        return ret.toString();
    }
}

