/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.xml;

import com.nuodb.xml.Tag;
import com.nuodb.xml.XmlException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public abstract class TagFactory {
    private static final String DEFAULT_FACTORY_CLASS = "com.nuodb.impl.xml.TagFactoryImpl";
    private static TagFactory defaultInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TagFactory getInstance() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        Class<TagFactory> clazz = TagFactory.class;
        synchronized (TagFactory.class) {
            if (defaultInstance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultInstance;
            }
            defaultInstance = TagFactory.getInstance(DEFAULT_FACTORY_CLASS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    private static final TagFactory getInstance(String factoryClass) {
        try {
            return (TagFactory)Class.forName(factoryClass).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("No such factory: " + factoryClass, cnfe);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException("Could not create factory: " + factoryClass, ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("Could not access factory: " + factoryClass, iae);
        }
    }

    public static final Tag createTag(String name) {
        return TagFactory.getInstance().createFromName(name);
    }

    public abstract Tag createFromName(String var1);

    public static final Tag parseTag(String value) throws XmlException {
        return TagFactory.getInstance().createFromValue(value);
    }

    public static final Tag parseTagFile(File file) throws XmlException, IOException {
        try (FileReader reader = new FileReader(file);){
            char[] chars = new char[(int)file.length()];
            for (long count = file.length(); count > 0L; count -= (long)reader.read(chars)) {
            }
            Tag tag = TagFactory.getInstance().createFromValue(new String(chars));
            return tag;
        }
    }

    public abstract Tag createFromValue(String var1) throws XmlException;
}

