/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.pool;

import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.pool.ObjectFactory;
import com.nuodb.jdbc.pool.ObjectKey;
import com.nuodb.jdbc.pool.ObjectPool;
import com.nuodb.jdbc.pool.ObjectPoolConfig;
import com.nuodb.jdbc.pool.ObjectPoolException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultObjectPool<K extends ObjectKey, V, I>
implements ObjectPool<K, V, I> {
    private String name = EvictionTask.class.getSimpleName() + System.identityHashCode(this);
    private Logger logger;
    private ConcurrentHashMap<K, Queue<V>> objectMap = new ConcurrentHashMap();
    private ConcurrentHashMap<V, ObjectState> stateMap = new ConcurrentHashMap();
    private AtomicLong activeObjects = new AtomicLong(0L);
    private AtomicLong idleObjects = new AtomicLong(0L);
    private Timer evictionTimer;
    private ObjectFactory<K, V, I> objectFactory;
    private ObjectPoolConfig objectPoolConfig = ObjectPoolConfig.DEFAULT_OBJECT_POOL_CONFIG;
    private AtomicBoolean closed;
    private ObjectLock<K> objectLock;
    private ObjectPool.FillCallbackRunnable fillCallback;

    public DefaultObjectPool() {
        this.init();
    }

    protected void init() {
        this.closed = new AtomicBoolean(false);
        this.initializeActiveCounter();
        this.initEvictionTaskIfNeeded();
    }

    @Override
    public void initializeActiveCounter() {
        int maxActive = (int)this.objectPoolConfig.getMaxActive();
        int maxActivePerGroup = (int)this.objectPoolConfig.getMaxActivePerGroup();
        this.objectLock = maxActive > 0 || maxActivePerGroup > 0 ? new BlockObjectLock(maxActive, maxActivePerGroup) : new GrowObjectLock();
    }

    public void initEvictionTaskIfNeeded() {
        long delay = this.objectPoolConfig.getIdleValidationInterval();
        if (this.evictionTimer != null) {
            this.evictionTimer.cancel();
            this.evictionTimer = null;
        }
        if (delay > 0L) {
            this.evictionTimer = new Timer(true);
            this.evictionTimer.schedule((TimerTask)new EvictionTask(), delay, delay);
        }
    }

    @Override
    public long getActiveObjects() {
        return this.activeObjects.get();
    }

    @Override
    public long getIdleObjects() {
        return this.idleObjects.get();
    }

    @Override
    public String getPoolState() {
        StringBuilder state = new StringBuilder();
        state.append("[Pool name: " + this.name);
        state.append(", Active: " + this.activeObjects.get());
        state.append(", Idle: " + this.idleObjects.get());
        state.append(", Permits available: " + this.objectLock.getAvailablePermits());
        state.append("]");
        return state.toString();
    }

    private synchronized boolean synchronizedOffer(K key, V object) {
        Queue<V> objects = this.getObjects(key);
        return objects.offer(object);
    }

    @Override
    public void addObject(K key, I info) throws Exception {
        this.checkOpen();
        V object = this.createObject(key, info);
        if (this.synchronizedOffer(key, object)) {
            this.idleObjects.incrementAndGet();
            if (this.logger != null) {
                this.logger.trace("Added " + object + " to pool " + this.getPoolState());
            }
        } else {
            this.closeObject(key, object, false, false);
        }
    }

    @Override
    public V borrowObject(K key, I info) throws Exception {
        V object;
        block12: {
            this.checkOpen();
            boolean testOnBorrow = this.objectPoolConfig.isTestOnBorrow();
            while (true) {
                ObjectState state;
                Queue<V> objects;
                if (this.logger != null) {
                    this.logger.trace("Waiting for permit " + this.getPoolState());
                }
                this.objectLock.acquire(key);
                if (this.logger != null) {
                    this.logger.trace("Acquired permit " + this.getPoolState());
                }
                if ((object = (objects = this.getObjects(key)).poll()) == null) {
                    try {
                        if (this.logger != null) {
                            this.logger.trace("Creating new object " + this.getPoolState());
                        }
                        object = this.createObject(key, info);
                        this.activeObjects.incrementAndGet();
                        if (this.logger != null) {
                            this.logger.trace("Created new " + object + " " + this.getPoolState());
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        this.objectLock.release(key);
                        throw exception;
                    }
                }
                if (this.logger != null) {
                    this.logger.trace("Got " + object + " from queue " + this.getPoolState());
                }
                if ((state = this.stateMap.get(object)) == null && this.logger != null) {
                    this.logger.warn("No state found for " + object);
                }
                long currentTime = System.currentTimeMillis();
                if (!testOnBorrow || this.validateObject(key, object)) break;
                if (this.logger != null) {
                    this.logger.trace("Closing " + object + " " + this.getPoolState());
                }
                this.closeObject(key, object, true, true);
            }
            this.activeObjects.incrementAndGet();
            this.idleObjects.decrementAndGet();
            this.objectFactory.activateObject(key, object, info);
        }
        if (this.logger != null) {
            this.logger.trace("Acquired " + object + " " + this.getPoolState());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(K key, V object, I info) throws SQLException {
        this.checkOpen();
        ObjectState state = this.addObjectState(object);
        if (info != null) {
            state.setInfo(info);
        }
        boolean testOnReturn = this.objectPoolConfig.isTestOnReturn();
        try {
            if (testOnReturn && !this.validateObject(key, object)) {
                if (this.logger != null) {
                    this.logger.trace("Closing " + object + this.getPoolState());
                }
                this.closeObject(key, object, false, false);
                if (this.logger != null) {
                    this.logger.trace("Closed " + object + this.getPoolState());
                }
            } else {
                this.returnObject(key, object);
            }
        }
        finally {
            this.activeObjects.decrementAndGet();
            this.objectLock.release(key);
        }
        if (this.logger != null) {
            this.logger.trace("Return done for " + object + " " + this.getPoolState());
        }
    }

    @Override
    public void removeObject(K key, V object) throws Exception {
        this.checkOpen();
        Queue<V> objects = this.getObjects(key);
        if (objects != null && objects.remove(object)) {
            if (this.logger != null) {
                this.logger.trace("Removed " + object + " from pool " + this.getPoolState());
            }
            this.closeObject(key, object, true, false);
        }
        if (this.logger != null) {
            this.logger.trace("removeObject " + object + " not found in queue" + this.getPoolState());
        }
    }

    protected void returnObject(K key, V object) throws SQLException {
        ObjectState state = this.stateMap.get(object);
        if (state == null) {
            if (this.logger != null) {
                this.logger.warn("No state found for " + object);
            }
            return;
        }
        if (this.objectFactory.passivateObject(key, object, state.getInfo())) {
            this.synchronizedOffer(key, object);
            this.idleObjects.incrementAndGet();
            if (this.logger != null) {
                this.logger.trace("Returned " + object + " to queue " + this.getPoolState());
            }
        } else {
            if (this.logger != null) {
                this.logger.trace("Failed to put" + object + " in queue " + this.getPoolState());
            }
            this.closeObject(key, object, false, false);
        }
    }

    @Override
    public void close() throws Exception {
        this.checkOpen();
        this.closed.set(true);
        this.objectPoolConfig.setIdleValidationInterval(-1L);
        this.initEvictionTaskIfNeeded();
        for (Map.Entry<K, Queue<V>> entry : this.objectMap.entrySet()) {
            V object;
            ObjectKey key = (ObjectKey)entry.getKey();
            Queue<V> queue = entry.getValue();
            while ((object = queue.poll()) != null) {
                this.closeObject(key, object, true, false);
            }
        }
    }

    protected final void checkOpen() {
        if (this.closed.get()) {
            if (this.logger != null) {
                this.logger.error(String.format("Pool %s is not open", this.getName()));
            }
            throw new IllegalStateException(String.format("Pool %s is not open", this.getName()));
        }
    }

    protected Queue<V> getObjects(K objectKey) {
        Queue<V> queue;
        Queue<V> result = this.objectMap.get(objectKey);
        if (result == null && (queue = this.objectMap.putIfAbsent(objectKey, result = new ConcurrentLinkedQueue<V>())) != null) {
            result = this.objectMap.get(objectKey);
        }
        return result;
    }

    protected V createObject(K key, I info) throws Exception {
        V object = this.objectFactory.createObject(key, info);
        this.addObjectState(object).setInfo(info);
        return object;
    }

    protected ObjectState addObjectState(V object) {
        ObjectState newState = new ObjectState();
        ObjectState oldState = this.stateMap.putIfAbsent((ObjectState)object, newState);
        return oldState != null ? oldState : newState;
    }

    protected boolean validateObject(K key, V object) {
        boolean result = true;
        long validationInterval = this.objectPoolConfig.getValidationInterval();
        if (validationInterval > 0L) {
            ObjectState state = this.stateMap.get(object);
            if (state == null && this.logger != null) {
                this.logger.warn("Found null state for " + object);
            }
            if (state != null && System.currentTimeMillis() > state.getValidateTime() + validationInterval) {
                if (this.logger != null) {
                    this.logger.trace("Validating " + object);
                }
                result = this.objectFactory.validateObject(key, object, state.getInfo());
                state.setValidateTime(System.currentTimeMillis());
                if (this.logger != null) {
                    if (result) {
                        this.logger.trace(object + " validated successfully");
                    } else {
                        this.logger.trace(object + " validation failed");
                    }
                }
            }
        }
        return result;
    }

    protected void closeObject(K key, V object, boolean decrementIdleObjects, boolean releaseLock) {
        ObjectState state = this.stateMap.get(object);
        if (state == null) {
            if (this.logger != null) {
                this.logger.warn("Found null state for " + object + ". Not proceeding to close it.");
            }
            return;
        }
        this.closeObject(key, object, state.getInfo(), decrementIdleObjects, releaseLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeObject(K key, V object, I info, boolean decrementIdleObjects, boolean releaseLock) {
        try {
            this.objectFactory.closeObject(key, object, info);
        }
        finally {
            this.stateMap.remove(object);
            if (decrementIdleObjects) {
                this.idleObjects.decrementAndGet();
            }
            if (releaseLock) {
                this.objectLock.release(key);
            }
            if (this.logger != null) {
                this.logger.trace("Closed " + object + " " + this.getPoolState());
            }
        }
    }

    @Override
    public ObjectFactory<K, V, I> getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public void setObjectFactory(ObjectFactory<K, V, I> objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ObjectPoolConfig getObjectPoolConfig() {
        return this.objectPoolConfig;
    }

    @Override
    public void setObjectPoolConfig(ObjectPoolConfig objectPoolConfig) {
        this.objectPoolConfig = objectPoolConfig != null ? objectPoolConfig : ObjectPoolConfig.DEFAULT_OBJECT_POOL_CONFIG;
        this.init();
    }

    @Override
    public void setFillCallback(ObjectPool.FillCallbackRunnable callback) {
        this.fillCallback = callback;
    }

    protected void fillPool() {
        block6: {
            long minIdle = this.objectPoolConfig.getMinIdle();
            if (minIdle == 0L || this.fillCallback == null) {
                return;
            }
            int numObjectsCreated = 0;
            if (this.logger != null) {
                this.logger.trace("Creating objects to fill pool up to minIdle " + this.getPoolState());
            }
            try {
                while (!this.closed.get() && this.idleObjects.get() + this.activeObjects.get() < minIdle) {
                    this.fillCallback.run();
                    ++numObjectsCreated;
                }
                if (this.logger != null) {
                    this.logger.trace("Created " + numObjectsCreated + " objects to fill pool " + this.getPoolState());
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block6;
                this.logger.error("Fillpool failed in pool: " + this.name, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evictObjects() throws Exception {
        if (this.logger != null) {
            this.logger.trace("Eviction thread start");
        }
        long maxIdle = this.objectPoolConfig.getMaxIdle();
        long maxAge = this.objectPoolConfig.getMaxAge();
        boolean testWhileIdle = this.objectPoolConfig.isTestWhileIdle();
        if (this.logger != null) {
            this.logger.trace("Closing idle objects more than maxIdle " + this.getPoolState());
        }
        int numConnectionsClosed = 0;
        block3: while (this.idleObjects.get() > maxIdle) {
            for (Map.Entry<K, Queue<V>> entry : this.objectMap.entrySet()) {
                ObjectKey key = (ObjectKey)entry.getKey();
                Queue<V> queue = entry.getValue();
                if (!this.objectLock.tryAcquire(key)) continue;
                Object object = queue.poll();
                if (object == null) {
                    if (this.logger != null) {
                        this.logger.trace("No idle objects found to close for maxIdle");
                    }
                    this.objectLock.release(key);
                    continue block3;
                }
                if (this.logger != null) {
                    this.logger.trace("Closing idle " + object + this.getPoolState());
                }
                this.closeObject(key, object, true, true);
                ++numConnectionsClosed;
                if (this.idleObjects.get() > maxIdle) continue;
                continue block3;
            }
        }
        if (this.logger != null) {
            this.logger.debug("Closed " + numConnectionsClosed + " idle objects due to maxIdle " + this.getPoolState());
        }
        int numOldObjects = 0;
        int numBrokenObjects = 0;
        if (this.logger != null) {
            this.logger.debug("Testing objects for maxAge and validity " + this.getPoolState());
        }
        if (maxAge > 0L || testWhileIdle) {
            HashSet visited = new HashSet();
            block5: for (Map.Entry<K, Queue<V>> entry : this.objectMap.entrySet()) {
                ObjectKey key = (ObjectKey)entry.getKey();
                Queue queue = (Queue)entry.getValue();
                while (this.objectLock.tryAcquire(key)) {
                    Object object = queue.poll();
                    if (object == null) {
                        if (this.logger != null) {
                            this.logger.trace("No idle objects found to test");
                        }
                        this.objectLock.release(key);
                        continue block5;
                    }
                    if (!visited.add(object)) {
                        queue.offer(object);
                        this.objectLock.release(key);
                        continue block5;
                    }
                    ObjectState state = this.stateMap.get(object);
                    if (state != null) {
                        if (maxAge > 0L && System.currentTimeMillis() > state.getCreateTime() + maxAge) {
                            ++numOldObjects;
                            if (this.logger != null) {
                                this.logger.trace("Closing old " + object);
                            }
                            this.closeObject(key, object, state.getInfo(), true, true);
                            continue;
                        }
                        if (testWhileIdle && !this.validateObject(key, object)) {
                            ++numBrokenObjects;
                            if (this.logger != null) {
                                this.logger.trace("Closing broken " + object);
                            }
                            this.closeObject(key, object, state.getInfo(), true, true);
                            continue;
                        }
                        queue.offer(object);
                        this.objectLock.release(key);
                        continue;
                    }
                    if (this.logger == null) continue;
                    this.logger.warn("Found null state for " + object);
                }
            }
        }
        if (this.logger != null) {
            this.logger.trace("Closed " + numOldObjects + " old objects and " + numBrokenObjects + " broken objects " + this.getPoolState());
        }
        this.fillPool();
        DefaultObjectPool defaultObjectPool = this;
        synchronized (defaultObjectPool) {
            Iterator<Map.Entry<K, Queue<V>>> it = this.objectMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<K, Queue<V>> entry;
                entry = it.next();
                Queue<V> queue = entry.getValue();
                if (!queue.isEmpty()) continue;
                if (this.logger != null) {
                    this.logger.debug("Removing empty queue for key " + entry);
                }
                it.remove();
            }
        }
        if (this.logger != null) {
            this.logger.trace("Eviction thread end");
        }
    }

    class GrowObjectLock
    implements ObjectLock<K> {
        GrowObjectLock() {
        }

        @Override
        public void acquire(K objectKey) throws Exception {
        }

        @Override
        public boolean tryAcquire(K objectKey) {
            return true;
        }

        @Override
        public void release(K objectKey) {
        }

        @Override
        public long getAvailablePermits() {
            return -1L;
        }
    }

    class BlockObjectLock
    implements ObjectLock<K> {
        private final int maxActivePerGroup;
        private final Semaphore activeObjects;
        private final ConcurrentHashMap<ObjectKey, Semaphore> activeObjectsPerGroupMap = new ConcurrentHashMap();

        public BlockObjectLock(int maxActive, int maxActivePerGroup) {
            this.activeObjects = maxActive != 0 ? new Semaphore(maxActive) : null;
            this.maxActivePerGroup = maxActivePerGroup;
        }

        @Override
        public boolean tryAcquire(K objectKey) {
            Semaphore activeObjects = this.getActiveObjects();
            Semaphore activeObjectsPerGroup = this.getMaxActivePerGroup(objectKey.getGroupKey());
            while (true) {
                try {
                    return this.tryAcquire(activeObjects, activeObjectsPerGroup, -1L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public void acquire(K objectKey) {
            Semaphore activeObjects = this.getActiveObjects();
            Semaphore activeObjectsPerGroup = this.getMaxActivePerGroup(objectKey.getGroupKey());
            while (true) {
                try {
                    this.tryAcquire(activeObjects, activeObjectsPerGroup, DefaultObjectPool.this.objectPoolConfig.getMaxWait());
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        protected boolean tryAcquire(Semaphore activeObjects, Semaphore activeObjectsPerGroup, long maxWait) throws InterruptedException {
            boolean maxActivePerGroupAcquired = false;
            boolean activeObjectsAcquired = false;
            if (activeObjectsPerGroup != null) {
                if (maxWait < 0L) {
                    maxActivePerGroupAcquired = activeObjectsPerGroup.tryAcquire();
                } else if (maxWait == 0L) {
                    activeObjectsPerGroup.acquire();
                    maxActivePerGroupAcquired = true;
                } else {
                    maxActivePerGroupAcquired = activeObjectsPerGroup.tryAcquire(Math.max(1L, maxWait), TimeUnit.MILLISECONDS);
                    if (!maxActivePerGroupAcquired) {
                        if (DefaultObjectPool.this.logger != null) {
                            DefaultObjectPool.this.logger.debug("Timed out waiting for per group permit in " + DefaultObjectPool.this.name + " pool. maxWait = " + maxWait + " " + DefaultObjectPool.this.getPoolState());
                        }
                        throw new ObjectPoolException("Timeout in " + DefaultObjectPool.this.name + " pool while waiting for an object to be returned to a group in the pool");
                    }
                }
            }
            if (activeObjects != null) {
                try {
                    if (maxWait < 0L) {
                        activeObjectsAcquired = activeObjects.tryAcquire();
                    } else if (maxWait == 0L) {
                        activeObjects.acquire();
                        activeObjectsAcquired = true;
                    } else {
                        activeObjectsAcquired = activeObjects.tryAcquire(Math.max(1L, maxWait), TimeUnit.MILLISECONDS);
                        if (!activeObjectsAcquired) {
                            if (DefaultObjectPool.this.logger != null) {
                                DefaultObjectPool.this.logger.debug("Timed out waiting for global permit in " + DefaultObjectPool.this.name + " pool. maxWait = " + maxWait + " " + DefaultObjectPool.this.getPoolState());
                            }
                            throw new ObjectPoolException("Timeout in " + DefaultObjectPool.this.name + " pool while waiting for an object to be returned to global pool");
                        }
                    }
                }
                catch (Exception exception) {
                    if (maxActivePerGroupAcquired) {
                        activeObjectsPerGroup.release();
                    }
                    throw exception;
                }
            }
            return !(activeObjectsPerGroup != null && !maxActivePerGroupAcquired || activeObjects != null && !activeObjectsAcquired);
        }

        @Override
        public void release(K objectKey) {
            this.release(this.getActiveObjects(), this.getMaxActivePerGroup(objectKey.getGroupKey()));
        }

        @Override
        public long getAvailablePermits() {
            if (this.activeObjects != null) {
                return this.activeObjects.availablePermits();
            }
            return -1L;
        }

        protected void release(Semaphore activeObjects, Semaphore activeObjectsPerGroup) {
            if (activeObjectsPerGroup != null) {
                activeObjectsPerGroup.release();
            }
            if (activeObjects != null) {
                activeObjects.release();
            }
        }

        private Semaphore getActiveObjects() {
            return this.activeObjects;
        }

        private Semaphore getMaxActivePerGroup(ObjectKey groupKey) {
            Semaphore semaphore;
            Semaphore result = null;
            if (groupKey != null && this.maxActivePerGroup > 0 && (semaphore = this.activeObjectsPerGroupMap.putIfAbsent(groupKey, result = new Semaphore(this.maxActivePerGroup))) != null) {
                result = this.activeObjectsPerGroupMap.get(groupKey);
            }
            return result;
        }
    }

    static interface ObjectLock<K> {
        public void acquire(K var1) throws Exception;

        public boolean tryAcquire(K var1);

        public void release(K var1);

        public long getAvailablePermits();
    }

    class EvictionTask
    extends TimerTask {
        EvictionTask() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    DefaultObjectPool.this.evictObjects();
                }
                catch (Exception exception) {
                    Logger logger = DefaultObjectPool.this.getLogger();
                    if (logger == null) break block2;
                    logger.warn(String.format("Eviction from %s pool failure", DefaultObjectPool.this.getName()), exception);
                }
            }
        }
    }

    class ObjectState {
        private long createTime = System.currentTimeMillis();
        private long validateTime;
        private I info;

        ObjectState() {
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getValidateTime() {
            return this.validateTime;
        }

        public void setValidateTime(long validateTime) {
            this.validateTime = validateTime;
        }

        public I getInfo() {
            return this.info;
        }

        public void setInfo(I info) {
            this.info = info;
        }
    }
}

