/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc.logger;

import com.nuodb.impl.util.StackFrameInfo;
import com.nuodb.jdbc.logger.Level;
import com.nuodb.jdbc.logger.Logger;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardLogger
implements Logger {
    public static final Level LEVEL_DEFAULT = Level.INFO;
    public static final String PATTERN_DEFAULT = "[%date(yyyy-MM-dd HH:mm:ss.SSS)] (%level) (%line(long)) - %message";
    public static final Format FORMAT_DEFAULT = FormatParser.getInstance().parsePattern("[%date(yyyy-MM-dd HH:mm:ss.SSS)] (%level) (%line(long)) - %message");
    private String loggerName;
    private String callerClassName;
    private Level level = LEVEL_DEFAULT;
    private Format format = FORMAT_DEFAULT;
    private PrintWriter logWriter;
    private static final String CALLER_CLASS_NAME = StandardLogger.class.getName();

    public StandardLogger() {
        this("com.nuodb.jdbc");
    }

    public StandardLogger(String loggerName) {
        this(loggerName, CALLER_CLASS_NAME);
    }

    public StandardLogger(String loggerName, String callerClassName) {
        this.loggerName = loggerName;
        this.callerClassName = callerClassName;
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.ERROR);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Level.TRACE);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return this.level.compareTo(level) >= 0;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public String getPattern() {
        return this.format.getPattern();
    }

    public void setPattern(String pattern) {
        this.setFormat(pattern != null ? FormatParser.getInstance().parsePattern(pattern) : FORMAT_DEFAULT);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format != null ? format : FORMAT_DEFAULT;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public void error(String message) {
        this.log(Level.ERROR, this.callerClassName, message, null);
    }

    @Override
    public void error(String message, Throwable failure) {
        this.log(Level.ERROR, this.callerClassName, message, failure);
    }

    @Override
    public void warn(String message) {
        this.log(Level.WARN, this.callerClassName, message, null);
    }

    @Override
    public void warn(String message, Throwable failure) {
        this.log(Level.WARN, this.callerClassName, message, failure);
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, this.callerClassName, message, null);
    }

    @Override
    public void info(String message, Throwable failure) {
        this.log(Level.INFO, this.callerClassName, message, failure);
    }

    @Override
    public void debug(String message) {
        this.log(Level.DEBUG, this.callerClassName, message, null);
    }

    @Override
    public void debug(String message, Throwable failure) {
        this.log(Level.DEBUG, this.callerClassName, message, failure);
    }

    @Override
    public void trace(String message) {
        this.log(Level.TRACE, this.callerClassName, message, null);
    }

    @Override
    public void trace(String message, Throwable failure) {
        this.log(Level.TRACE, this.callerClassName, message, failure);
    }

    @Override
    public void log(Level level, String message, Throwable failure) {
        this.log(level, this.callerClassName, message, failure);
    }

    @Override
    public void log(Level level, String callerClassName, String message, Throwable failure) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        this.doLog(level, callerClassName, message, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLog(Level level, String callerClassName, String message, Throwable failure) {
        PrintWriter writer = this.getLogWriter();
        if (writer == null) {
            writer = DriverManager.getLogWriter();
        }
        if (writer == null) {
            return;
        }
        String result = this.format.format(new Record(level, new Date(), message, new StackFrameInfo(callerClassName)));
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            writer.println(result);
            if (failure != null) {
                failure.printStackTrace(writer);
            }
            writer.flush();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardLogger that = (StandardLogger)o;
        if (this.loggerName != null ? !this.loggerName.equals(that.loggerName) : that.loggerName != null) {
            return false;
        }
        if (this.level != that.level) {
            return false;
        }
        return !(this.format != null ? !this.format.equals(that.format) : that.format != null);
    }

    public int hashCode() {
        int result = this.loggerName != null ? this.loggerName.hashCode() : 0;
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StandardLogger{loggerName='" + this.loggerName + '\'' + ", level=" + (Object)((Object)this.level) + ", pattern=" + this.format.getPattern() + '}';
    }

    static class Record {
        private Level level;
        private Date date;
        private String message;
        private final StackFrameInfo stackFrameInfo;

        public Record(Level level, Date date, String message, StackFrameInfo stackFrameInfo) {
            this.level = level;
            this.date = date;
            this.message = message;
            this.stackFrameInfo = stackFrameInfo;
        }

        public Level getLevel() {
            return this.level;
        }

        public Date getDate() {
            return this.date;
        }

        public String getMessage() {
            return this.message;
        }

        public StackFrameInfo getStackFrameInfo() {
            return this.stackFrameInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            if (this.date != null ? !this.date.equals(record.date) : record.date != null) {
                return false;
            }
            if (this.level != record.level) {
                return false;
            }
            if (this.message != null ? !this.message.equals(record.message) : record.message != null) {
                return false;
            }
            return !(this.stackFrameInfo != null ? !this.stackFrameInfo.equals(record.stackFrameInfo) : record.stackFrameInfo != null);
        }

        public int hashCode() {
            int result = this.level != null ? this.level.hashCode() : 0;
            result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.stackFrameInfo != null ? this.stackFrameInfo.hashCode() : 0);
            return result;
        }
    }

    public static class FormatParser {
        private static final Pattern PARAM = Pattern.compile("%(\\w+)(\\(([^)]*)\\))?");
        private static final FormatParser INSTANCE = new FormatParser();
        private final Map<String, ParamType> paramTypes = new HashMap<String, ParamType>();

        public static FormatParser getInstance() {
            return INSTANCE;
        }

        private FormatParser() {
            this.addParamType(ParamType.DATE);
            this.addParamType(ParamType.LEVEL);
            this.addParamType(ParamType.LINE);
            this.addParamType(ParamType.MESSAGE);
        }

        public void addParamType(ParamType paramType) {
            this.paramTypes.put(paramType.getName(), paramType);
        }

        public Format parsePattern(String pattern) {
            Matcher matcher = PARAM.matcher(pattern);
            StringBuffer format = new StringBuffer();
            ArrayList<Param> params = new ArrayList<Param>();
            int index = 0;
            while (matcher.find()) {
                String name = matcher.group(1);
                ParamType paramType = this.paramTypes.get(name);
                if (paramType == null) {
                    throw new IllegalArgumentException(String.format("Unsupported param type %s", name));
                }
                String options = matcher.groupCount() == 3 ? matcher.group(3) : null;
                Param param = paramType.getParam(index++, options);
                matcher.appendReplacement(format, param.getFormatElement());
                params.add(param);
            }
            matcher.appendTail(format);
            return new Format(pattern, params, format.toString());
        }
    }

    public static class Format {
        private static final FieldPosition POSITION = new FieldPosition(0);
        private String pattern;
        private Collection<Param> params;
        private String format;
        private MessageFormat messageFormat;

        public Format(String pattern, Collection<Param> params, String format) {
            this.pattern = pattern;
            this.params = params;
            this.format = format;
            this.messageFormat = new MessageFormat(format);
        }

        public String getPattern() {
            return this.pattern;
        }

        public String format(Record record) {
            Object[] arguments = new Object[this.params.size()];
            int index = 0;
            for (Param param : this.params) {
                arguments[index++] = param.getFormatArgument(record);
            }
            StringBuffer result = new StringBuffer();
            this.messageFormat.format(arguments, result, POSITION);
            return result.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Format format = (Format)o;
            if (this.format != null ? !this.format.equals(format.format) : format.format != null) {
                return false;
            }
            if (this.params != null ? !this.params.equals(format.params) : format.params != null) {
                return false;
            }
            return !(this.pattern != null ? !this.pattern.equals(format.pattern) : format.pattern != null);
        }

        public int hashCode() {
            int result = this.pattern != null ? this.pattern.hashCode() : 0;
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Format{pattern='" + this.pattern + '\'' + ", params=" + this.params + ", format=" + this.format + '}';
        }
    }

    public static abstract class ParamType {
        public static final String DATE_FORMAT_STYLE = "yyyy-MM-dd HH:mm:ss.SSS";
        public static final ParamType LEVEL = new ParamType("level", null, null, false){

            @Override
            public Object getFormatArgument(Param param, Record record) {
                return record.getLevel();
            }
        };
        public static final ParamType DATE = new ParamType("date", "date", "yyyy-MM-dd HH:mm:ss.SSS", true){

            @Override
            public Object getFormatArgument(Param param, Record record) {
                return record.getDate();
            }
        };
        public static final ParamType MESSAGE = new ParamType("message", null, null, false){

            @Override
            public Object getFormatArgument(Param param, Record record) {
                return record.getMessage();
            }
        };
        public static final ParamType LINE = new ParamType("line", null, null, true){

            @Override
            public String getFormatStyle(Param param) {
                return null;
            }

            @Override
            public Object getFormatArgument(Param param, Record record) {
                StackFrameInfo stackFrameInfo = record.getStackFrameInfo();
                String options = param.getOptions();
                return options != null ? stackFrameInfo.format(options) : stackFrameInfo.format();
            }
        };
        private final String name;
        private final String formatType;
        private final String formatStyle;
        private final boolean supportOptions;

        public ParamType(String name, String formatType, String formatStyle, boolean supportOptions) {
            this.name = name;
            this.formatType = formatType;
            this.formatStyle = formatStyle;
            this.supportOptions = supportOptions;
        }

        public String getName() {
            return this.name;
        }

        public String getFormatType(Param param) {
            this.checkOptions(param.getOptions());
            return this.formatType;
        }

        public String getFormatStyle(Param param) {
            this.checkOptions(param.getOptions());
            return this.formatStyle;
        }

        protected void checkOptions(String options) {
            if (options != null && !this.isSupportOptions()) {
                throw new IllegalArgumentException(String.format("Param type '%s' doesn't support options {%s}", this.name, options));
            }
        }

        public abstract Object getFormatArgument(Param var1, Record var2);

        public Param getParam(int index, String options) {
            this.checkOptions(options);
            return new Param(this, index, options);
        }

        public boolean isSupportOptions() {
            return this.supportOptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamType that = (ParamType)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    public static class Param {
        private final ParamType paramType;
        private final int index;
        private final String options;

        public Param(ParamType paramType, int index, String options) {
            this.paramType = paramType;
            this.index = index;
            this.options = options;
        }

        public int getIndex() {
            return this.index;
        }

        public String getOptions() {
            return this.options;
        }

        public Object getFormatArgument(Record record) {
            return this.paramType.getFormatArgument(this, record);
        }

        public String getFormatElement() {
            String formatStyle;
            StringBuilder buffer = new StringBuilder();
            buffer.append("{");
            buffer.append(this.index);
            String formatType = this.paramType.getFormatType(this);
            if (formatType != null) {
                buffer.append(",").append(formatType);
            }
            if ((formatStyle = this.paramType.getFormatStyle(this)) != null) {
                buffer.append(",").append(formatStyle);
            }
            buffer.append("}");
            return buffer.toString();
        }

        public String toString() {
            return this.getFormatElement();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param param = (Param)o;
            if (this.index != param.index) {
                return false;
            }
            if (this.options != null ? !this.options.equals(param.options) : param.options != null) {
                return false;
            }
            return !(this.paramType != null ? !this.paramType.equals(param.paramType) : param.paramType != null);
        }

        public int hashCode() {
            int result = this.paramType != null ? this.paramType.hashCode() : 0;
            result = 31 * result + this.index;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }
    }
}

