/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Resources;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class ValueNumber
extends Value {
    private static final BigDecimal BYTE_MIN_VALUE = BigDecimal.valueOf(-128L);
    private static final BigDecimal BYTE_MAX_VALUE = BigDecimal.valueOf(127L);
    private static final BigDecimal SHORT_MIN_VALUE = BigDecimal.valueOf(-32768L);
    private static final BigDecimal SHORT_MAX_VALUE = BigDecimal.valueOf(32767L);
    private static final BigDecimal INT_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal INT_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal FLOAT_MIN_VALUE = BigDecimal.valueOf(-3.4028234663852886E38);
    private static final BigDecimal FLOAT_MAX_VALUE = BigDecimal.valueOf(3.4028234663852886E38);
    private static final BigDecimal DOUBLE_MIN_VALUE = BigDecimal.valueOf(-1.7976931348623157E308);
    private static final BigDecimal DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    private final BigDecimal value;
    private final MathContext mathContext;

    public ValueNumber(BigDecimal value) {
        this.value = value;
        this.mathContext = MathContext.UNLIMITED;
    }

    public ValueNumber(Object object) {
        this(object, null);
    }

    public ValueNumber(Object object, Integer scale) {
        this(object, scale, null);
    }

    public ValueNumber(Object object, Integer scale, MathContext mathContext) {
        this.mathContext = mathContext != null ? mathContext : MathContext.UNLIMITED;
        this.value = ValueNumber.fromObject(object, scale, this.mathContext);
    }

    private static BigDecimal fromObject(Object object, Integer scale, MathContext mathContext) {
        BigDecimal value = null;
        if (object instanceof BigDecimal) {
            value = (BigDecimal)object;
        } else if (object instanceof Boolean) {
            value = BigDecimal.valueOf(Boolean.TRUE.equals(object) ? 1.0 : 0.0);
        } else if (object != null) {
            try {
                BigInteger integer = new BigInteger(object.toString());
                value = new BigDecimal(integer, scale != null ? scale : 0, mathContext);
            }
            catch (NumberFormatException exception) {
                value = new BigDecimal(object.toString());
            }
        }
        if (value != null && scale != null) {
            value = value.setScale((int)scale, mathContext.getRoundingMode());
        }
        return value;
    }

    @Override
    public void encodeValue(EncodedDataStream dataStream) throws SQLException {
        if (this.value != null) {
            BigInteger bi = this.value.unscaledValue();
            if (this.value.scale() == 0 && bi.bitLength() < 32) {
                dataStream.encodeLong(this.value.longValueExact());
            } else {
                dataStream.encodeBigDecimal(this.value);
            }
        } else {
            dataStream.encodeNull();
        }
    }

    @Override
    int getType() {
        return 18;
    }

    @Override
    int getScale() {
        return this.value.scale();
    }

    @Override
    byte getByte() throws java.sql.SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value.compareTo(BYTE_MIN_VALUE) < 0 || value.compareTo(BYTE_MAX_VALUE) > 0) {
            throw new SQLException(Resources.getMessage("error.byte.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return value.byteValue();
    }

    @Override
    short getShort() throws java.sql.SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value.compareTo(SHORT_MIN_VALUE) < 0 || value.compareTo(SHORT_MAX_VALUE) > 0) {
            throw new SQLException(Resources.getMessage("error.short.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return value.shortValue();
    }

    @Override
    int getInt() throws java.sql.SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value.compareTo(INT_MIN_VALUE) < 0 || value.compareTo(INT_MAX_VALUE) > 0) {
            throw new SQLException(Resources.getMessage("error.int.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return value.intValue();
    }

    @Override
    long getLong() throws java.sql.SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value.compareTo(LONG_MIN_VALUE) < 0 || value.compareTo(LONG_MAX_VALUE) > 0) {
            throw new SQLException(Resources.getMessage("error.long.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return value.longValue();
    }

    @Override
    float getFloat() throws java.sql.SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value.compareTo(FLOAT_MIN_VALUE) < 0 || value.compareTo(FLOAT_MAX_VALUE) > 0) {
            throw new SQLException(Resources.getMessage("error.float.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return value.floatValue();
    }

    @Override
    double getDouble() throws java.sql.SQLException {
        BigDecimal value = this.getBigDecimal();
        if (value.compareTo(DOUBLE_MIN_VALUE) < 0 || value.compareTo(DOUBLE_MAX_VALUE) > 0) {
            throw new SQLException(Resources.getMessage("error.double.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return value.doubleValue();
    }

    @Override
    String getString() {
        return this.value.toString();
    }

    @Override
    BigDecimal getBigDecimal() throws SQLException {
        return this.value;
    }

    @Override
    Object getObject() throws java.sql.SQLException {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value);
    }
}

