/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import java.math.BigDecimal;

public class Conversions {
    public static byte[] toBytes(byte data) {
        return new byte[]{data};
    }

    public static byte[] toBytes(byte[] data) {
        return data;
    }

    public static byte[] toBytes(short data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
    }

    public static byte[] toBytes(char data) {
        return new byte[]{(byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
    }

    public static byte[] toBytes(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data & 0xFF)};
    }

    public static byte[] toBytes(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data & 0xFFL)};
    }

    public static byte[] toBytes(float data) {
        return Conversions.toBytes(Float.floatToRawIntBits(data));
    }

    public static byte[] toBytes(double data) {
        return Conversions.toBytes(Double.doubleToRawLongBits(data));
    }

    public static byte[] toBytes(boolean data) {
        return new byte[]{(byte)(data ? 1 : 0)};
    }

    public static byte[] toBytes(String data) {
        return data == null ? null : data.getBytes();
    }

    public static byte[] toBytes(BigDecimal data) {
        return data == null ? null : data.unscaledValue().toByteArray();
    }
}

