/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.ValueStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class ChunkedInputStream
extends InputStream {
    private Chunk chunk;
    private long streamOffset;
    private long streamMark = -1L;
    private long streamReadLimit;
    private boolean closed = false;
    private boolean ascii;
    private ValueStream stream;

    public ChunkedInputStream(ValueStream stream, boolean ascii) {
        this.stream = stream;
        this.ascii = ascii;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int available() throws IOException {
        this.checkOpen();
        return (int)(this.stream.getStreamSize() - this.streamOffset);
    }

    @Override
    public void mark(int readLimit) {
        this.streamMark = this.streamOffset;
        this.streamReadLimit = readLimit;
    }

    @Override
    public void reset() throws IOException {
        this.checkOpen();
        if (this.streamMark != -1L) {
            this.streamOffset = this.streamMark;
            this.streamMark = -1L;
        }
    }

    protected Chunk getChunk() throws IOException {
        Chunk result = null;
        if (this.chunk == null || !this.chunk.seek(this.streamOffset)) {
            int chunkIndex = (int)(this.streamOffset / this.stream.getChunkSize());
            if ((this.chunk == null || this.chunk.getChunkIndex() != chunkIndex) && chunkIndex >= 0 && chunkIndex < this.stream.getChunksCount()) {
                byte[] bytes = this.getChunkBytes(chunkIndex);
                long streamStart = (long)chunkIndex * this.stream.getChunkSize();
                long streamEnd = streamStart + (long)(bytes != null ? bytes.length : 0);
                this.chunk = new Chunk(bytes, streamStart, streamEnd, chunkIndex);
                this.chunk.seek(this.streamOffset);
                result = this.chunk;
            }
        } else {
            result = this.chunk;
        }
        return result;
    }

    protected byte[] getChunkBytes(int index) throws IOException {
        try {
            return this.ascii ? this.stream.getChunkString(index).getBytes() : this.stream.getChunkBytes(index);
        }
        catch (SQLException exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private void seek(long n) {
        if (n <= 0L) {
            return;
        }
        this.streamOffset += n;
        if (this.chunk != null) {
            this.chunk.seek(this.streamOffset);
        }
        if (this.streamMark != -1L) {
            this.streamReadLimit -= n;
            if (this.streamReadLimit <= 0L) {
                this.streamMark = -1L;
            }
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        this.checkOpen();
        if (this.available() == 0) {
            return -1;
        }
        Chunk chunk = this.getChunk();
        if (chunk != null && (result = chunk.read()) != -1) {
            this.seek(1L);
        } else {
            result = -1;
        }
        return result;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        this.checkOpen();
        if (buf == null) {
            throw new NullPointerException();
        }
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int read;
        this.checkOpen();
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.available() == 0) {
            return -1;
        }
        int result = 0;
        do {
            Chunk chunk;
            int n = read = (chunk = this.getChunk()) != null ? chunk.read(buf, off, len) : -1;
            if (read == -1) break;
            this.seek(read);
            result += read;
            off += read;
        } while ((len -= read) != 0);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkOpen();
        if (n <= 0L) {
            return 0L;
        }
        long skip = Math.min(this.streamOffset + n, this.stream.getStreamSize()) - this.streamOffset;
        this.seek(skip);
        return skip;
    }

    protected void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("InputStream is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private static class Chunk {
        private final byte[] buffer;
        private final int size;
        private final int chunkIndex;
        private final long streamStart;
        private final long streamEnd;
        private int offset;

        public Chunk(byte[] buffer, long streamStart, long streamEnd, int chunkIndex) {
            this.buffer = buffer;
            this.size = buffer != null ? buffer.length : 0;
            this.streamStart = streamStart;
            this.streamEnd = streamEnd;
            this.chunkIndex = chunkIndex;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getSize() {
            return this.size;
        }

        public int getChunkIndex() {
            return this.chunkIndex;
        }

        public boolean seek(long streamOffset) {
            boolean seek;
            if (streamOffset >= this.streamStart & streamOffset < this.streamEnd) {
                this.offset = (int)(streamOffset - this.streamStart);
                seek = true;
            } else {
                seek = false;
            }
            return seek;
        }

        public int read() {
            return this.available() > 0 ? this.buffer[this.offset++] & 0xFF : -1;
        }

        public int read(byte[] buf, int off, int len) {
            int available = this.available();
            if (available == 0) {
                return -1;
            }
            int read = Math.min(len, available);
            System.arraycopy(this.buffer, this.offset, buf, off, read);
            this.offset += read;
            return read;
        }

        public int available() {
            return this.size - this.offset;
        }
    }
}

