/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.util.ArrayUtils;
import com.nuodb.impl.util.ByteUtils;
import com.nuodb.jdbc.Clob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;

public class Blob
implements java.sql.Blob {
    private byte[] value = null;
    private int hash = 0;
    private BlobByteArrayOutputStream bs = null;

    public Blob() {
    }

    public Blob(byte[] bytes) {
        this.value = bytes;
    }

    public boolean hasData() {
        return this.value != null;
    }

    public Blob(java.sql.Blob blob) throws SQLException {
        if (blob == null) {
            return;
        }
        int length = (int)blob.length();
        if (length >= 0) {
            this.value = blob.getBytes(1L, length);
        }
    }

    @Override
    public long length() throws SQLException {
        if (this.value == null) {
            return -1L;
        }
        return this.value.length;
    }

    public byte[] getBytes() {
        if (this.value == null) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.value == null) {
            return null;
        }
        if (pos == 0L) {
            throw new SQLException("The first byte in the BLOB is at position 1");
        }
        Clob.checkLongValue(--pos, "position");
        if (pos == 0L && length == this.value.length) {
            return this.value;
        }
        length = Math.min(this.value.length, length);
        byte[] destination = new byte[length];
        System.arraycopy(this.value, (int)pos, destination, 0, length);
        return destination;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start == 0L) {
            throw new SQLException("The first byte in the BLOB is at position 1");
        }
        long end = this.value.length;
        int n = (int)(--start);
        while ((long)n < end) {
            boolean hit = true;
            int m = 0;
            int mm = n;
            while (m < pattern.length) {
                if (this.value[mm] != pattern[m]) {
                    hit = false;
                    break;
                }
                ++m;
                ++mm;
            }
            if (hit) {
                return n + 1;
            }
            ++n;
        }
        return -1L;
    }

    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public void free() throws SQLException {
        this.value = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos == 0L) {
            throw new SQLException("The first byte in the BLOB is at position 1");
        }
        Clob.checkLongValue(--pos, "position");
        Clob.checkLongValue(length, "length");
        return new ByteArrayInputStream(this.value, (int)pos, (int)length);
    }

    @Override
    public OutputStream setBinaryStream(long position) throws SQLException {
        if (this.bs == null) {
            this.bs = new BlobByteArrayOutputStream(position);
        }
        this.bs.setPos(position);
        return this.bs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        --pos;
        if (this.value == null) {
            if (pos != 0L) throw new SQLException(MessageFormat.format("Position exceeds the current length of this BLOB {0}", 0));
            this.value = bytes;
            return bytes.length;
        } else {
            Clob.checkLongValue(pos, "position");
            this.value = ByteUtils.overwrite(this.value, (int)pos, bytes);
        }
        return bytes.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        --pos;
        if (this.value == null) {
            if (pos != 0L) throw new SQLException(MessageFormat.format("Position exceeds the current length of this BLOB {0}", 0));
            this.value = Arrays.copyOfRange(bytes, offset, offset + len);
            return len;
        } else {
            Clob.checkLongValue(pos, "position");
            this.value = ByteUtils.overwrite(this.value, (int)pos, bytes, offset, len);
        }
        return len;
    }

    @Override
    public void truncate(long length) throws SQLException {
        if (length > (long)ArrayUtils.size(this.value)) {
            throw new SQLException(MessageFormat.format("Unable to truncate length {0} exceeds length of the BLOB {1}", length, ArrayUtils.size(this.value)));
        }
        Clob.checkLongValue(length, "length");
        byte[] newValue = new byte[(int)length];
        System.arraycopy(this.value, 0, newValue, 0, (int)length);
        this.value = newValue;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.value.length > 0) {
            for (int i = 0; i < this.value.length; ++i) {
                h = 31 * h + this.value[i];
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Blob)) {
            return false;
        }
        Blob other = (Blob)obj;
        return Arrays.equals(this.value, other.value);
    }

    private class BlobByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ByteArrayOutputStream bs = null;
        private long output_pos = 0L;

        public BlobByteArrayOutputStream(long pos) {
            this.output_pos = pos;
            this.bs = new ByteArrayOutputStream((int)pos);
        }

        public void setPos(long pos) {
            this.output_pos = pos;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            try {
                this.bs.write(b, off, len);
                Blob.this.setBytes(this.output_pos, b, off, len);
                this.output_pos += (long)len;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public void write(int b) {
            byte[] byte_arr = new byte[]{(byte)b};
            try {
                this.bs.write(byte_arr, 0, 1);
                Blob.this.setBytes(this.output_pos, byte_arr, 0, 1);
                ++this.output_pos;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

