/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.security.Cipher;
import com.nuodb.impl.security.StreamCipher;
import com.nuodb.impl.util.Preconditions;
import java.security.GeneralSecurityException;

public class CipherRC4
implements StreamCipher {
    byte[] state;
    int s1;
    int s2;
    Cipher.CipherMode cipherMode;

    @Override
    public int getBlockSize() {
        return 1;
    }

    @Override
    public void initialize(byte[] key, Cipher.CipherMode cipherMode, byte[] initializationVector) throws GeneralSecurityException {
        this.setKey(key, 0, key.length);
        this.s1 = 0;
        this.s2 = 0;
        this.cipherMode = cipherMode;
    }

    public void initialize(byte[] key, Cipher.CipherMode cipherMode) throws GeneralSecurityException {
        this.initialize(key, cipherMode, null);
    }

    @Override
    public void transform(byte[] data) {
        this.transform(data, 0, data.length);
    }

    @Override
    public void transform(byte[] data, int offset, int length) {
        int n = offset;
        int end = offset + length;
        while (n < end) {
            this.s1 = this.s1 + 1 & 0xFF;
            this.s2 = this.s2 + this.state[this.s1] & 0xFF;
            byte temp = this.state[this.s1];
            this.state[this.s1] = this.state[this.s2];
            this.state[this.s2] = temp;
            byte b = this.state[this.state[this.s1] + this.state[this.s2] & 0xFF];
            int n2 = n++;
            data[n2] = (byte)(data[n2] ^ b);
        }
    }

    private void setKey(byte[] key, int offset, int length) {
        this.state = new byte[256];
        for (int n = 0; n < this.state.length; ++n) {
            this.state[n] = (byte)n;
        }
        int k2 = 0;
        for (int k1 = 0; k1 < 256; ++k1) {
            k2 = k2 + key[(k1 + offset) % length] + this.state[k1] & 0xFF;
            byte temp = this.state[k1];
            this.state[k1] = this.state[k2];
            this.state[k2] = temp;
        }
        this.s2 = 0;
        this.s1 = 0;
    }

    public void rewind(int iterations) {
        Preconditions.checkArgument(iterations >= 0, "Iterations to rewind must be non-negative: iterations=%s", iterations);
        for (int i = 0; i != iterations; ++i) {
            byte temp = this.state[this.s1];
            this.state[this.s1] = this.state[this.s2];
            this.state[this.s2] = temp;
            this.s2 = this.s2 - this.state[this.s1] & 0xFF;
            this.s1 = this.s1 - 1 & 0xFF;
        }
    }
}

