/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public abstract class CertStoreResolver {
    public final String password;
    public final String path;
    public final String type;
    private final boolean simulateDefault;

    protected CertStoreResolver(String string, String string2, boolean bl) {
        this.password = string2 == null ? "" : string2;
        this.path = string == null ? "" : string;
        this.simulateDefault = bl;
        this.type = this.resolveType();
    }

    private String resolveType() {
        String string = KeyStore.getDefaultType();
        String string2 = this.path.toLowerCase();
        if (string2.endsWith("jks")) {
            string = "JKS";
        } else if (string2.endsWith("p12") || string2.endsWith("pkcs12")) {
            string = "PKCS12";
        } else {
            try {
                File file = new File(this.path);
                String string3 = file.getCanonicalPath();
                if (string3.lastIndexOf(".") != -1) {
                    string = string3.substring(string3.lastIndexOf(".") + 1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore;
        block8: {
            FileInputStream fileInputStream = null;
            try {
                KeyStore keyStore2;
                try {
                    keyStore2 = KeyStore.getInstance(this.type);
                }
                catch (KeyStoreException keyStoreException) {
                    keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
                }
                File file = new File(this.path);
                if (file.exists()) {
                    fileInputStream = new FileInputStream(this.path);
                    keyStore2.load(fileInputStream, this.password.toCharArray());
                } else if (this.simulateDefault) {
                    keyStore2.load(null, this.password.toCharArray());
                } else {
                    throw new FileNotFoundException("Could not open store located at: " + ("".equals(this.path) ? "\"\"" : this.path));
                }
                keyStore = keyStore2;
                Object var6_6 = null;
                if (fileInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_7 = null;
                    if (fileInputStream == null) break block9;
                    fileInputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
        }
        return keyStore;
    }
}

