/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.support.LogUtilities;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class S4PooledConnection
extends SPooledConnection {
    private List<StatementEventListener> m_statementlisteners = new ArrayList<StatementEventListener>();

    public S4PooledConnection(SConnection sConnection) throws SQLException {
        super(sConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        if (null != statementEventListener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.add(statementEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, statementEventListener);
        if (null != statementEventListener) {
            List<StatementEventListener> list = this.m_statementlisteners;
            synchronized (list) {
                this.m_statementlisteners.remove(statementEventListener);
            }
        }
    }

    public void onHandleStatementClose(PreparedStatement preparedStatement) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementClosed(new StatementEvent(this, preparedStatement));
        }
    }

    public void onHandleStatementError(PreparedStatement preparedStatement, SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (StatementEventListener statementEventListener : this.m_statementlisteners) {
            statementEventListener.statementErrorOccurred(new StatementEvent(this, preparedStatement, sQLException));
        }
    }
}

