/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public abstract class SPooledConnection
implements PooledConnection {
    private List<ConnectionEventListener> m_listeners = new ArrayList<ConnectionEventListener>();
    protected SConnectionHandle m_connectionHandle;
    protected ILogger m_logger;

    public SPooledConnection(SConnection sConnection) throws SQLException {
        this.m_logger = sConnection.getConnection().getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_logger, sConnection);
        this.m_connectionHandle = JDBCObjectFactory.getInstance().createConnectionHandle(sConnection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        if (null != connectionEventListener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.add(connectionEventListener);
            }
        }
    }

    public void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.forceClose();
    }

    public Connection getConnection() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_connectionHandle.open();
        return this.m_connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        LogUtilities.logFunctionEntrance(this.m_logger, connectionEventListener);
        if (null != connectionEventListener) {
            List<ConnectionEventListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.remove(connectionEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHandleClose() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ConnectionEventListener> list = this.m_listeners;
        synchronized (list) {
            for (ConnectionEventListener connectionEventListener : this.m_listeners) {
                connectionEventListener.connectionClosed(new ConnectionEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandleError(SQLException sQLException) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        List<ConnectionEventListener> list = this.m_listeners;
        synchronized (list) {
            for (ConnectionEventListener connectionEventListener : this.m_listeners) {
                connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
            }
        }
    }
}

