/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.ErrorException;

public abstract class DSISimpleResultSet
implements IResultSet {
    private int m_fetchSize;
    private boolean m_hasStartedFetch = false;
    private int m_currentRow = 0;
    private IWarningListener m_warningListener = null;

    protected DSISimpleResultSet() {
    }

    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public void close() {
    }

    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0;
        this.doCloseCursor();
    }

    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    public boolean moveToNextRow() throws ErrorException {
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0;
        } else {
            ++this.m_currentRow;
        }
        return this.doMoveToNextRow();
    }

    public void onFinishRowUpdate() {
    }

    public void onStartRowUpdate() {
    }

    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    public void setFetchSize(int n) throws ErrorException {
        this.m_fetchSize = n;
    }

    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    protected abstract void doCloseCursor() throws ErrorException;

    protected abstract boolean doMoveToNextRow() throws ErrorException;

    protected int getCurrentRow() {
        return this.m_currentRow;
    }
}

