/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeTIMESTAMPLTZ
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1615519855865602397L;
    int precision = 0;
    transient oracle.jdbc.internal.OracleConnection connection;

    protected OracleTypeTIMESTAMPLTZ() {
    }

    public OracleTypeTIMESTAMPLTZ(oracle.jdbc.internal.OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    @Override
    public int getTypeCode() {
        return -102;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.precision);
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new TIMESTAMPLTZ(byArray);
            }
            case 2: {
                return JavaToJavaConverter.convert(new TIMESTAMPLTZ(byArray), OffsetDateTime.class, (OracleConnection)this.connection.getPhysicalConnection(), null, null);
            }
            case 3: {
                return byArray;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59).fillInStackTrace();
    }

    @Override
    public Datum toDatum(Object object, oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        Datum datum = null;
        if (object != null) {
            try {
                datum = object instanceof TIMESTAMPLTZ ? (TIMESTAMPLTZ)object : (object instanceof byte[] ? new TIMESTAMPLTZ((byte[])object) : (object instanceof Timestamp ? new TIMESTAMPLTZ((Connection)oracleConnection, (Timestamp)object) : (object instanceof DATE ? new TIMESTAMPLTZ((Connection)oracleConnection, (DATE)object) : (object instanceof String ? new TIMESTAMPLTZ((Connection)oracleConnection, (String)object) : (object instanceof Date ? new TIMESTAMPLTZ((Connection)oracleConnection, (Date)object) : (object instanceof Time ? new TIMESTAMPLTZ((Connection)oracleConnection, (Time)object) : (Datum)JavaToJavaConverter.convert(object, TIMESTAMPLTZ.class, (OracleConnection)this.connection.getPhysicalConnection(), null, null)))))));
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
            }
        }
        return datum;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

