/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class MsiCommunication {
    private static final String MSI_PIPE_NAME = System.getProperty("install4j.msiPipe");
    private static final String COMMAND_ELEVATION_REQUESTED = "__I4J_ELEVATION_REQUESTED";
    private static long pipeId;
    private static volatile boolean connected;

    public static synchronized boolean connect() {
        if (Util.isWindows() && !connected && MSI_PIPE_NAME != null && !Objects.equals(MSI_PIPE_NAME, "null") && (pipeId = Win32CommunicationBackend.connectClient0(MSI_PIPE_NAME)) != Win32CommunicationBackend.getInvalidHandle0()) {
            connected = true;
        }
        return connected;
    }

    public static boolean isConnected() {
        return connected;
    }

    public static synchronized boolean executeElevated(String commandLine, File workingDir) {
        if (MsiCommunication.connect() && MsiCommunication.writeDataBlock((workingDir.getAbsolutePath() + "|" + commandLine).getBytes(StandardCharsets.UTF_16LE))) {
            byte[] bytes = MsiCommunication.readDataBlock();
            if (bytes != null && bytes.length == 4) {
                int result = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get();
                if (result == 1) {
                    return true;
                }
                Logger.getInstance().error(null, "MSI elevation returned " + result);
            } else {
                Logger.getInstance().error(null, "MSI elevation returned " + Arrays.toString(bytes));
            }
        } else {
            Logger.getInstance().error(null, "Could not request MSI elevation");
        }
        return false;
    }

    public static boolean sendElevationRequested() {
        if (MsiCommunication.connect() && MsiCommunication.writeDataBlock(COMMAND_ELEVATION_REQUESTED.getBytes(StandardCharsets.UTF_16LE))) {
            Logger.getInstance().error(null, "MSI was already started elevated");
            return true;
        }
        Logger.getInstance().error(null, "Could not update MSI elevation status");
        return false;
    }

    private static synchronized boolean writeDataBlock(byte[] bytes) {
        return Win32CommunicationBackend.writeDataBlock0(pipeId, bytes);
    }

    private static synchronized byte[] readDataBlock() {
        return Win32CommunicationBackend.readDataBlock0(pipeId);
    }
}

