/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.Context;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.content.ProxyHostInfo;
import com.install4j.runtime.installer.platform.win32.Win32Proxy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyHelper {
    public static final String SYSPROP_PROXY_HOST = "proxyHost";
    public static final String SYSPROP_PROXY_PORT = "proxyPort";

    @NotNull
    public static Proxy getProxyHostInfo(final URL url) {
        ProxyHostInfo proxyHostInfo;
        Proxy externalProxy = ProxyHelper.getExternalProxy(url.getProtocol().toLowerCase(Locale.ROOT));
        if (externalProxy != null) {
            return externalProxy;
        }
        if (!HelperCommunication.getUnelevatedBooleanProperty("install4j.noProxyAutoDetect") && (proxyHostInfo = HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<ProxyHostInfo>(){

            @Override
            protected ProxyHostInfo fetchValue(Context context) throws Exception {
                if (InstallerUtil.isWindows()) {
                    return ProxyHelper.autoDetectWindowsProxy(url);
                }
                return ProxyHelper.autoDetectJavaProxy(url);
            }
        })) != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostInfo.getHost(), proxyHostInfo.getPort()));
        }
        return Proxy.NO_PROXY;
    }

    @Nullable
    private static Proxy getExternalProxy(@NotNull String protocol) {
        String host = HelperCommunication.getUnelevatedProperty(SYSPROP_PROXY_HOST);
        if (host != null) {
            String portText = HelperCommunication.getUnelevatedProperty(SYSPROP_PROXY_PORT);
            int port = ProxyHelper.parsePort(portText, protocol.equals("http") ? 80 : 443);
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
        return null;
    }

    private static int parsePort(@Nullable String portText, int defaultValue) {
        if (portText != null) {
            try {
                return Integer.parseInt(portText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Nullable
    private static ProxyHostInfo autoDetectWindowsProxy(URL url) {
        String host = url.getHost().toLowerCase(Locale.ENGLISH);
        if (host.equals("localhost") || host.equals("127.0.0.1")) {
            return null;
        }
        try {
            return Win32Proxy.getProxyHostInfo(url);
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
            t.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static ProxyHostInfo autoDetectJavaProxy(URL url) {
        try {
            Proxy proxy;
            SocketAddress address;
            List<Proxy> proxies = ProxySelector.getDefault().select(url.toURI());
            if (proxies != null && proxies.size() > 0 && (address = (proxy = proxies.get(0)).address()) instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                return new ProxyHostInfo(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

