/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.Util;
import com.install4j.api.beans.ErrorHandlingMode;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.KeyValuePair;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpRequestAction
extends SystemInstallOrUninstallAction {
    private String url = "";
    private List<KeyValuePair> requestHeaders = new ArrayList<KeyValuePair>();
    private boolean askForProxy = true;
    private ScriptProperty connectionFailureScript;
    private int connectTimeout = 10000;
    private int readTimeout = 20000;
    private boolean acceptAllCertificates = false;

    protected static boolean askRetry(String message) throws UserCanceledException {
        switch (Util.showOptionDialog(message, new String[]{Messages.getString(".ButtonYes"), Messages.getString(".ButtonNo"), Messages.getString(".ButtonCancel")}, 2)) {
            case 2: {
                throw new UserCanceledException();
            }
            case -1: 
            case 1: {
                return false;
            }
        }
        return true;
    }

    public String getUrl() {
        return AbstractHttpRequestAction.replaceVariables(AbstractHttpRequestAction.replaceVariables(this.url));
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<KeyValuePair> getRequestHeaders() {
        return this.replaceWithTextOverride("requestHeaders", this.requestHeaders, List.class);
    }

    public void setRequestHeaders(List<KeyValuePair> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public boolean isAskForProxy() {
        return this.replaceWithTextOverride("askForProxy", this.askForProxy);
    }

    public void setAskForProxy(boolean askForProxy) {
        this.askForProxy = askForProxy;
    }

    public ScriptProperty getConnectionFailureScript() {
        return this.replaceWithTextOverride("connectionFailureScript", this.connectionFailureScript, ScriptProperty.class);
    }

    public void setConnectionFailureScript(ScriptProperty connectionFailureScript) {
        this.connectionFailureScript = connectionFailureScript;
    }

    public int getConnectTimeout() {
        return this.replaceWithTextOverride("connectTimeout", this.connectTimeout);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.replaceWithTextOverride("readTimeout", this.readTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isAcceptAllCertificates() {
        return this.replaceWithTextOverride("acceptAllCertificates", this.acceptAllCertificates);
    }

    public void setAcceptAllCertificates(boolean acceptAllCertificates) {
        this.acceptAllCertificates = acceptAllCertificates;
    }

    protected void applyCommonProperties(HttpRequestHandler requestHandler) {
        requestHandler.setErrorHandlingCallback(e -> {
            if (this.getConnectionFailureScript() != null) {
                try {
                    return (ErrorHandlingMode)((Object)((Object)ContextImpl.getCurrentContext().runScript(this.getConnectionFailureScript(), this, e)));
                }
                catch (Exception e1) {
                    Logger.getInstance().log(e1);
                }
            }
            return null;
        });
        requestHandler.setConnectTimeout(this.getConnectTimeout());
        requestHandler.setReadTimeout(this.getReadTimeout());
        requestHandler.setRequestHeaders(this.createRequestHeadersMap());
        requestHandler.setAcceptAllCertificates(this.isAcceptAllCertificates());
    }

    private Map<String, List<String>> createRequestHeadersMap() {
        LinkedHashMap<String, List<String>> requestHeadersMap = new LinkedHashMap<String, List<String>>();
        for (KeyValuePair requestHeader : this.getRequestHeaders()) {
            String key = AbstractHttpRequestAction.replaceVariables(requestHeader.getKey());
            List values = requestHeadersMap.computeIfAbsent(key, k -> new ArrayList());
            values.add(AbstractHttpRequestAction.replaceVariables(requestHeader.getValue()));
        }
        return requestHeadersMap;
    }

    protected String wrapMessageInNobr(String message) {
        return "<html><nobr>" + message + "</nobr>";
    }
}

