/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreeCellRenderer;

public class StyledTreeCellRenderer
extends StyledLabel
implements TreeCellRenderer {
    private JTree \u0574;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean \u0575;
    private boolean \u0571;
    private Color \u0573;
    private Color \u0572;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public StyledTreeCellRenderer() {
        this.\u015d();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.\u015d();
    }

    private void \u015d() {
        this.setLeafIcon(UIDefaultsLookup.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIDefaultsLookup.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIDefaultsLookup.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIDefaultsLookup.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIDefaultsLookup.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIDefaultsLookup.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIDefaultsLookup.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIDefaultsLookup.getColor("Tree.selectionBorderColor"));
        Object object = UIDefaultsLookup.get("Tree.drawsFocusBorderAroundIcon");
        this.\u0575 = object != null && (Boolean)object != false;
        object = UIDefaultsLookup.get("Tree.drawDashedFocusIndicator");
        this.\u0571 = object != null && (Boolean)object != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIDefaultsLookup.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIDefaultsLookup.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIDefaultsLookup.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.\u0574 != null) {
            font = this.\u0574.getFont();
        }
        return font;
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        this.setOpaque(false);
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setIgnoreColorSettings(bl);
        this.customizeStyledLabel(jTree, object, bl, bl2, bl3, n2, bl4);
        this.\u0574 = jTree;
        this.hasFocus = bl4;
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.applyComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    protected void customizeStyledLabel(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n2, bl4);
        this.clearStyleRanges();
        this.setText(string);
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n2 = -1;
        if ((this.selected || this.isOpaque()) && color != null) {
            n2 = this.\u015c();
            graphics.setColor(color);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n2, 0, this.getWidth() - n2, this.getHeight());
            } else {
                graphics.fillRect(0, 0, this.getWidth() - n2, this.getHeight());
            }
        }
        super.paint(graphics);
        if (this.hasFocus) {
            if (this.\u0575) {
                n2 = 0;
            } else if (n2 == -1) {
                n2 = this.\u015c();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.\u0101(graphics, n2, 0, this.getWidth() - n2, this.getHeight());
            } else {
                this.\u0101(graphics, 0, 0, this.getWidth() - n2, this.getHeight());
            }
        }
    }

    private void \u0101(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = this.getBorderSelectionColor();
        if (color != null && (this.selected || !this.\u0571)) {
            graphics.setColor(color);
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        }
        if (this.\u0571) {
            Color color2;
            if (this.selected) {
                color2 = this.getBackgroundSelectionColor();
            } else {
                color2 = this.getBackgroundNonSelectionColor();
                if (color2 == null) {
                    color2 = this.getBackground();
                }
            }
            if (this.\u0573 != color2) {
                this.\u0573 = color2;
                this.\u0572 = new Color(~color2.getRGB());
            }
            graphics.setColor(this.\u0572);
            BasicGraphicsUtils.drawDashedRect(graphics, n2, n3, n4, n5);
        }
    }

    private int \u015c() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText().trim().length() != 0) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap());
        }
        return 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string.equals("text")) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c2, char c3) {
    }

    @Override
    public void firePropertyChange(String string, short s2, short s3) {
    }

    @Override
    public void firePropertyChange(String string, int n2, int n3) {
    }

    @Override
    public void firePropertyChange(String string, long l2, long l3) {
    }

    @Override
    public void firePropertyChange(String string, float f2, float f3) {
    }

    @Override
    public void firePropertyChange(String string, double d2, double d3) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

