/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.SortableListModel;
import com.jidesoft.tree.DefaultTreeModelWrapper;
import javax.swing.ListModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SortableTreeModel
extends DefaultTreeModelWrapper {
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = -1;
    public static final int UNSORTED = 0;
    private int \u0103 = 0;

    public SortableTreeModel() {
    }

    public SortableTreeModel(TreeModel treeModel) {
        super(treeModel);
    }

    @Override
    protected ListModelWrapper createListModelWrapper(Object object) {
        SortableListModel sortableListModel = new SortableListModel();
        sortableListModel.setOptimized(false);
        return sortableListModel;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (this.getSortOrder() == 0) {
            super.treeNodesChanged(treeModelEvent);
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
            if (listModelWrapper != null) {
                ListModel listModel = ListModelWrapperUtils.getActualListModel(listModelWrapper.getActualModel());
                int[] nArray = treeModelEvent.getChildIndices();
                if (listModel instanceof DefaultTreeModelWrapper.A && nArray != null && nArray.length >= 1) {
                    int n2;
                    int[] nArray2 = new int[nArray.length];
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        nArray2[n2] = ListModelWrapperUtils.getIndexAt((ListModel)((Object)listModelWrapper), listModel, nArray[n2]);
                    }
                    ((DefaultTreeModelWrapper.A)listModel).fireContentsChanged(listModel, nArray[0], nArray[nArray.length - 1]);
                    n2 = 0;
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        if (nArray2[i2] == ListModelWrapperUtils.getIndexAt((ListModel)((Object)listModelWrapper), listModel, nArray[i2])) continue;
                        n2 = 1;
                        break;
                    }
                    if (this.shouldOptimize(treeModelEvent) || n2 == 0) {
                        TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 2);
                        this.fireTreeNodesChanged(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
                    } else {
                        this.fireTreeStructureChanged(this, treePath);
                    }
                    return;
                }
            }
            super.treeNodesChanged(treeModelEvent);
        }
    }

    @Override
    protected TreeModelEvent convertTreeModelEvent(TreeModelEvent treeModelEvent, int n2) {
        if (n2 == 2) {
            TreePath treePath = treeModelEvent.getTreePath();
            int n3 = this.getChildCount(treePath.getLastPathComponent());
            int[] nArray = new int[n3];
            Object[] objectArray = new Object[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = i2;
                objectArray[i2] = this.getChild(treePath.getLastPathComponent(), i2);
            }
            return new TreeModelEvent((Object)this, treeModelEvent.getPath(), nArray, objectArray);
        }
        return super.convertTreeModelEvent(treeModelEvent, n2);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (this.getSortOrder() == 0) {
            super.treeNodesInserted(treeModelEvent);
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
            if (listModelWrapper != null) {
                ListModel listModel = ListModelWrapperUtils.getActualListModel(listModelWrapper.getActualModel());
                int[] nArray = treeModelEvent.getChildIndices();
                if (listModel instanceof DefaultTreeModelWrapper.A && nArray != null && nArray.length >= 1 && this.shouldOptimize(treeModelEvent)) {
                    ((DefaultTreeModelWrapper.A)listModel).fireIntervalAdded(listModel, nArray[0], nArray[nArray.length - 1]);
                    TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 0);
                    this.fireTreeNodesInserted(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
                    return;
                }
            }
            super.treeNodesInserted(treeModelEvent);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (this.getSortOrder() == 0) {
            super.treeNodesRemoved(treeModelEvent);
            return;
        }
        TreePath treePath = treeModelEvent.getTreePath();
        if (treePath != null) {
            TreeModelEvent treeModelEvent2 = this.convertTreeModelEvent(treeModelEvent, 1);
            ListModelWrapper listModelWrapper = this.getListModelWrapper(treePath.getLastPathComponent());
            if (listModelWrapper != null) {
                ListModel listModel = ListModelWrapperUtils.getActualListModel(listModelWrapper.getActualModel());
                int[] nArray = treeModelEvent.getChildIndices();
                if (listModel instanceof DefaultTreeModelWrapper.A && nArray != null && nArray.length >= 1 && this.shouldOptimize(treeModelEvent)) {
                    ((DefaultTreeModelWrapper.A)listModel).fireIntervalRemoved(listModel, nArray[0], nArray[nArray.length - 1]);
                    this.fireTreeNodesRemoved(this, treeModelEvent2.getPath(), treeModelEvent2.getChildIndices(), treeModelEvent2.getChildren());
                    return;
                }
            }
            super.treeNodesRemoved(treeModelEvent);
        }
    }

    protected boolean shouldOptimize(TreeModelEvent treeModelEvent) {
        return treeModelEvent.getChildIndices().length == 1 && treeModelEvent.getChildren().length == 1 && treeModelEvent.getChildren()[0] instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)treeModelEvent.getChildren()[0]).isLeaf();
    }

    @Override
    protected void configureListModelWrapper(ListModelWrapper listModelWrapper, Object object) {
        if (listModelWrapper instanceof SortableListModel) {
            ((SortableListModel)listModelWrapper).setSortOrder(this.\u0103);
        }
    }

    public int getSortOrder() {
        return this.\u0103;
    }

    public void setSortOrder(int n2) {
        this.\u0103 = n2;
        this.clearAllListModelWrappers();
        this.fireTreeStructureChanged(this, new TreePath(this.getRoot()));
    }

    public void sort(int n2) {
        this.setSortOrder(n2);
    }

    public void sort() {
        this.setSortOrder(1);
    }

    public void unsort() {
        this.setSortOrder(0);
    }
}

