/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxTreeCellRenderer;
import com.jidesoft.swing.CheckBoxTreeSelectionModel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer _treeCellRenderer;
    private CheckBoxTreeSelectionModel \u0103;
    private boolean \u0107 = true;
    private boolean \u0101 = true;
    private PropertyChangeListener \u0102;
    private TristateCheckBox \u0106;
    private boolean \u0105 = true;
    private TreeCellRenderer \u0104;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public CheckBoxTree(Vector<?> vector) {
        super(vector);
        this.init();
    }

    public CheckBoxTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode) {
        super(treeNode);
        this.init();
    }

    public CheckBoxTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.init();
    }

    public CheckBoxTree(TreeModel treeModel) {
        super(treeModel);
        this.init();
    }

    protected void init() {
        this.\u0103 = this.createCheckBoxTreeSelectionModel(this.getModel());
        this.\u0103.\u0101(this);
        Handler handler = this.createHandler();
        JideSwingUtilities.insertMouseListener(this, handler, 0);
        this.addKeyListener(handler);
        this.\u0103.addTreeSelectionListener(handler);
        if (this.\u0102 == null) {
            this.\u0102 = new B();
        }
        this.addPropertyChangeListener("selectionModel", this.\u0102);
        this.addPropertyChangeListener("model", this.\u0102);
        this.\u0102();
    }

    protected CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel treeModel) {
        return new CheckBoxTreeSelectionModel(treeModel);
    }

    private void \u0102() {
        this.\u0103.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer treeCellRenderer = this.getActualCellRenderer();
        if (treeCellRenderer == null) {
            treeCellRenderer = this.\u0101();
        }
        if (this._treeCellRenderer == null) {
            this._treeCellRenderer = this.createCellRenderer(treeCellRenderer);
        } else {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
        return this._treeCellRenderer;
    }

    private TreeCellRenderer \u0101() {
        if (this.\u0104 == null) {
            this.\u0104 = new DefaultTreeCellRenderer();
        }
        return this.\u0104;
    }

    public TreeCellRenderer getActualCellRenderer() {
        if (this._treeCellRenderer != null) {
            return this._treeCellRenderer.getActualTreeRenderer();
        }
        return super.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (treeCellRenderer == null) {
            treeCellRenderer = this.\u0101();
        }
        super.setCellRenderer(treeCellRenderer);
        if (this._treeCellRenderer != null) {
            this._treeCellRenderer.setActualTreeRenderer(treeCellRenderer);
        }
    }

    protected CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer treeCellRenderer) {
        CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(treeCellRenderer, this.getCheckBox());
        this.addPropertyChangeListener("cellRenderer", new A(checkBoxTreeCellRenderer));
        return checkBoxTreeCellRenderer;
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public TristateCheckBox getCheckBox() {
        return this.\u0106;
    }

    public void setCheckBox(TristateCheckBox tristateCheckBox) {
        if (this.\u0106 != tristateCheckBox) {
            this.\u0106 = tristateCheckBox;
            this._treeCellRenderer = null;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isSelectPartialOnToggling() {
        return this.\u0105 || this.selectionModel.getClass().getName().contains("Filter");
    }

    public void setSelectPartialOnToggling(boolean bl) {
        this.\u0105 = bl;
    }

    @Override
    public TreePath getNextMatch(String string, int n2, Position.Bias bias) {
        return null;
    }

    public CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this.\u0103;
    }

    public boolean isCheckBoxEnabled() {
        return this.\u0107;
    }

    public void setCheckBoxEnabled(boolean bl) {
        if (bl != this.\u0107) {
            Boolean bl2 = this.\u0107 ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.\u0107 = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, bl3);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath treePath) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath treePath) {
        return true;
    }

    public boolean isDigIn() {
        return this.getCheckBoxTreeSelectionModel().isDigIn();
    }

    public void setDigIn(boolean bl) {
        boolean bl2 = this.isDigIn();
        if (bl2 != bl) {
            this.getCheckBoxTreeSelectionModel().setDigIn(bl);
            this.firePropertyChange(PROPERTY_DIG_IN, bl2, bl);
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this.\u0101;
    }

    public void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this.\u0101) {
            boolean bl2 = this.\u0101;
            this.\u0101 = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this.\u0101);
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    TreeSelectionListener {
        protected CheckBoxTree _tree;
        int \u0101;
        private int \u0102;

        public Handler(CheckBoxTree checkBoxTree) {
            this.\u0101 = new JCheckBox().getPreferredSize().width;
            this.\u0102 = -1;
            this._tree = checkBoxTree;
        }

        protected TreePath getTreePathForMouseEvent(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return null;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return null;
            }
            TreePath treePath = this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return null;
            }
            if (this.clicksInCheckBox(mouseEvent, treePath) || !this._tree.isClickInCheckBoxOnly()) {
                return treePath;
            }
            return null;
        }

        protected boolean clicksInCheckBox(MouseEvent mouseEvent, TreePath treePath) {
            if (!this._tree.isCheckBoxVisible(treePath)) {
                return false;
            }
            Rectangle rectangle = this._tree.getPathBounds(treePath);
            if (this._tree.getComponentOrientation().isLeftToRight()) {
                return mouseEvent.getX() < rectangle.x + this.\u0101;
            }
            return mouseEvent.getX() > rectangle.x + rectangle.width - this.\u0101;
        }

        private TreePath \u0101(MouseEvent mouseEvent) {
            int n2;
            TreePath treePath = this.getTreePathForMouseEvent(mouseEvent);
            if (treePath != null && (n2 = this._tree.getToggleClickCount()) != -1) {
                this.\u0102 = n2;
                this._tree.setToggleClickCount(-1);
            }
            return treePath;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            this.\u0101(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = this.\u0101(mouseEvent);
            if (treePath != null) {
                JTree jTree;
                this.\u0101(new TreePath[]{treePath});
                Object object = mouseEvent.getSource();
                if (object instanceof JTree && !(jTree = (JTree)object).hasFocus() && jTree.isFocusable() && jTree.isRequestFocusEnabled()) {
                    jTree.requestFocusInWindow();
                }
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            TreePath treePath = this.\u0101(mouseEvent);
            if (treePath != null) {
                mouseEvent.consume();
            }
            if (this.\u0102 != -1) {
                this._tree.setToggleClickCount(this.\u0102);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (!this._tree.isCheckBoxEnabled()) {
                return;
            }
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this._tree.treeDidChange();
        }

        protected void toggleSelections() {
            TreePath[] treePathArray = this._tree.getSelectionPaths();
            this.\u0101(treePathArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void \u0101(TreePath[] treePathArray) {
            if (treePathArray == null || treePathArray.length == 0 || !this._tree.isEnabled()) {
                return;
            }
            CheckBoxTreeSelectionModel checkBoxTreeSelectionModel = this._tree.getCheckBoxTreeSelectionModel();
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
            for (TreePath treePath : treePathArray) {
                if (!this._tree.isCheckBoxEnabled(treePath)) continue;
                boolean bl = checkBoxTreeSelectionModel.isPathSelected(treePath, checkBoxTreeSelectionModel.isDigIn());
                if (bl) {
                    arrayList2.add(treePath);
                    continue;
                }
                if (!this._tree.isSelectPartialOnToggling() && checkBoxTreeSelectionModel.isPartiallySelected(treePath)) {
                    TreePath[] treePathArray2 = checkBoxTreeSelectionModel.getSelectionPaths();
                    if (treePathArray2 == null) continue;
                    for (TreePath treePath2 : treePathArray2) {
                        if (!checkBoxTreeSelectionModel.\u0101(treePath2, treePath)) continue;
                        arrayList2.add(treePath2);
                    }
                    continue;
                }
                arrayList.add(treePath);
            }
            checkBoxTreeSelectionModel.removeTreeSelectionListener(this);
            try {
                if (arrayList.size() > 0) {
                    checkBoxTreeSelectionModel.addSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                }
                if (arrayList2.size() > 0) {
                    checkBoxTreeSelectionModel.removeSelectionPaths(arrayList2.toArray(new TreePath[arrayList2.size()]));
                }
            }
            finally {
                checkBoxTreeSelectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }
    }

    private class A
    implements PropertyChangeListener,
    Serializable {
        private static final long \u0103 = -5127656346976320157L;
        private CheckBoxTreeCellRenderer \u0102;

        public A(CheckBoxTreeCellRenderer checkBoxTreeCellRenderer) {
            this.\u0102 = checkBoxTreeCellRenderer;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TreeCellRenderer treeCellRenderer = (TreeCellRenderer)propertyChangeEvent.getNewValue();
            if (treeCellRenderer != this.\u0102) {
                this.\u0102.setActualTreeRenderer(treeCellRenderer);
            } else {
                this.\u0102.setActualTreeRenderer(null);
            }
        }
    }

    private class B
    implements PropertyChangeListener,
    Serializable {
        private static final long \u0102 = 521336220746879977L;

        private B() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                CheckBoxTree.this.\u0102();
            }
            if ("model".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof TreeModel) {
                CheckBoxTree.this.\u0103.setModel((TreeModel)propertyChangeEvent.getNewValue());
            }
        }
    }
}

