/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.AbstractScaleModel;
import com.jidesoft.scale.DatePeriod;
import com.jidesoft.scale.Period;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DateScaleModel
extends AbstractScaleModel<Date> {
    private static final long \u0107 = -2522724722032286931L;
    private static final Map<Integer, int[]> \u0105 = new HashMap<Integer, int[]>();
    private final Locale \u0106;

    public DateScaleModel() {
        this(DatePeriod.DAY_OF_WEEK, DatePeriod.FIRST_DAY_OF_WEEK, DatePeriod.MONTH, DatePeriod.QUARTER, DatePeriod.YEAR);
    }

    public DateScaleModel(DatePeriod ... datePeriodArray) {
        this(Locale.getDefault(), new Date(), DateScaleModel.\u0101(Locale.getDefault(), 1, 1, new Date()), datePeriodArray);
    }

    public DateScaleModel(Locale locale, Date date, Date date2, DatePeriod ... datePeriodArray) {
        super(date, date2, datePeriodArray);
        this.\u0106 = locale;
    }

    public Locale getLocale() {
        return this.\u0106;
    }

    private static Date \u0101(Locale locale, int n2, int n3, Date date) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.add(n2, n3);
        return calendar.getTime();
    }

    @Override
    public Date getInstantAt(long l2) {
        Calendar calendar = Calendar.getInstance(this.\u0106);
        calendar.setTimeInMillis(l2);
        return calendar.getTime();
    }

    @Override
    public Date getPeriodEnd(Period period, Date date) {
        DatePeriod datePeriod = (DatePeriod)period;
        Calendar calendar = this.\u0101(datePeriod, date);
        calendar.add(datePeriod.getCalendarField(), datePeriod.getAmount());
        return calendar.getTime();
    }

    @Override
    public Date getPeriodStart(Period period, Date date) {
        Calendar calendar = this.\u0101((DatePeriod)period, date);
        return calendar.getTime();
    }

    private Calendar \u0101(DatePeriod datePeriod, Date date) {
        int[] nArray;
        Calendar calendar = Calendar.getInstance(this.\u0106);
        calendar.setTime(date);
        int n2 = datePeriod.getCalendarField();
        this.\u0101(calendar, datePeriod);
        for (int n3 : nArray = \u0105.get(n2)) {
            this.\u0101(calendar, n3);
        }
        return calendar;
    }

    private void \u0101(Calendar calendar, DatePeriod datePeriod) {
        if (datePeriod.getAmount() != 1) {
            int n2 = datePeriod.getCalendarField();
            int n3 = calendar.getActualMinimum(n2);
            int n4 = calendar.get(n2);
            int n5 = (n3 + n4 + datePeriod.getOffset()) % datePeriod.getAmount();
            calendar.set(n2, n4 - n5);
        }
    }

    private void \u0101(Calendar calendar, int n2) {
        int n3 = calendar.getActualMinimum(n2);
        if (n2 == 7) {
            n3 = calendar.getFirstDayOfWeek();
        }
        calendar.set(n2, n3);
    }

    @Override
    public long getPosition(Date date) {
        Calendar calendar = Calendar.getInstance(this.\u0106);
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    @Override
    public List<Date> getPeriodBoundaries(Period period, Date date, Date date2) {
        Date date3;
        ArrayList<Date> arrayList = new ArrayList<Date>();
        DatePeriod datePeriod = (DatePeriod)period;
        Calendar calendar = this.\u0101(datePeriod, date);
        arrayList.add(calendar.getTime());
        do {
            calendar.add(datePeriod.getCalendarField(), datePeriod.getAmount());
            date3 = calendar.getTime();
            arrayList.add(date3);
        } while (date3.before(date2));
        return arrayList;
    }

    static {
        \u0105.put(0, new int[]{1, 2, 5, 11, 12, 13, 14});
        \u0105.put(1, new int[]{2, 5, 11, 12, 13, 14});
        \u0105.put(2, new int[]{5, 11, 12, 13, 14});
        \u0105.put(3, new int[]{7, 11, 12, 13, 14});
        \u0105.put(4, new int[]{7, 11, 12, 13, 14});
        \u0105.put(5, new int[]{11, 12, 13, 14});
        \u0105.put(6, new int[]{11, 12, 13, 14});
        \u0105.put(7, new int[]{11, 12, 13, 14});
        \u0105.put(8, new int[]{7, 11, 12, 13, 14});
        \u0105.put(9, new int[]{10, 12, 13, 14});
        \u0105.put(10, new int[]{12, 13, 14});
        \u0105.put(11, new int[]{12, 13, 14});
        \u0105.put(12, new int[]{13, 14});
        \u0105.put(13, new int[]{14});
        \u0105.put(14, new int[0]);
    }
}

