/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.AbstractPeriodConverter;
import com.jidesoft.scale.DatePeriod;
import com.jidesoft.scale.PeriodConverter;
import com.jidesoft.scale.ScaleArea;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DatePeriodConverter
extends AbstractPeriodConverter<Date> {
    private static final long \u0109 = 1491288903053008517L;
    private final DateFormat \u0104;
    private final DateFormat \u0105;
    private boolean \u0108;
    private int \u0107;
    public static final String RESOURCE_PREFIX = "ScaleArea.Date.";
    static final Map<Locale, Integer> \u0106 = new HashMap<Locale, Integer>();

    public DatePeriodConverter(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        super(string);
        this.\u0104 = dateFormat;
        this.\u0105 = dateFormat2;
    }

    public DatePeriodConverter(String string, DateFormat dateFormat, DateFormat dateFormat2, int n2) {
        this(string, dateFormat, dateFormat2);
        this.setFormatEndDate(true, n2);
    }

    public void setFormatEndDate(boolean bl, int n2) {
        this.\u0108 = bl;
        this.\u0107 = n2;
    }

    @Override
    public String getText(Date date, Date date2) {
        return this.getText(this.\u0104, date, date2);
    }

    @Override
    public String getDescription(Date date, Date date2) {
        return this.getText(this.\u0105, date, date2);
    }

    private Date \u0101(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(this.\u0107, n2);
        return calendar.getTime();
    }

    public String getText(DateFormat dateFormat, Date date, Date date2) {
        String string = this.format(dateFormat, date);
        if (this.\u0108) {
            String string2 = this.format(dateFormat, this.\u0101(date2, -1));
            string = string + "-" + string2;
        }
        return string;
    }

    protected String format(DateFormat dateFormat, Date date) {
        return dateFormat.format(date);
    }

    public static PeriodConverter<Date> createDefaultPeriodConverter(ScaleArea<Date> scaleArea) {
        return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.date"), DateFormat.getDateInstance(3), DateFormat.getDateInstance(1));
    }

    public static PeriodConverter<Date> createPeriodConverter(final ScaleArea<Date> scaleArea, DatePeriod datePeriod) {
        if (datePeriod == DatePeriod.MILLENIUM) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.millennium"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy"), 1);
        }
        if (datePeriod == DatePeriod.CENTURY) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.century"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy GGGG"), 1);
        }
        if (datePeriod == DatePeriod.DECENNIUM) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.decade"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy GGGG"), 1);
        }
        if (datePeriod == DatePeriod.YEAR) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.year"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy GGGG"));
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 9999);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.QUARTER) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.quarter"), new SimpleDateFormat("MMMM"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.monthOfYear.longFormat")));
            datePeriodConverter.setFormatEndDate(true, 5);
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.MONTH) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.month"), new SimpleDateFormat("MMMM"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.monthOfYear.longFormat")));
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, 8);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.WEEK_OF_MONTH) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.weekOfMonth"), new SimpleDateFormat("W"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.weekOfMonth.longFormat")));
        }
        if (datePeriod == DatePeriod.WEEK_OF_YEAR) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.weekOfYear"), new SimpleDateFormat("w"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.weekOfYear.longFormat")));
        }
        if (datePeriod == DatePeriod.FIRST_DAY_OF_WEEK) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.firstDayOfWeek"), SimpleDateFormat.getDateInstance(3), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.firstDayOfWeek.longFormat")), 7);
        }
        if (datePeriod == DatePeriod.DAY_OF_YEAR) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.dayOfYear"), SimpleDateFormat.getDateInstance(3), SimpleDateFormat.getDateInstance(1));
        }
        if (datePeriod == DatePeriod.DAY_OF_MONTH) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.dayOfMonth"), new SimpleDateFormat("d"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.date.longFormat")));
        }
        if (datePeriod == DatePeriod.DAY_OF_WEEK) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.dayOfWeek"), (DateFormat)new SimpleDateFormat("E"), (DateFormat)new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.date.longFormat"))){
                private static final long \u010b = -7991321514536114448L;

                @Override
                protected String format(DateFormat dateFormat, Date date) {
                    String string = super.format(dateFormat, date);
                    if (!(dateFormat instanceof SimpleDateFormat) || !"E".equals(((SimpleDateFormat)dateFormat).toPattern())) {
                        return string;
                    }
                    if (string.length() == 1) {
                        return string;
                    }
                    Locale locale = scaleArea.getLocale();
                    Integer n2 = (Integer)\u0106.get(locale);
                    if (n2 == null) {
                        String string2;
                        int n3;
                        int n4;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        int n5 = calendar.getMinimum(7);
                        int n6 = calendar.getMaximum(7);
                        calendar.set(7, n5);
                        String[] stringArray = new String[n6 - n5 + 1];
                        for (n4 = n5; n4 <= n6; ++n4) {
                            calendar.set(7, n4);
                            stringArray[n4 - n5] = super.format(dateFormat, calendar.getTime());
                        }
                        n2 = 0;
                        n4 = 32;
                        boolean bl = false;
                        int n7 = stringArray.length;
                        for (n3 = 0; n3 < n7; ++n3) {
                            string2 = stringArray[n3];
                            if (n3 == 0) {
                                n4 = string2.charAt(n2);
                                continue;
                            }
                            if (string2.charAt(n2) == n4) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            n2 = string.length() - 1;
                            n7 = stringArray.length;
                            for (n3 = 0; n3 < n7; ++n3) {
                                string2 = stringArray[n3];
                                if (n2 >= string.length()) break;
                                if (n3 == 0) {
                                    n4 = string2.charAt(n2);
                                    continue;
                                }
                                if (string2.charAt(n2) == n4) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) {
                            \u0106.put(locale, n2);
                        } else {
                            return string;
                        }
                    }
                    return string.substring(n2, n2 + 1);
                }
            };
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, 4);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.HOUR) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.hour"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.hour.format")), SimpleDateFormat.getDateTimeInstance());
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 11);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.HOUR_OF_DAY) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.hour"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.hourOfDay.format")), SimpleDateFormat.getDateTimeInstance());
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 23);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.MINUTE) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.minute"), new SimpleDateFormat("m"), new SimpleDateFormat("hh:mm"));
        }
        if (datePeriod == DatePeriod.SECOND) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.second"), new SimpleDateFormat("s"), new SimpleDateFormat("hh:mm:ss"));
        }
        if (datePeriod == DatePeriod.MILLISECOND) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.millisecond"), new SimpleDateFormat("S"), new SimpleDateFormat("hh:mm:ss-SS"));
        }
        return null;
    }
}

