/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.paging;

import com.jidesoft.grid.DefaultPageTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.DefaultPageListModel;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationField;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import com.jidesoft.swing.AutoRepeatButtonUtils;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class PageNavigationBar
extends JToolBar
implements PropertyChangeListener {
    private static final Logger \u0106;
    private JComponent \u0105;
    protected PageNavigationSupport _pageNavigationSupport;
    private boolean \u0103 = true;
    private Map<String, Action> \u0102;
    private PageNavigationListener \u0107;
    private boolean \u0101 = true;
    public static final String COMMAND_FIRST = "moveToBeginning";
    public static final String COMMAND_PREVIOUS = "moveLeft";
    public static final String COMMAND_NEXT = "moveRight";
    public static final String COMMAND_LAST = "moveToEnd";
    public static final String COMMAND_GOTO = "moveTo";
    public final String CLIENT_PROPERTY_ALWAYS_DISABLED = "PageNavigationBar.alwaysDisabled";
    protected PageNavigationField _pageNavigationField;
    private transient boolean \u0104 = false;

    protected PageNavigationBar() {
    }

    public PageNavigationBar(TableScrollPane tableScrollPane) {
        if (tableScrollPane == null) {
            return;
        }
        this.\u0105 = tableScrollPane;
        this.\u0105.addMouseWheelListener(this.createMouseWheelListener());
        tableScrollPane.getMainTable().getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.\u0101(tableScrollPane);
        tableScrollPane.addPropertyChangeListener("tableModel", this);
        this.initComponents();
        this.registerKeyboardActions(this.\u0105);
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    public PageNavigationBar(JTable jTable) {
        if (jTable == null) {
            return;
        }
        this.\u0105 = jTable;
        this.\u0105.addMouseWheelListener(this.createMouseWheelListener());
        jTable.getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.\u0101(jTable);
        jTable.addPropertyChangeListener("model", this);
        this.initComponents();
        this.registerKeyboardActions(this.\u0105);
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    protected PageNavigationSupport createPageTableModel(TableModel tableModel, int n2) {
        return new DefaultPageTableModel(tableModel, n2);
    }

    public PageNavigationBar(JList jList) {
        if (jList == null) {
            return;
        }
        this.\u0105 = jList;
        this.\u0105.addMouseWheelListener(this.createMouseWheelListener());
        jList.getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.\u0101(jList);
        jList.addPropertyChangeListener("model", this);
        this.initComponents();
        this.registerKeyboardActions(this.\u0105);
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    private void \u0101(TableScrollPane tableScrollPane) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(tableScrollPane.getTableModel(), PageNavigationSupport.class);
        int n2 = tableScrollPane.getMainTable().getPreferredScrollableViewportSize().height / tableScrollPane.getMainTable().getRowHeight();
        if (tableModel instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)tableModel);
            this._pageNavigationSupport.setPageSize(n2);
        } else {
            this._pageNavigationSupport = this.createPageTableModel(tableScrollPane.getTableModel(), n2);
            tableScrollPane.setTableModel((MultiTableModel)((Object)this._pageNavigationSupport));
        }
        if (this.\u0107 == null) {
            this.\u0107 = this.createPageNavigationListener();
        }
        this._pageNavigationSupport.addPageNavigationListener(this.\u0107);
    }

    private void \u0101(JTable jTable) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PageNavigationSupport.class);
        int n2 = jTable.getPreferredScrollableViewportSize().height / jTable.getRowHeight();
        if (tableModel instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)tableModel);
            this._pageNavigationSupport.setPageSize(n2);
        } else {
            this._pageNavigationSupport = this.createPageTableModel(jTable.getModel(), n2);
            jTable.setModel((TableModel)((Object)this._pageNavigationSupport));
        }
        if (this.\u0107 == null) {
            this.\u0107 = this.createPageNavigationListener();
        }
        this._pageNavigationSupport.addPageNavigationListener(this.\u0107);
    }

    private void \u0101(JList jList) {
        ListModel listModel = ListModelWrapperUtils.getActualListModel(jList.getModel(), PageNavigationSupport.class);
        Rectangle rectangle = jList.getCellBounds(0, 0);
        int n2 = rectangle != null ? jList.getPreferredScrollableViewportSize().height / rectangle.height : 0;
        if (listModel instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)listModel);
            this._pageNavigationSupport.setPageSize(n2);
        } else {
            this._pageNavigationSupport = new DefaultPageListModel(jList.getModel(), n2);
            jList.setModel((ListModel)((Object)this._pageNavigationSupport));
        }
        if (this.\u0107 == null) {
            this.\u0107 = this.createPageNavigationListener();
        }
        this._pageNavigationSupport.addPageNavigationListener(this.\u0107);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName()) || "tableModel".equals(propertyChangeEvent.getPropertyName())) {
            this.\u0105.removePropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
            if (this._pageNavigationSupport != null && this.\u0107 != null) {
                this._pageNavigationSupport.removePageNavigationListener(this.\u0107);
            }
            if (this.\u0105 instanceof JList) {
                this.\u0101((JList)this.\u0105);
            } else if (this.\u0105 instanceof JTable) {
                this.\u0101((JTable)this.\u0105);
            } else if (this.\u0105 instanceof TableScrollPane) {
                this.\u0101((TableScrollPane)this.\u0105);
            }
            this.updateNavigationField();
            this.updateButtonPanel();
            this.\u0105.addPropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
        }
    }

    protected void initComponents() {
        this.setOpaque(false);
        this.setFloatable(false);
        this.\u0102 = new HashMap<String, Action>();
        this.\u0102.put(COMMAND_FIRST, this.\u0101(COMMAND_FIRST));
        this.\u0102.put(COMMAND_PREVIOUS, this.\u0101(COMMAND_PREVIOUS));
        this.\u0102.put(COMMAND_NEXT, this.\u0101(COMMAND_NEXT));
        this.\u0102.put(COMMAND_LAST, this.\u0101(COMMAND_LAST));
        A a2 = new A();
        a2.putValue("ActionCommandKey", COMMAND_GOTO);
        this.\u0102.put(COMMAND_GOTO, a2);
        this._pageNavigationField = this.createNavigationField();
        this._pageNavigationField.setName(COMMAND_GOTO);
        this._pageNavigationField.getTextField().addActionListener(this.\u0102.get(COMMAND_GOTO));
        this._pageNavigationField.getTextField().addFocusListener(this.createFocusListener());
        this._pageNavigationField.addChangeListener(this.createChangeListener());
        if (this._pageNavigationField.getType() == 1) {
            String string = this.getResourceString("PageNavigationBar.currentPageOfTotal");
            String string2 = MessageFormat.format(string, this._pageNavigationSupport.getPageCount(), this._pageNavigationSupport.getPageCount());
            this._pageNavigationField.setColumns(string2.length());
        } else {
            String string = this.getResourceString("PageNavigationBar.currentRecordOfTotal");
            int n2 = this._pageNavigationSupport.getTotalRecordCount();
            int n3 = n2 >= 0 ? n2 : this._pageNavigationSupport.getPageSize() * this._pageNavigationSupport.getCurrentPage();
            String string3 = MessageFormat.format(string, n3, n3);
            this._pageNavigationField.setColumns(string3.length());
        }
        this.setLayout(new JideBoxLayout(this, 0));
        this.add(this.createButton(this.\u0102.get(COMMAND_FIRST)));
        this.add(this.createButton(this.\u0102.get(COMMAND_PREVIOUS)));
        this.add(this.createButton(this.\u0102.get(COMMAND_NEXT)));
        this.add(this.createButton(this.\u0102.get(COMMAND_LAST)));
        this.add(this._pageNavigationField);
        this.add(Box.createGlue(), "vary");
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PageNavigationBar.this.updateNavigationField();
                PageNavigationBar.this.updateButtonPanel();
                if (changeEvent.getSource() instanceof PageNavigationField) {
                    for (String string : PageNavigationBar.this.\u0102.keySet()) {
                        Action action = (Action)PageNavigationBar.this.\u0102.get(string);
                        PageNavigationBar.this.updateTooltipText(string, action);
                    }
                }
            }
        };
    }

    protected void updateTooltipText(String string, Action action) {
        int n2 = this._pageNavigationField == null ? 1 : this._pageNavigationField.getType();
        try {
            String string2 = this.getResourceString("PageNavigationBar." + string + ".tooltip");
            String string3 = MessageFormat.format(string2, this.getResourceString("PageNavigationField.field." + (n2 == 2 ? "record" : "page")).toLowerCase());
            if (string3 != null && string3.trim().length() > 0) {
                action.putValue("ShortDescription", string3);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PageNavigationBar.this.updateNavigationField();
                PageNavigationBar.this._pageNavigationField.getTextField().selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PageNavigationBar.this.updateNavigationField();
            }
        };
    }

    protected PageNavigationListener createPageNavigationListener() {
        return new PageNavigationListener(){

            @Override
            public void pageNavigationEventFired(PageNavigationEvent pageNavigationEvent) {
                PageNavigationBar.this.updateNavigationField();
                PageNavigationBar.this.updateButtonPanel();
            }
        };
    }

    protected ListSelectionListener createSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && PageNavigationBar.this._pageNavigationField.getType() == 2) {
                    PageNavigationBar.this.updateNavigationField();
                    PageNavigationBar.this.updateButtonPanel();
                }
            }
        };
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                switch (mouseWheelEvent.getScrollType()) {
                    case 0: {
                        if (mouseWheelEvent.isControlDown() || mouseWheelEvent.isMetaDown()) {
                            PageNavigationBar.this.gotoRecord(PageNavigationBar.this.getCurrentRecord() + PageNavigationBar.this._pageNavigationSupport.getPageSize() * mouseWheelEvent.getUnitsToScroll());
                            break;
                        }
                        PageNavigationBar.this.gotoRecord(PageNavigationBar.this.getCurrentRecord() + mouseWheelEvent.getUnitsToScroll());
                        break;
                    }
                    case 1: {
                        PageNavigationBar.this.gotoRecord(PageNavigationBar.this.getCurrentRecord() + PageNavigationBar.this._pageNavigationSupport.getPageSize() * mouseWheelEvent.getUnitsToScroll());
                    }
                }
            }
        };
    }

    protected void registerKeyboardActions(JComponent jComponent) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 128), KeyStroke.getKeyStroke(33, 128), KeyStroke.getKeyStroke(36, 128), KeyStroke.getKeyStroke(35, 128)};
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -6550729013493676340L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.nextRecord();
            }
        }, keyStrokeArray[0], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 1217786275623931897L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.previousRecord();
            }
        }, keyStrokeArray[1], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 7189245076490514878L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.nextPage();
            }
        }, keyStrokeArray[2], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 6252071064867942931L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.previousPage();
            }
        }, keyStrokeArray[3], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -1107823695182090812L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.lastRecordInPage();
            }
        }, keyStrokeArray[4], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -4880407554004818213L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.firstRecordInPage();
            }
        }, keyStrokeArray[5], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 3932257606575802109L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.firstRecord();
            }
        }, keyStrokeArray[6], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 7134970522999659483L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.lastRecord();
            }
        }, keyStrokeArray[7], 0);
        JideSwingUtilities.synchronizeKeyboardActions(jComponent, this._pageNavigationField, keyStrokeArray, 1);
    }

    public int getCurrentRecord() {
        int n2 = this.getSelectedRecordIndex();
        if (n2 == -1) {
            n2 = 0;
        }
        return this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + n2;
    }

    public void setTableModel(TableModel tableModel) {
        if (!(this.\u0105 instanceof JTable)) {
            return;
        }
        if (this._pageNavigationSupport != null) {
            this._pageNavigationSupport.removePageNavigationListener(this.\u0107);
        }
        JTable jTable = (JTable)this.\u0105;
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, PageNavigationSupport.class);
        int n2 = jTable.getPreferredScrollableViewportSize().height / jTable.getRowHeight();
        if (tableModel2 instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)tableModel2);
            this._pageNavigationSupport.setPageSize(n2);
        } else {
            if (tableModel2 == null) {
                tableModel2 = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PageNavigationSupport.class);
            }
            if (tableModel2 == this._pageNavigationSupport && this._pageNavigationSupport instanceof DefaultPageTableModel) {
                ((DefaultPageTableModel)this._pageNavigationSupport).setTableModel(tableModel);
            } else {
                this._pageNavigationSupport = new DefaultPageTableModel(tableModel, n2);
                jTable.setModel((TableModel)((Object)this._pageNavigationSupport));
            }
        }
        this._pageNavigationSupport.removePageNavigationListener(this.\u0107);
        this._pageNavigationSupport.addPageNavigationListener(this.\u0107);
        this.updateNavigationField();
    }

    public void setListModel(ListModel listModel) {
        int n2;
        if (!(this.\u0105 instanceof JList)) {
            return;
        }
        if (this._pageNavigationSupport != null) {
            this._pageNavigationSupport.removePageNavigationListener(this.\u0107);
        }
        JList jList = (JList)this.\u0105;
        ListModel listModel2 = ListModelWrapperUtils.getActualListModel(listModel, PageNavigationSupport.class);
        int n3 = n2 = listModel.getSize() == 0 ? 0 : jList.getPreferredScrollableViewportSize().height / jList.getCellBounds((int)0, (int)0).height;
        if (listModel2 instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)listModel2);
            this._pageNavigationSupport.setPageSize(n2);
        } else {
            this._pageNavigationSupport = new DefaultPageListModel(listModel, n2);
            jList.setModel((ListModel)((Object)this._pageNavigationSupport));
        }
        this._pageNavigationSupport.removePageNavigationListener(this.\u0107);
        this._pageNavigationSupport.addPageNavigationListener(this.\u0107);
        this.updateNavigationField();
    }

    protected PageNavigationField createNavigationField() {
        return new PageNavigationField();
    }

    public PageNavigationField getNavigationField() {
        return this._pageNavigationField;
    }

    protected void updateNavigationField() {
        if (this._pageNavigationField != null) {
            this._pageNavigationField.setEnabled(this.isEnabled());
            if (!this._pageNavigationField.getTextField().hasFocus()) {
                if (this._pageNavigationField.getType() == 1) {
                    String string = this.getResourceString("PageNavigationBar.currentPageOfTotal");
                    int n2 = this._pageNavigationSupport.getPageCount();
                    String string2 = MessageFormat.format(string, Math.min(n2, this._pageNavigationSupport.getCurrentPage() + 1), n2 < 0 ? "?" : Integer.valueOf(n2));
                    this._pageNavigationField.setText(string2);
                } else {
                    String string = this.getResourceString("PageNavigationBar.currentRecordOfTotal");
                    int n3 = this.getSelectedRecordIndex();
                    int n4 = this._pageNavigationSupport.getTotalRecordCount();
                    if (n3 == -1 && n4 > 0) {
                        n3 = 0;
                    }
                    String string3 = MessageFormat.format(string, this._pageNavigationSupport.getCurrentPage() < 0 ? 0 : this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + n3 + 1, n4 < 0 ? "?" : Integer.valueOf(n4));
                    this._pageNavigationField.setText(string3);
                }
            } else {
                if (this._pageNavigationField.getType() == 1) {
                    this._pageNavigationField.setText("" + (this._pageNavigationSupport.getCurrentPage() + 1));
                } else {
                    int n5 = this.getSelectedRecordIndex();
                    if (n5 == -1) {
                        n5 = 0;
                    }
                    this._pageNavigationField.setText("" + (this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + n5 + 1));
                }
                this._pageNavigationField.getTextField().selectAll();
            }
        }
    }

    protected AbstractButton createButton(Action action) {
        JideButton jideButton = new JideButton(action);
        jideButton.setName("" + action.getValue("ActionCommandKey"));
        jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        jideButton.setRequestFocusEnabled(false);
        AutoRepeatButtonUtils.install(jideButton, 50, 200);
        return jideButton;
    }

    private Action \u0101(String string) {
        A a2;
        block18: {
            String string2;
            block17: {
                ImageIcon imageIcon;
                String string3;
                block16: {
                    block15: {
                        block14: {
                            a2 = new A();
                            a2.putValue("ActionCommandKey", string);
                            string2 = "PageNavigationBar." + string + ".";
                            try {
                                string3 = this.getResourceString(string2 + "text");
                                if (string3 != null && string3.trim().length() > 0) {
                                    a2.putValue("Name", string3);
                                }
                            }
                            catch (Exception exception) {
                                if (!\u0106.isLoggable(Level.FINE)) break block14;
                                \u0106.fine(exception.getMessage());
                            }
                        }
                        string3 = null;
                        try {
                            string3 = this.getResourceString(string2 + "icon");
                        }
                        catch (Exception exception) {
                            if (!\u0106.isLoggable(Level.FINE)) break block15;
                            \u0106.fine(exception.getMessage());
                        }
                    }
                    if (string3 == null || string3.trim().length() == 0) {
                        string3 = String.format("icons/%s.png", string);
                    }
                    imageIcon = IconsFactory.getImageIcon(PageNavigationBar.class, string3);
                    a2.putValue("SmallIcon", imageIcon);
                    string3 = null;
                    try {
                        string3 = this.getResourceString(string2 + "disabledIcon");
                    }
                    catch (Exception exception) {
                        if (!\u0106.isLoggable(Level.FINE)) break block16;
                        \u0106.fine(exception.getMessage());
                    }
                }
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = String.format("icons/%s_disabled.png", string);
                }
                imageIcon = IconsFactory.getImageIcon(PageNavigationBar.class, string3);
                a2.putValue("disabledIcon", imageIcon);
                try {
                    this.updateTooltipText(string, a2);
                }
                catch (Exception exception) {
                    if (!\u0106.isLoggable(Level.FINE)) break block17;
                    \u0106.fine(exception.getMessage());
                }
            }
            try {
                String string4 = this.getResourceString(string2 + "mnemonic");
                if (string4 != null && string4.trim().length() > 1) {
                    a2.putValue("MnemonicKey", Character.valueOf(string4.charAt(0)));
                }
            }
            catch (Exception exception) {
                if (!\u0106.isLoggable(Level.FINE)) break block18;
                \u0106.fine(exception.getMessage());
            }
        }
        return a2;
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.paging.pageNavigationBar", this.getLocale()).getString(string);
    }

    public boolean isSelectViewIndex() {
        return this.\u0103;
    }

    public void setSelectViewIndex(boolean bl) {
        this.\u0103 = bl;
    }

    public void firstPage() {
        if (this._pageNavigationSupport != null) {
            int n2 = this.getSelectedRecordIndex();
            this._pageNavigationSupport.firstPage();
            this.setSelectedRecordIndex(n2);
            this.updateButtonPanel();
        }
    }

    public void lastPage() {
        if (this._pageNavigationSupport != null) {
            int n2 = this.getSelectedRecordIndex();
            this._pageNavigationSupport.lastPage();
            this.setSelectedRecordIndex(n2);
            this.updateButtonPanel();
        }
    }

    protected int getPageSize() {
        return this._pageNavigationSupport.getPageSize();
    }

    public void previousPage() {
        if (this._pageNavigationSupport != null) {
            int n2 = this.getSelectedRecordIndex();
            this.\u0101 = false;
            try {
                this.gotoRecord(Math.max(0, this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() - this.getPageSize()));
            }
            finally {
                this.\u0101 = true;
            }
            if (this.isSelectViewIndex()) {
                this.setSelectedRecordIndex(n2);
            }
        }
    }

    public void nextPage() {
        if (this._pageNavigationSupport != null) {
            int n2 = this.getSelectedRecordIndex();
            this.\u0101 = false;
            try {
                this.gotoRecord(Math.min(this._pageNavigationSupport.getPageCount() * this._pageNavigationSupport.getPageSize() - this.getPageSize(), this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + this.getPageSize()));
            }
            finally {
                this.\u0101 = true;
            }
            if (this.isSelectViewIndex()) {
                this.setSelectedRecordIndex(n2);
            }
        }
    }

    public void firstRecord() {
        if (this._pageNavigationSupport != null) {
            this.gotoRecord(0);
        }
    }

    public void lastRecord() {
        if (this._pageNavigationSupport != null) {
            int n2 = this._pageNavigationSupport.getTotalRecordCount();
            if (n2 > 0) {
                this.gotoRecord(n2 - 1);
            } else {
                this.notifyUser();
            }
        }
    }

    public void firstRecordInPage() {
        if (this._pageNavigationSupport != null) {
            this.setSelectedRecordIndex(0);
            this.updateButtonPanel();
        }
    }

    public void lastRecordInPage() {
        if (this._pageNavigationSupport != null) {
            this.setSelectedRecordIndex(this.getRecordCountInPage() - 1);
            this.updateButtonPanel();
        }
    }

    public void previousRecord() {
        this.gotoRecord(this.getCurrentRecord() - 1);
    }

    public void nextRecord() {
        if (this.getSelectedRecordIndex() == -1) {
            this.gotoRecord(this.getCurrentRecord());
        } else {
            this.gotoRecord(this.getCurrentRecord() + 1);
        }
    }

    protected void gotoPage() {
        if (this._pageNavigationSupport != null) {
            try {
                String string = this._pageNavigationField.getText();
                int n2 = Integer.parseInt(string) - 1;
                this.\u0104 = false;
                this.gotoPage(n2);
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyUser();
                this.updateNavigationField();
            }
        }
    }

    protected void gotoRecord() {
        if (this._pageNavigationSupport != null) {
            String string = this._pageNavigationField.getText();
            try {
                int n2 = Integer.parseInt(string) - 1;
                this.\u0104 = false;
                this.gotoRecord(n2);
                if (this.getSelectedRecordIndex() < 0) {
                    this.setSelectedRecordIndex((n2 - this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize()) % this.getPageSize());
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyUser();
                this.updateNavigationField();
            }
        }
    }

    protected int getRecordCountInPage() {
        if (this.\u0105 instanceof JTable) {
            return ((JTable)this.\u0105).getRowCount();
        }
        if (this.\u0105 instanceof JList) {
            return ((JList)this.\u0105).getModel().getSize();
        }
        return 0;
    }

    protected int getSelectedRecordIndex() {
        if (this.\u0105 instanceof JTable) {
            return ((JTable)this.\u0105).getSelectedRow();
        }
        if (this.\u0105 instanceof JList) {
            return ((JList)this.\u0105).getSelectedIndex();
        }
        return -1;
    }

    protected void setSelectedRecordIndex(int n2) {
        if (this.\u0105 instanceof JTable) {
            ((JTable)this.\u0105).getSelectionModel().setSelectionInterval(n2, n2);
        }
        if (this.\u0105 instanceof JList) {
            ((JList)this.\u0105).setSelectedIndex(n2);
        }
    }

    public void gotoPage(int n2) {
        if (n2 < 0) {
            n2 = 0;
            if (!this.\u0104) {
                this.\u0104 = true;
                this.notifyUser();
            }
        } else if (this._pageNavigationSupport.getPageCount() > 0 && n2 > this._pageNavigationSupport.getPageCount()) {
            n2 = this._pageNavigationSupport.getPageCount() - 1;
            if (!this.\u0104) {
                this.\u0104 = true;
                this.notifyUser();
            }
        } else {
            this.\u0104 = false;
        }
        if (n2 != this._pageNavigationSupport.getCurrentPage()) {
            int n3 = this.getSelectedRecordIndex();
            this.changeCurrentPage(n2);
            if (this.isSelectViewIndex()) {
                this.setSelectedRecordIndex(n3);
            }
        } else {
            this.updateNavigationField();
        }
        this.updateButtonPanel();
    }

    protected void changeCurrentPage(int n2) {
        if (this.\u0105 instanceof JideTable && ((JideTable)this.\u0105).isEditing()) {
            ((JideTable)this.\u0105).getCellEditor().cancelCellEditing();
        }
        this._pageNavigationSupport.setCurrentPage(n2);
    }

    public int gotoRecord(int n2) {
        int n3;
        if (n2 < 0) {
            n2 = 0;
            if (!this.\u0104) {
                this.\u0104 = true;
                this.notifyUser();
            }
        } else if (this._pageNavigationSupport.getTotalRecordCount() > 0 && n2 >= this._pageNavigationSupport.getTotalRecordCount()) {
            n2 = this._pageNavigationSupport.getTotalRecordCount() - 1;
            if (!this.\u0104) {
                this.\u0104 = true;
                this.notifyUser();
            }
        } else {
            this.\u0104 = false;
        }
        if ((n3 = this.getPageSize()) == 0) {
            n3 = 10;
        }
        boolean bl = this.getSelectedRecordIndex() != -1;
        int n4 = n2 / this._pageNavigationSupport.getPageSize();
        if (n4 < this._pageNavigationSupport.getCurrentPage() || n4 >= this._pageNavigationSupport.getCurrentPage() + this.getPageSize() / this._pageNavigationSupport.getPageSize() || this.getPageSize() > this._pageNavigationSupport.getPageSize() && n4 >= this._pageNavigationSupport.getPageCount() - this.getPageSize() / this._pageNavigationSupport.getPageSize()) {
            n4 = Math.min(n4, this._pageNavigationSupport.getPageCount() - this.getPageSize() / this._pageNavigationSupport.getPageSize());
            this.changeCurrentPage(n4);
        }
        int n5 = (n2 - this.getPageNavigationSupport().getCurrentPage() * this.getPageNavigationSupport().getPageSize()) % n3;
        if (this.isSelectViewIndex() && this.getSelectedRecordIndex() != n5 && bl && this.\u0101) {
            this.setSelectedRecordIndex(n5);
        }
        this.updateNavigationField();
        this.updateButtonPanel();
        return n2;
    }

    public void selectRecord(int n2) {
        this.gotoRecord(n2);
        int n3 = this.getPageSize();
        if (n3 == 0) {
            n3 = 10;
        }
        int n4 = (n2 - this.getPageNavigationSupport().getCurrentPage() * this.getPageNavigationSupport().getPageSize()) % n3;
        this.setSelectedRecordIndex(n4);
    }

    protected void notifyUser() {
        PortingUtils.notifyUser();
    }

    protected void updateButtonPanel() {
        if (this._pageNavigationField != null && this._pageNavigationField.getType() == 1) {
            boolean bl = this.isAtFirstPage();
            boolean bl2 = this.isAtLastPage();
            this.\u0101(COMMAND_FIRST, !bl);
            this.\u0101(COMMAND_PREVIOUS, !bl);
            this.\u0101(COMMAND_NEXT, !bl2);
            this.\u0101(COMMAND_LAST, !bl2);
        } else if (this._pageNavigationField != null) {
            boolean bl;
            boolean bl3;
            int n2 = this.getSelectedRecordIndex();
            if (n2 == -1) {
                bl3 = false;
                bl = this._pageNavigationSupport.getPageCount() < 0;
            } else {
                int n3 = n2 + this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize();
                bl3 = n3 == 0;
                int n4 = this._pageNavigationSupport.getTotalRecordCount();
                bl = n4 >= 0 && n3 == n4 - 1;
            }
            this.\u0101(COMMAND_FIRST, !bl3);
            this.\u0101(COMMAND_PREVIOUS, !bl3);
            this.\u0101(COMMAND_NEXT, !bl);
            this.\u0101(COMMAND_LAST, !bl);
        }
    }

    protected boolean isAtLastPage() {
        return this._pageNavigationSupport == null || this._pageNavigationSupport.getPageCount() >= 0 && this._pageNavigationSupport.getCurrentPage() >= this._pageNavigationSupport.getPageCount() - this.getPageSize() / this._pageNavigationSupport.getPageSize();
    }

    protected boolean isAtFirstPage() {
        return this._pageNavigationSupport == null || this._pageNavigationSupport.getCurrentPage() <= 0;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtonPanel();
        this.updateNavigationField();
    }

    private void \u0101(String string, boolean bl) {
        Action action = this.\u0102.get(string);
        if (action != null) {
            if (!Boolean.TRUE.equals(action.getValue("PageNavigationBar.alwaysDisabled")) && this.isEnabled()) {
                action.setEnabled(bl);
            } else {
                action.setEnabled(false);
            }
        }
    }

    public void setButtonVisible(String string, boolean bl) {
        boolean bl2 = true;
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof JideButton) && !(component instanceof PageNavigationField)) continue;
            String string2 = component.getName();
            if (string.equals(string2)) {
                component.setVisible(bl);
            }
            if (!this.\u0102.containsKey(string2) || !component.isVisible()) continue;
            this.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this.setVisible(false);
        }
    }

    public boolean isButtonVisible(String string) {
        for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = this.getComponent(i2);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        throw new NoSuchElementException();
    }

    public void setButtonEnabled(String string, boolean bl) {
        Action action = this.\u0102.get(string);
        if (action != null) {
            if (bl) {
                action.putValue("PageNavigationBar.alwaysDisabled", null);
            } else {
                action.putValue("PageNavigationBar.alwaysDisabled", true);
            }
        } else {
            throw new NoSuchElementException();
        }
        this.updateButtonPanel();
    }

    public boolean isButtonEnabled(String string) {
        Action action = this.\u0102.get(string);
        if (action != null) {
            return !Boolean.TRUE.equals(action.getValue("PageNavigationBar.alwaysDisabled"));
        }
        throw new NoSuchElementException();
    }

    public PageNavigationSupport getPageNavigationSupport() {
        return this._pageNavigationSupport;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2048)) {
            Lm.showInvalidProductMessage(PageNavigationBar.class.getName(), 2048);
        }
        \u0106 = Logger.getLogger(PageNavigationBar.class.getName());
    }

    private class A
    extends AbstractAction {
        private static final long \u0102 = 7721031106119974783L;

        private A() {
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (actionEvent.getSource() instanceof JTextField) {
                if (PageNavigationBar.this._pageNavigationField.getType() == 1) {
                    PageNavigationBar.this.gotoPage();
                } else {
                    PageNavigationBar.this.gotoRecord();
                }
                PageNavigationBar.this._pageNavigationField.getTextField().selectAll();
            } else if (PageNavigationBar.this._pageNavigationField.getType() == 1) {
                if (PageNavigationBar.COMMAND_FIRST.equals(string)) {
                    PageNavigationBar.this.firstPage();
                } else if (PageNavigationBar.COMMAND_PREVIOUS.equals(string)) {
                    PageNavigationBar.this.previousPage();
                } else if (PageNavigationBar.COMMAND_NEXT.equals(string)) {
                    PageNavigationBar.this.nextPage();
                } else if (PageNavigationBar.COMMAND_LAST.equals(string)) {
                    PageNavigationBar.this.lastPage();
                }
            } else if (PageNavigationBar.COMMAND_FIRST.equals(string)) {
                PageNavigationBar.this.firstRecord();
            } else if (PageNavigationBar.COMMAND_PREVIOUS.equals(string)) {
                PageNavigationBar.this.previousRecord();
            } else if (PageNavigationBar.COMMAND_NEXT.equals(string)) {
                PageNavigationBar.this.nextRecord();
            } else if (PageNavigationBar.COMMAND_LAST.equals(string)) {
                PageNavigationBar.this.lastRecord();
            }
        }
    }
}

