/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.ListTransferHandler;
import com.jidesoft.list.UndoableListDataEvent;
import com.jidesoft.swing.UndoableSupport;
import com.jidesoft.utils.PortingUtils;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class UndoableListInstaller<E>
implements ListDataListener,
PropertyChangeListener {
    private JList<E> \u0101;

    public UndoableListInstaller(JList<E> jList) {
        this.\u0101 = jList;
        jList.getModel().addListDataListener(this);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long \u0102 = -3366051410376533946L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UndoableListInstaller.this.getUndoManager().canUndo()) {
                    UndoableListInstaller.this.getUndoManager().undo();
                } else {
                    PortingUtils.notifyUser(UndoableListInstaller.this.\u0101);
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){
            private static final long \u0102 = 7162675928851447532L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UndoableListInstaller.this.getUndoManager().canRedo()) {
                    UndoableListInstaller.this.getUndoManager().redo();
                } else {
                    PortingUtils.notifyUser(UndoableListInstaller.this.\u0101);
                }
            }
        };
        jList.addPropertyChangeListener("model", this);
        jList.getActionMap().put("undo", abstractAction);
        jList.getActionMap().put("redo", abstractAction2);
        jList.setTransferHandler(this.createDefaultTransferHandler());
    }

    protected ListTransferHandler createDefaultTransferHandler() {
        return new ListTransferHandler();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.\u0101(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.\u0101(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.\u0101(listDataEvent);
    }

    private void \u0101(ListDataEvent listDataEvent) {
        if (listDataEvent instanceof UndoableListDataEvent) {
            this.addUndo((UndoableListDataEvent)listDataEvent);
        } else if (listDataEvent instanceof CompoundListDataEvent && ((CompoundListDataEvent)listDataEvent).getOriginalEvent() instanceof UndoableListDataEvent) {
            this.addUndo((UndoableListDataEvent)((CompoundListDataEvent)listDataEvent).getOriginalEvent());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getOldValue() instanceof ListModel) {
                ((ListModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ListModel) {
                ((ListModel)propertyChangeEvent.getNewValue()).removeListDataListener(this);
                ((ListModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
        }
    }

    public void addUndo(UndoableEdit undoableEdit) {
        UndoableEditSupport undoableEditSupport = this.\u0101();
        if (undoableEditSupport == null) {
            return;
        }
        UndoManager undoManager = this.getUndoManager();
        if (undoManager == null) {
            return;
        }
        if (undoableEdit instanceof UndoableListDataEvent && ((UndoableListDataEvent)undoableEdit).isUndoRedo()) {
            this.\u0101((UndoableListDataEvent)undoableEdit);
            return;
        }
        if (undoManager.getLimit() > 0) {
            undoManager.addEdit(undoableEdit);
            undoableEditSupport.postEdit(undoableEdit);
        }
    }

    void \u0101(UndoableListDataEvent undoableListDataEvent) {
        if (!(undoableListDataEvent.getSource() instanceof ListModel)) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        UndoableListDataEvent.A[] aArray = undoableListDataEvent.getEdits();
        ListModel listModel = (ListModel)undoableListDataEvent.getSource();
        for (UndoableListDataEvent.A a2 : aArray) {
            if (a2.\u0101() == 2) {
                for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                    Integer n2 = (Integer)arrayList.get(i2);
                    if (n2 > a2.\u0104()) {
                        arrayList.remove(i2);
                        arrayList.add(i2, n2 - 1);
                        continue;
                    }
                    if (n2.intValue() != a2.\u0104()) continue;
                    arrayList.remove(i2);
                }
                continue;
            }
            arrayList.add(a2.\u0104());
        }
        HashSet hashSet = new HashSet();
        Integer[] integerArray = arrayList.iterator();
        while (integerArray.hasNext()) {
            int n3 = (Integer)integerArray.next();
            int n4 = ListModelWrapperUtils.getIndexAt(this.\u0101.getModel(), listModel, n3);
            if (n4 < 0) continue;
            hashSet.add(n4);
        }
        if (hashSet.size() > 0) {
            integerArray = hashSet.toArray(new Integer[hashSet.size()]);
            int[] nArray = new int[integerArray.length];
            for (int i3 = 0; i3 < integerArray.length; ++i3) {
                nArray[i3] = integerArray[i3];
            }
            Arrays.sort(nArray);
            this.\u0101.setSelectedIndices(nArray);
        } else {
            this.\u0101.clearSelection();
        }
    }

    public UndoManager getUndoManager() {
        ListModel<E> listModel = ListModelWrapperUtils.getActualListModel(this.\u0101.getModel(), UndoableSupport.class);
        if (listModel instanceof UndoableSupport) {
            return ((UndoableSupport)((Object)listModel)).getUndoManager();
        }
        return null;
    }

    private UndoableEditSupport \u0101() {
        ListModel<E> listModel = ListModelWrapperUtils.getActualListModel(this.\u0101.getModel(), UndoableSupport.class);
        if (listModel instanceof UndoableSupport) {
            return ((UndoableSupport)((Object)listModel)).getUndoableEditSupport();
        }
        return null;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        UndoableEditSupport undoableEditSupport = this.\u0101();
        if (undoableEditSupport == null) {
            return;
        }
        undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        UndoableEditSupport undoableEditSupport = this.\u0101();
        if (undoableEditSupport == null) {
            return;
        }
        undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }
}

