/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.JideTable;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultCaret;

public class TextFieldCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ActionListener {
    private static final long \u04d7 = -4061167864488262595L;
    protected JTextField _textField;

    public TextFieldCellEditor(Class<?> clazz) {
        this.setType(clazz);
        this._textField = this.createTextField();
        this._textField.addActionListener(this);
    }

    protected void customizeTextField() {
        this._textField.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    protected JTextField createTextField() {
        JTextField jTextField = new JTextField(){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl) {
                Container container = null;
                if (keyEvent.getSource() == this && TextFieldCellEditor.this.isPassEnterKeyToTable() && keyEvent.getKeyCode() == 10) {
                    container = SwingUtilities.getAncestorOfClass(JideTable.class, this);
                }
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n2, bl);
                if (keyEvent.getSource() != container && container instanceof JideTable && !((JideTable)container).isEditing()) {
                    ((JideTable)container).processKeyBinding(keyStroke, keyEvent, 1, bl);
                }
                return bl2;
            }
        };
        if (LookAndFeelFactory.isLnfInUse("apple.laf.AquaLookAndFeel") || LookAndFeelFactory.isLnfInUse("com.apple.laf.AquaLookAndFeel")) {
            jTextField.setCaret(new DefaultCaret());
        }
        return jTextField;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.getConverter() != null) {
            return this.getConverter().fromString(this._textField.getText(), this.getConverterContext());
        }
        return ObjectConverterManager.fromString(this._textField.getText(), this.getType(), this.getConverterContext());
    }

    public void setCellEditorValue(Object object) {
        String string = null;
        if (this.getConverter() != null) {
            string = this.getConverter().toString(object, this.getConverterContext());
        }
        if (string == null) {
            string = ObjectConverterManager.toString(object, this.getType(), this.getConverterContext());
        }
        if (string == null) {
            string = "";
        }
        this._textField.setText(string);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        if (jTable != null) {
            this.customizeTextField();
            JideSwingUtilities.installColorsAndFont(this._textField, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
        }
        this.setCellEditorValue(object);
        if (this._textField != null && this.getEditorStyle() != 0) {
            this._textField.setEditable(this.getEditorStyle() == 3);
        }
        return this._textField;
    }

    public JTextField getTextField() {
        return this._textField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }

    @Override
    public boolean isEditorStyleSupported(int n2) {
        return n2 == 0 || n2 == 2 || n2 == 3;
    }
}

