/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TablePopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

public class TablePopupMenuInstaller
extends MouseAdapter {
    private JTable \u0101;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "TablePopupMenuInstaller";
    List<TablePopupMenuCustomizer> \u0102;

    public TablePopupMenuInstaller(JTable jTable) {
        this.\u0101 = jTable;
        this.installListeners();
    }

    public void addTablePopupMenuCustomizer(TablePopupMenuCustomizer tablePopupMenuCustomizer) {
        if (this.\u0102 == null) {
            this.\u0102 = new ArrayList<TablePopupMenuCustomizer>();
        }
        this.\u0102.add(tablePopupMenuCustomizer);
    }

    public void removeTablePopupMenuCustomizer(TablePopupMenuCustomizer tablePopupMenuCustomizer) {
        if (this.\u0102 != null) {
            this.\u0102.remove(tablePopupMenuCustomizer);
        }
    }

    public TablePopupMenuCustomizer[] getTablePopupMenuCustomizers() {
        return this.\u0102 != null ? this.\u0102.toArray(new TablePopupMenuCustomizer[this.\u0102.size()]) : new TablePopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    private void \u0101(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JTable jTable = (JTable)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        jPopupMenu.setComponentOrientation(jTable.getComponentOrientation());
        int n2 = TablePopupMenuInstaller.\u0101(jTable, mouseEvent.getPoint());
        int n3 = TablePopupMenuInstaller.\u0102(jTable, mouseEvent.getPoint());
        this.customizeMenuItems(jTable, jPopupMenu, n2, n3);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JTable jTable, JPopupMenu jPopupMenu, int n2, int n3) {
        TablePopupMenuCustomizer[] tablePopupMenuCustomizerArray;
        for (TablePopupMenuCustomizer tablePopupMenuCustomizer : tablePopupMenuCustomizerArray = this.getTablePopupMenuCustomizers()) {
            TablePopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            tablePopupMenuCustomizer.customizePopupMenu(jTable, jPopupMenu, n2, n3);
        }
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n2 = jPopupMenu.getComponentCount();
        if (n2 > 0 && !(jPopupMenu.getComponent(n2 - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public void installListeners() {
        this.\u0101.addMouseListener(this);
        this.\u0101(this.\u0101, this);
    }

    public void uninstallListeners() {
        this.\u0101.removeMouseListener(this);
        this.\u0101(this.\u0101, null);
    }

    public static TablePopupMenuInstaller getTablePopupMenuInstaller(JTable jTable) {
        Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof TablePopupMenuInstaller) {
            return (TablePopupMenuInstaller)object;
        }
        return null;
    }

    private void \u0101(JTable jTable, TablePopupMenuInstaller tablePopupMenuInstaller) {
        if (jTable != null) {
            Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof TablePopupMenuInstaller && object != this) {
                ((TablePopupMenuInstaller)object).uninstallListeners();
            }
            jTable.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, tablePopupMenuInstaller);
        }
    }

    private static int \u0102(JTable jTable, Point point) {
        return jTable.columnAtPoint(point);
    }

    private static int \u0101(JTable jTable, Point point) {
        return jTable.rowAtPoint(point);
    }
}

