/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnTableModelWrapper;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultWrappedRow;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.J;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.WrappedRow;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DefaultColumnTableModelWrapper
extends AbstractTableModel
implements ColumnTableModelWrapper,
ContextSensitiveTableModel,
StyleModel,
SpanModel,
MultiTableModel,
TableModelListener,
ColumnIdentifierTableModel,
ITreeTableModel {
    private static final long \u0e1a = 2752858268342182484L;
    protected TableModel _model;
    protected int[] _indexes;
    private TableModelEvent \u0e19;

    public DefaultColumnTableModelWrapper(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("model passed to DefaultColumnTableModelWrapper cannot be null");
        }
        this._model = tableModel;
        this._model.addTableModelListener(this);
    }

    @Override
    public TableModel getActualModel() {
        return this._model;
    }

    @Override
    public int getActualColumnAt(int n2) {
        if (n2 < 0 || n2 >= this._indexes.length) {
            return -1;
        }
        return this._indexes[n2];
    }

    @Override
    public int getVisualColumnAt(int n2) {
        for (int i2 = 0; i2 < this._indexes.length; ++i2) {
            int n3 = this._indexes[i2];
            if (n3 != n2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        return n4 >= 0 ? this._model.getValueAt(n2, n4) : null;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        if (n4 >= 0) {
            this._model.setValueAt(object, n2, n4);
        }
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._indexes.length;
    }

    @Override
    public String getColumnName(int n2) {
        int n3 = this.getActualColumnAt(n2);
        return n3 >= 0 ? this._model.getColumnName(n3) : "" + n2;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        int n3 = this.getActualColumnAt(n2);
        return n3 >= 0 ? this._model.getColumnClass(n3) : Object.class;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        return n4 >= 0 && this._model.isCellEditable(n2, n4);
    }

    @Override
    public ConverterContext getConverterContextAt(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        if (this._model instanceof ContextSensitiveTableModel && n4 >= 0) {
            return ((ContextSensitiveTableModel)this._model).getConverterContextAt(n2, n4);
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        if (this._model instanceof ContextSensitiveTableModel && n3 >= 0) {
            return ((ContextSensitiveTableModel)this._model).getEditorContextAt(n2, n4);
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        if (this._model instanceof ContextSensitiveTableModel && n4 >= 0) {
            return ((ContextSensitiveTableModel)this._model).getCellClassAt(n2, n4);
        }
        return this.getColumnClass(n3);
    }

    @Override
    public Object getColumnIdentifier(int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this._model instanceof ColumnIdentifierTableModel && n3 >= 0) {
            return ((ColumnIdentifierTableModel)((Object)this._model)).getColumnIdentifier(n3);
        }
        return null;
    }

    protected void reallocateIndexes() {
        int n2 = this._model.getColumnCount();
        this._indexes = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this._indexes[i2] = i2;
        }
    }

    public int[] getIndexes() {
        return this._indexes;
    }

    public void setIndexes(int[] nArray) {
        this._indexes = nArray;
    }

    @Override
    public CellStyle getCellStyleAt(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        if (this._model instanceof StyleModel && n3 >= 0) {
            return ((StyleModel)((Object)this._model)).getCellStyleAt(n2, n4);
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return this._model instanceof StyleModel && ((StyleModel)((Object)this._model)).isCellStyleOn();
    }

    @Override
    public CellSpan getCellSpanAt(int n2, int n3) {
        int n4 = this.getActualColumnAt(n3);
        if (this._model instanceof SpanModel && n4 >= 0) {
            CellSpan cellSpan = ((SpanModel)((Object)this._model)).getCellSpanAt(n2, n4);
            if (cellSpan != null) {
                int n5 = cellSpan.getColumnSpan();
                int n6 = this.getVisualColumnAt(cellSpan.getRow());
                for (int i2 = 1; i2 < cellSpan.getColumnSpan(); ++i2) {
                    int n7 = this.getVisualColumnAt(cellSpan.getColumn() + i2);
                    if (n7 == -1) {
                        --n5;
                        continue;
                    }
                    if (n6 != -1) continue;
                    --n5;
                    n6 = n7;
                }
                if (n5 <= 0) {
                    return null;
                }
                cellSpan.setColumnSpan(n5);
                cellSpan.setColumn(n6);
            }
            return cellSpan;
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        return this._model instanceof SpanModel && ((SpanModel)((Object)this._model)).isCellSpanOn();
    }

    @Override
    public int getColumnType(int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this.getActualModel() instanceof MultiTableModel && n3 >= 0) {
            return ((MultiTableModel)this.getActualModel()).getColumnType(n3);
        }
        return 0;
    }

    @Override
    public int getTableIndex(int n2) {
        int n3 = this.getActualColumnAt(n2);
        if (this.getActualModel() instanceof MultiTableModel && n3 >= 0) {
            return ((MultiTableModel)this.getActualModel()).getTableIndex(n3);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.\u0e19 = tableModelEvent instanceof CompoundTableModelEvent ? ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent() : tableModelEvent;
        try {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        this.tableStructureChanged();
                        return;
                    } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        if (tableModelEvent instanceof CompoundTableModelEvent) {
                            this.tableDataChanged((CompoundTableModelEvent)tableModelEvent);
                            return;
                        } else {
                            this.tableDataChanged();
                            return;
                        }
                    } else if (tableModelEvent.getColumn() == -1) {
                        this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    } else {
                        this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        finally {
            this.\u0e19 = null;
        }
    }

    protected void tableRowsInserted(int n2, int n3) {
        this.fireTableRowsInserted(n2, n3);
    }

    protected void tableRowsDeleted(int n2, int n3) {
        this.fireTableRowsDeleted(n2, n3);
    }

    protected void tableRowsUpdated(int n2, int n3) {
        this.fireTableRowsUpdated(n2, n3);
    }

    public void fireTableCellsUpdated(int n2, int n3, int n4) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, n4));
    }

    protected void tableCellsUpdated(int n2, int n3, int n4) {
        this.fireTableCellsUpdated(n3, n4, this.getVisualColumnAt(n2));
    }

    protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
        block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                    continue block5;
                }
                case -1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
                    continue block5;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, -1));
                        continue block5;
                    }
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this));
                        continue block5;
                    }
                    if (tableModelEvent.getColumn() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 0));
                        continue block5;
                    }
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), 0));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
    }

    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
        compoundTableModelEvent.setOriginalEvent(this.\u0e19);
        return compoundTableModelEvent;
    }

    protected void tableDataChanged() {
        this.fireTableDataChanged();
    }

    protected void tableStructureChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            super.fireTableChanged(tableModelEvent);
        } else {
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            compoundTableModelEvent.addEvent(tableModelEvent);
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    @Override
    public Row getRowAt(int n2) {
        Row row;
        Row row2 = row = this._model instanceof ITreeTableModel ? ((ITreeTableModel)((Object)this._model)).getRowAt(n2) : null;
        if (!(row instanceof ExpandableRow)) {
            return null;
        }
        return this.createWrappedRow((ExpandableRow)row);
    }

    protected Row createWrappedRow(ExpandableRow expandableRow) {
        return new DefaultWrappedRow(this, expandableRow);
    }

    public int getRowIndex(Row row) {
        if (row instanceof WrappedRow) {
            row = ((WrappedRow)((Object)row)).getOriginalRow();
        }
        return this._model instanceof ITreeTableModel ? ((ITreeTableModel)((Object)this._model)).getRowIndex(row) : -1;
    }

    @Override
    public Object getRoot() {
        Object object;
        Object object2 = object = this._model instanceof ITreeTableModel ? ((ITreeTableModel)((Object)this._model)).getRoot() : null;
        if (object instanceof RootExpandableRow) {
            object = new J(this, (RootExpandableRow)object);
        }
        return object;
    }
}

