/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.ResizableComponent;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.GraphicsUtilities;
import com.jidesoft.gauge.AbstractNumericGaugeAxis;
import com.jidesoft.gauge.GaugeModel;
import com.jidesoft.gauge.GaugeModelEvent;
import com.jidesoft.gauge.GaugeModelListener;
import com.jidesoft.range.Positionable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractGauge<AxisType>
extends JComponent
implements GaugeModelListener,
ResizableComponent {
    private static final long \u0101 = 5552949099443915213L;
    public static final String DEFAULT_NEEDLE_NAME = "default";
    public static final String PROPERTY_BACKGROUND_PAINT = "Background Paint";
    public static final String PROPERTY_RESIZE_FONTS = "Resize Fonts";
    private boolean \u0102 = false;
    private transient Paint \u0107;
    private boolean \u0103 = true;
    private transient GaugeModel \u0104;
    private Dimension \u0106 = null;
    private float \u0108 = 1.0f;
    private boolean \u0105 = false;

    @Override
    public void gaugeChanged(GaugeModelEvent gaugeModelEvent) {
        this.repaint();
    }

    public GaugeModel getModel() {
        return this.\u0104;
    }

    public void setModel(GaugeModel gaugeModel) {
        if (this.\u0104 != null) {
            this.\u0104.removeGaugeModelListener(this);
        }
        this.\u0104 = gaugeModel;
        if (gaugeModel != null) {
            gaugeModel.addGaugeModelListener(this);
        }
    }

    public Double getValue() {
        return this.getValue(DEFAULT_NEEDLE_NAME);
    }

    public Double getValue(String string) {
        Positionable positionable = this.\u0104.getValue(string);
        return positionable == null ? null : Double.valueOf(positionable.position());
    }

    protected Positionable createPositionable(Double d2) {
        return d2 == null ? null : new RealPosition(d2);
    }

    public void setValue(int n2) {
        this.setValue(DEFAULT_NEEDLE_NAME, this.createPositionable(Double.valueOf(n2)));
    }

    public void setValue(Double d2) {
        this.setValue(DEFAULT_NEEDLE_NAME, this.createPositionable(d2));
    }

    public void setValue(String string, Double d2) {
        this.setValue(string, this.createPositionable(d2));
    }

    public void setValue(String string, int n2) {
        this.setValue(string, this.createPositionable(Double.valueOf(n2)));
    }

    public void setValue(String string, Positionable positionable) {
        this.setValue(string, positionable, true);
    }

    public void setValue(String string, double d2, boolean bl) {
        this.setValue(string, this.createPositionable(d2), bl);
    }

    public abstract void setValue(String var1, Positionable var2, boolean var3);

    protected abstract Point2D calculatePixelPoint2D(AxisType var1, double var2);

    public boolean isShadowVisible() {
        return this.\u0102;
    }

    public void setShadowVisible(boolean bl) {
        this.\u0102 = bl;
        this.repaint();
    }

    public void setResizeFonts(boolean bl) {
        boolean bl2 = this.\u0103;
        this.\u0103 = bl;
        this.firePropertyChange(PROPERTY_RESIZE_FONTS, bl2, bl);
    }

    @Override
    public boolean isResizeFonts() {
        return this.\u0103;
    }

    public Dimension getFontComparisonSize() {
        return this.\u0106;
    }

    public void setFontComparisonSize(Dimension dimension) {
        this.\u0106 = dimension;
    }

    public float getFontSizeRatio() {
        return this.\u0108;
    }

    protected void setFontSizeRatio(float f2) {
        this.\u0108 = f2;
    }

    public Font tickLabelFontForAxis(AbstractNumericGaugeAxis abstractNumericGaugeAxis) {
        Font font = abstractNumericGaugeAxis.getTickLabelFont();
        if (this.isResizeFonts()) {
            Dimension dimension = this.getFontComparisonSize();
            return ChartUtils.deriveResizedFont(font, dimension, this);
        }
        return font;
    }

    public Paint getBackgroundPaint() {
        return this.\u0107 == null ? this.getBackground() : this.\u0107;
    }

    public void setBackgroundPaint(Paint paint) {
        Paint paint2 = this.getBackgroundPaint();
        this.\u0107 = paint;
        this.repaint();
        this.firePropertyChange(PROPERTY_BACKGROUND_PAINT, paint2, paint);
    }

    protected Color getAncestorBackground() {
        return AbstractGauge.\u0101(this);
    }

    private static Color \u0101(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        Color color = container.getBackground();
        if (color == null) {
            return AbstractGauge.\u0101(container);
        }
        return color;
    }

    protected String longestTickLabel(Collection<Tick> collection, FontMetrics fontMetrics) {
        int n2 = 0;
        String string = "";
        for (Tick tick : collection) {
            String string2 = tick.getLabel();
            if (string2 == null || fontMetrics.stringWidth(string2) <= n2) continue;
            n2 = fontMetrics.stringWidth(string2);
            string = string2;
        }
        return string;
    }

    protected boolean drawStringIfWithinBounds(Graphics2D graphics2D, String string, float f2, float f3) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        Rectangle2D rectangle2D = GraphicsUtilities.calculateStringBounds(graphics2D, string, f2, f3);
        if (GraphicsUtilities.rectangleWithinBounds(rectangle2D, rectangle2)) {
            this.\u0101(graphics2D, string, f2, f3, rectangle2D);
            return true;
        }
        return false;
    }

    private void \u0101(Graphics2D graphics2D, String string, float f2, float f3, Rectangle2D rectangle2D) {
        graphics2D.drawString(string, f2, f3);
    }

    protected boolean drawRotatedStringIfWithinBounds(Graphics graphics, Font font, String string, float f2, float f3, double d2) {
        Rectangle rectangle = this.getBounds();
        Container container = this.getParent();
        Rectangle rectangle2 = container == null ? null : SwingUtilities.convertRectangle(container, rectangle, this);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (string == null || "".equals(string)) {
            return false;
        }
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getDescent();
        float f4 = f2 + (float)n2 / 2.0f;
        double d3 = Math.abs((double)n2 * Math.cos(d2));
        double d4 = Math.abs((double)n2 * Math.sin(d2));
        double d5 = (double)f4 - d3 / 2.0;
        double d6 = (double)f4 + d3 / 2.0;
        double d7 = (double)f3 - d4 / 2.0;
        double d8 = (double)f3 + d4 / 2.0;
        if (rectangle2 == null || d5 >= rectangle2.getMinX() && d6 < rectangle2.getMaxX() && d7 >= rectangle2.getMinY() && d8 < rectangle2.getMaxY()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.translate(f4, f3);
            graphics2D.rotate(-d2);
            graphics2D.drawString(string, (float)(-n2) / 2.0f, (float)n3);
            graphics2D.rotate(d2);
            graphics2D.translate(-f4, -f3);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return true;
        }
        return false;
    }

    public boolean isAllowTickLabelOverlap() {
        return this.\u0105;
    }

    public void setAllowTickLabelOverlap(boolean bl) {
        this.\u0105 = bl;
    }
}

