/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import com.jidesoft.gantt.GanttChartPopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class GanttChartPopupMenuInstaller
extends MouseAdapter {
    private final GanttChart<?, ?> \u0101;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "GanttChartPopupMenuInstaller";
    List<GanttChartPopupMenuCustomizer> \u0102;

    public GanttChartPopupMenuInstaller(GanttChart<?, ?> ganttChart) {
        this.\u0101 = ganttChart;
        this.installListeners();
    }

    public void addGanttChartPopupMenuCustomizer(GanttChartPopupMenuCustomizer ganttChartPopupMenuCustomizer) {
        if (this.\u0102 == null) {
            this.\u0102 = new ArrayList<GanttChartPopupMenuCustomizer>();
        }
        this.\u0102.add(ganttChartPopupMenuCustomizer);
    }

    public void removeTablePopupMenuCustomizer(GanttChartPopupMenuCustomizer ganttChartPopupMenuCustomizer) {
        if (this.\u0102 != null) {
            this.\u0102.remove(ganttChartPopupMenuCustomizer);
        }
    }

    public GanttChartPopupMenuCustomizer[] getGanttChartPopupMenuCustomizers() {
        return this.\u0102 != null ? this.\u0102.toArray(new GanttChartPopupMenuCustomizer[this.\u0102.size()]) : new GanttChartPopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0101(mouseEvent);
    }

    private void \u0101(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        GanttChart ganttChart = (GanttChart)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        int n2 = GanttChartPopupMenuInstaller.\u0101(ganttChart, mouseEvent.getPoint());
        this.customizeMenuItems(ganttChart, jPopupMenu, n2, mouseEvent.getPoint());
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(ganttChart, mouseEvent.getX(), mouseEvent.getY());
        }
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, ganttChart, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(GanttChart<?, ?> ganttChart, JPopupMenu jPopupMenu, int n2, Point point) {
        GanttChartPopupMenuCustomizer[] ganttChartPopupMenuCustomizerArray;
        for (GanttChartPopupMenuCustomizer ganttChartPopupMenuCustomizer : ganttChartPopupMenuCustomizerArray = this.getGanttChartPopupMenuCustomizers()) {
            GanttChartPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            ganttChartPopupMenuCustomizer.customizePopupMenu(ganttChart, jPopupMenu, n2, point);
        }
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n2 = jPopupMenu.getComponentCount();
        if (n2 > 0 && !(jPopupMenu.getComponent(n2 - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public void installListeners() {
        this.\u0101.addMouseListener(this);
        this.\u0101(this.\u0101, this);
    }

    public void uninstallListeners() {
        this.\u0101.removeMouseListener(this);
        this.\u0101(this.\u0101, null);
    }

    public static GanttChartPopupMenuInstaller getGanttChartPopupMenuInstaller(GanttChart<?, ?> ganttChart) {
        Object object = ganttChart.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof GanttChartPopupMenuInstaller) {
            return (GanttChartPopupMenuInstaller)object;
        }
        return null;
    }

    private void \u0101(GanttChart<?, ?> ganttChart, GanttChartPopupMenuInstaller ganttChartPopupMenuInstaller) {
        if (ganttChart != null) {
            Object object = ganttChart.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof GanttChartPopupMenuInstaller && object != this) {
                ((GanttChartPopupMenuInstaller)object).uninstallListeners();
            }
            ganttChart.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, ganttChartPopupMenuInstaller);
        }
    }

    private static int \u0101(GanttChart<?, ?> ganttChart, Point point) {
        return ganttChart.rowAtPoint(point);
    }
}

