/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.field;

import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;

public class IPTextField
extends JPanel {
    private JTextField[] \u0106;
    private FocusListener \u0105;
    private boolean \u0103 = true;
    private static final int \u0102 = 255;
    private int[] \u0101 = new int[]{0, 0, 0, 0};
    public final String PROPERTY_SUBNET_MASK = "subnetMask";
    public final String PROPERTY_EDITABLE = "editable";
    private static int[] \u0104;
    protected transient ChangeEvent changeEvent = null;

    public IPTextField() {
        this.\u0104();
    }

    public IPTextField(String string) {
        this.\u0104();
        this.setText(string);
    }

    public IPTextField(int[] nArray) {
        this.\u0104();
        this.setValue(nArray);
    }

    private void \u0104() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(true);
        this.\u0105 = new D();
        this.\u0106 = new JTextField[4];
        JLabel[] jLabelArray = new JLabel[3];
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IPTextField.this.invalidate();
                IPTextField.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                IPTextField.this.invalidate();
                IPTextField.this.repaint();
            }
        };
        for (int i2 = 0; i2 < this.\u0106.length; ++i2) {
            this.\u0106[i2] = this.createTextField(i2 == 0 ? null : this.\u0106[i2 - 1]);
            this.add(this.\u0106[i2]);
            if (i2 != this.\u0106.length - 1) {
                jLabelArray[i2] = this.\u0101();
                this.add(jLabelArray[i2]);
            }
            this.\u0106[i2].addFocusListener(focusListener);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                    for (JTextField jTextField : IPTextField.this.\u0106) {
                        jTextField.setEnabled(bl);
                    }
                    IPTextField.this.updateUI();
                } else if ("editable".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
                    for (JTextField jTextField : IPTextField.this.\u0106) {
                        jTextField.setEditable(bl);
                    }
                    IPTextField.this.updateUI();
                } else if ("subnetMask".equals(propertyChangeEvent.getPropertyName())) {
                    int[] nArray = (int[])propertyChangeEvent.getNewValue();
                    int[] nArray2 = IPTextField.this.getValue();
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        if (nArray2[i2] >= nArray[i2]) continue;
                        IPTextField.this.\u0106[i2].setText("" + nArray[i2]);
                    }
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JTextField jTextField = new JTextField();
        jTextField.setEnabled(this.isEnabled());
        jTextField.setEditable(this.isEditable());
        jTextField.updateUI();
        JideSwingUtilities.installColors(this, jTextField.getBackground(), jTextField.getForeground());
        JideSwingUtilities.installBorder(this, jTextField.getBorder());
    }

    public void setText(String string) {
        int[] nArray = IPTextField.convertStringToIP(string);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            int n3 = this.getSubnetMask()[i2];
            if (n2 < n3) {
                n2 = n3;
            }
            this.\u0106[i2].setText("" + n2);
        }
    }

    public String getText() {
        return IPTextField.convertIPToString(this.getValue());
    }

    public void setValue(int[] nArray) {
        this.setText(IPTextField.convertIPToString(nArray));
    }

    public int[] getValue() {
        String[] stringArray = this.getRawText();
        return IPTextField.\u0101(stringArray);
    }

    public String[] getRawText() {
        String[] stringArray = new String[4];
        for (int i2 = 0; i2 < this.\u0106.length; ++i2) {
            JTextField jTextField = this.\u0106[i2];
            stringArray[i2] = jTextField.getText().trim();
        }
        return stringArray;
    }

    public void setRawText(String[] stringArray) {
        for (int i2 = 0; i2 < this.\u0106.length; ++i2) {
            JTextField jTextField = this.\u0106[i2];
            if (i2 >= stringArray.length) continue;
            jTextField.setText(stringArray[i2]);
        }
    }

    public boolean isValueValid() {
        String[] stringArray;
        for (String string : stringArray = this.getRawText()) {
            if (string == null || string.length() == 0) {
                return false;
            }
            try {
                int n2 = Integer.parseInt(string);
                if (n2 < 0) {
                    return false;
                }
                if (n2 <= 255) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public int[] getSubnetMask() {
        return this.\u0101;
    }

    private boolean \u0101(int n2) {
        for (int n3 : \u0104) {
            if (n2 != n3) continue;
            return true;
        }
        return false;
    }

    public void setSubnetMask(int[] nArray) {
        if (nArray.length != 4) {
            throw new IllegalArgumentException("The subnetMask must have 4 octets.");
        }
        boolean bl = true;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (!bl && n2 != 0) {
                throw new IllegalArgumentException("The subnetMask's " + IPTextField.\u0102(i2 + 1) + " mask " + n2 + " is not allowed at this position. Only zero is allowed here in order to make a valid subnet mask.");
            }
            if (!this.\u0101(n2)) {
                throw new IllegalArgumentException("The subnetMask's " + IPTextField.\u0102(i2 + 1) + " mask " + n2 + " is not a valid subnet mask.");
            }
            if (n2 == 255 || !bl) continue;
            bl = false;
        }
        int[] nArray2 = this.\u0101;
        this.\u0101 = nArray;
        this.firePropertyChange("subnetMask", nArray2, this.\u0101);
    }

    public void setSubnetMask(String string) {
        this.setSubnetMask(IPTextField.convertStringToIP(string));
    }

    public static String convertIPToString(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("The value passed in is null");
        }
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.append(nArray[0] & 0xFF).append('.').append(nArray[1] & 0xFF).append('.').append(nArray[2] & 0xFF).append('.').append(nArray[3] & 0xFF);
        return stringBuffer.toString();
    }

    public static int[] convertStringToIP(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The value passed in is null");
        }
        String[] stringArray = string.split("\\.");
        return IPTextField.\u0101(stringArray);
    }

    private static int[] \u0101(String[] stringArray) {
        int[] nArray = new int[4];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.length() == 0) {
                nArray[i2] = 0;
                continue;
            }
            try {
                nArray[i2] = IPTextField.\u0102(string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i2] = 0;
            }
        }
        return nArray;
    }

    private static int \u0102(String string) throws NumberFormatException {
        int n2 = Integer.parseInt(string);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        return n2;
    }

    @Override
    public void requestFocus() {
        JTextField jTextField = this.\u0106();
        if (jTextField != null) {
            jTextField.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean bl) {
        JTextField jTextField = this.\u0106();
        if (jTextField != null) {
            return jTextField.requestFocus(bl);
        }
        return super.requestFocus(bl);
    }

    @Override
    public boolean requestFocusInWindow() {
        JTextField jTextField = this.\u0106();
        if (jTextField != null) {
            return jTextField.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public boolean hasFocus() {
        for (JTextField jTextField : this.\u0106) {
            if (!jTextField.hasFocus()) continue;
            return true;
        }
        return false;
    }

    protected JTextField createTextField(JTextField jTextField) {
        A a2 = new A();
        JTextField jTextField2 = new JTextField(a2, "", 3);
        jTextField2.setOpaque(false);
        jTextField2.addFocusListener(this.\u0105);
        jTextField2.setBorder(BorderFactory.createEmptyBorder());
        jTextField2.setHorizontalAlignment(0);
        if (jTextField != null) {
            ((A)jTextField.getDocument()).\u0101(jTextField2);
        }
        jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                IPTextField.this.fireStateChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                IPTextField.this.fireStateChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jTextField2.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!IPTextField.this.\u0101(focusEvent.getOppositeComponent())) {
                    IPTextField.this.\u0101(new FocusEvent(IPTextField.this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent()));
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!IPTextField.this.\u0101(focusEvent.getOppositeComponent())) {
                    IPTextField.this.\u0101(new FocusEvent(IPTextField.this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent()));
                }
            }
        });
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(8, 0), new C());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(37, 0), new F());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(39, 0), new G());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(36, 0), new B());
        DelegateAction.replaceAction(jTextField2, 0, KeyStroke.getKeyStroke(35, 0), new E());
        return jTextField2;
    }

    @Override
    public void setFocusable(boolean bl) {
        for (JTextField jTextField : this.\u0106) {
            jTextField.setFocusable(bl);
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.listenerList.add(FocusListener.class, focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.listenerList.remove(FocusListener.class, focusListener);
    }

    @Override
    public FocusListener[] getFocusListeners() {
        return (FocusListener[])this.listenerList.getListeners(FocusListener.class);
    }

    private void \u0101(FocusEvent focusEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FocusListener.class) continue;
            if (focusEvent.getID() == 1004) {
                ((FocusListener)objectArray[i2 + 1]).focusGained(focusEvent);
                continue;
            }
            if (focusEvent.getID() != 1005) continue;
            ((FocusListener)objectArray[i2 + 1]).focusLost(focusEvent);
        }
    }

    private boolean \u0101(Component component) {
        for (JTextField jTextField : this.\u0106) {
            if (component != jTextField) continue;
            return true;
        }
        return false;
    }

    private JLabel \u0101() {
        NullLabel nullLabel = new NullLabel(".");
        nullLabel.setCursor(Cursor.getPredefinedCursor(2));
        return nullLabel;
    }

    private void \u0101(String string, JTextField jTextField) {
        if (jTextField == null) {
            return;
        }
        jTextField.requestFocus();
        Document document = jTextField.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(0, string, new SimpleAttributeSet());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean \u0109() {
        JTextField jTextField = this.\u0102();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        return false;
    }

    private boolean \u0107() {
        JTextField jTextField = this.\u0106();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        jTextField.setCaretPosition(0);
        return true;
    }

    private boolean \u0108() {
        JTextField jTextField = this.\u0105();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        jTextField.setCaretPosition(jTextField.getText().length());
        return true;
    }

    private JTextField \u0102() {
        for (int i2 = 0; i2 < this.\u0106.length; ++i2) {
            JTextField jTextField = this.\u0106[i2];
            if (!jTextField.hasFocus() || i2 == this.\u0106.length - 1) continue;
            return this.\u0106[i2 + 1];
        }
        return null;
    }

    private JTextField \u0106() {
        for (JTextField jTextField : this.\u0106) {
            if (!jTextField.isEditable()) continue;
            return jTextField;
        }
        return null;
    }

    private JTextField \u0105() {
        for (int i2 = this.\u0106.length - 1; i2 >= 0; --i2) {
            JTextField jTextField = this.\u0106[i2];
            if (!jTextField.isEditable()) continue;
            return this.\u0106[i2];
        }
        return null;
    }

    private int \u0101(JTextField jTextField) {
        for (int i2 = 0; i2 < this.\u0106.length; ++i2) {
            if (jTextField != this.\u0106[i2]) continue;
            return i2;
        }
        return -1;
    }

    protected boolean isNavigateToNextField(char c2) {
        return c2 == '.' || c2 == ' ';
    }

    private boolean \u0103() {
        JTextField jTextField = this.\u010a();
        if (jTextField == null) {
            return false;
        }
        jTextField.requestFocusInWindow();
        return true;
    }

    private JTextField \u010a() {
        for (int i2 = this.\u0106.length - 1; i2 >= 0; --i2) {
            JTextField jTextField = this.\u0106[i2];
            if (!jTextField.hasFocus() || i2 <= 0) continue;
            return this.\u0106[i2 - 1];
        }
        return null;
    }

    public boolean isEditable() {
        return this.\u0103;
    }

    public void setEditable(boolean bl) {
        if (bl != this.\u0103) {
            boolean bl2 = this.\u0103;
            this.\u0103 = bl;
            this.firePropertyChange("editable", bl2, this.\u0103);
            this.repaint();
        }
    }

    public JTextField[] getTextFields() {
        return this.\u0106;
    }

    private static String \u0102(int n2) {
        String string = "";
        switch (n2) {
            case 1: {
                string = "first";
                break;
            }
            case 2: {
                string = "second";
                break;
            }
            case 3: {
                string = "third";
                break;
            }
            case 4: {
                string = "fourth";
            }
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i2 + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public int getBaseline(int n2, int n3) {
        if (SystemInfo.isJdk6Above()) {
            try {
                Method method = Component.class.getMethod("getBaseline", Integer.TYPE, Integer.TYPE);
                Object object = method.invoke((Object)this.\u0106[0], n2, n3);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setToolTipText(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i2 = 0; i2 < this.getComponents().length; ++i2) {
            if (!(this.getComponents()[i2] instanceof JComponent) || stringArray.length <= i2) continue;
            ((JComponent)this.getComponents()[i2]).setToolTipText(stringArray[i2]);
        }
    }

    public void setToolTipText(String string, boolean bl) {
        if (bl) {
            String[] stringArray = new String[this.getComponents().length];
            Array.set(stringArray, 0, string);
            this.setToolTipText(stringArray);
        }
        super.setToolTipText(string);
    }

    @Override
    public void setToolTipText(String string) {
        this.setToolTipText(string, false);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(IPTextField.class.getName(), 4);
        }
        \u0104 = new int[]{0, 128, 192, 224, 40, 248, 252, 254, 255};
    }

    private class E
    extends DelegateAction {
        private static final long \u011c = -5874470980014354322L;

        private E() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == jTextField.getText().length() && IPTextField.this.\u0108();
        }
    }

    private class B
    extends DelegateAction {
        private static final long \u0118 = 3432124570246941890L;

        private B() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == 0 && IPTextField.this.\u0107();
        }
    }

    private class G
    extends DelegateAction {
        private static final long \u0120 = -6293248156577014686L;

        private G() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == jTextField.getText().length() && IPTextField.this.\u0109();
        }
    }

    private class F
    extends DelegateAction {
        private static final long \u011e = -991378279249093542L;

        private F() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getCaretPosition() == 0 && IPTextField.this.\u0103();
        }
    }

    private class C
    extends DelegateAction {
        private static final long \u011a = -6915803736210830681L;

        private C() {
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            return jTextField.getText().length() == 0 && IPTextField.this.\u0103();
        }
    }

    private class A
    extends PlainDocument {
        protected JTextField \u0102;
        private static final long \u0103 = -6916157796691243768L;

        A() {
        }

        public void \u0101(JTextField jTextField) {
            this.\u0102 = jTextField;
        }

        @Override
        public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            int n3;
            if (string == null) {
                return;
            }
            int n4 = 3 - this.getLength();
            if (n4 == 0) {
                IPTextField.this.\u0101(string, this.\u0102);
                return;
            }
            char[] cArray = new char[n4];
            int n5 = 0;
            int n6 = string.length();
            boolean bl = false;
            for (n3 = 0; n3 < n6; ++n3) {
                char c2 = string.charAt(n3);
                if (Character.isDigit(c2)) {
                    cArray[n5] = c2;
                    if (++n5 != n4) continue;
                    break;
                }
                if (!IPTextField.this.isNavigateToNextField(c2) || Math.max(n2, n5) <= 0) continue;
                bl = true;
                break;
            }
            super.insertString(n2, new String(cArray, 0, n5), attributeSet);
            if (bl || n2 + n5 == 3) {
                if (n3 + 1 < n6) {
                    IPTextField.this.\u0101(string.substring(n3 + 1), this.\u0102);
                } else {
                    IPTextField.this.\u0109();
                }
            }
        }
    }

    private class D
    extends FocusAdapter {
        private D() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string;
            if (focusEvent.isTemporary()) {
                return;
            }
            JTextField jTextField = (JTextField)focusEvent.getSource();
            String string2 = jTextField.getText();
            if (string2.length() == 0) {
                return;
            }
            int n2 = 0;
            try {
                n2 = IPTextField.\u0102(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n3 = IPTextField.this.\u0101(jTextField);
            if (n3 != -1 && n2 < IPTextField.this.getSubnetMask()[n3]) {
                n2 = IPTextField.this.getSubnetMask()[n3];
            }
            if (!(string = "" + n2).equals(jTextField.getText())) {
                jTextField.setText(string);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            jTextField.selectAll();
        }
    }
}

