/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorRowMarginSupport;
import com.jidesoft.editor.margin.LineMarginPainter;
import com.jidesoft.margin.AbstractRowMargin;
import com.jidesoft.margin.RowMarginPainter;
import com.jidesoft.margin.RowMarginSupport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;

public abstract class AbstractLineMargin
extends AbstractRowMargin
implements MouseListener,
MouseMotionListener {
    protected CodeEditor _editor;
    private int \u0105 = -1;
    private int \u0104 = -1;

    public AbstractLineMargin(CodeEditor codeEditor) {
        super(new CodeEditorRowMarginSupport(codeEditor));
        this._editor = codeEditor;
    }

    public CodeEditor getCodeEditor() {
        return this._editor;
    }

    public void addLineMarginPainter(LineMarginPainter lineMarginPainter) {
        this.addRowMarginPainter(lineMarginPainter);
    }

    public void removeLineMarginPainter(LineMarginPainter lineMarginPainter) {
        this.removeRowMarginPainter(lineMarginPainter);
    }

    protected List<RowMarginPainter> getLineMarginPainters() {
        return this.getRowMarginPainters();
    }

    @Override
    public void paintRowMargin(Graphics graphics, Rectangle rectangle, int n2) {
        this.paintLineMargin(graphics, rectangle, n2);
    }

    public abstract void paintLineMargin(Graphics var1, Rectangle var2, int var3);

    @Override
    public abstract String getToolTipText(int var1);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n2;
        int n3 = this._editor.getPainter().getLineHeight();
        int n4 = mouseEvent.getPoint().y / n3;
        int n5 = n4 + (n2 = this._editor.getFirstLine());
        if (n5 < 0 || n4 >= this._editor.getVisibleLines()) {
            return;
        }
        if ((mouseEvent.getModifiers() & 2) != 0 && (mouseEvent.getModifiers() & 1) == 0) {
            this.\u0104 = n5;
        } else if (this.\u0104 >= 0 && (mouseEvent.getModifiers() & 2) == 0 && (mouseEvent.getModifiers() & 1) != 0) {
            int n6 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(Math.min(n5, this.\u0104), 0)));
            int n7 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(n5, this.\u0104) + 1));
            this._editor.select(n6, n7);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n2 = this._editor.getPainter().getLineHeight();
        int n3 = this._editor.getFirstLine();
        int n4 = mouseEvent.getPoint().y / n2;
        this.\u0105 = n4 + n3;
        ((RowMarginSupport)this._marginSupport).scrollTo(this.\u0105, this.\u0105, this.isClickToSelect());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.\u0105 = -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.\u0105 < 0) {
            return;
        }
        this.\u0104 = -1;
        int n2 = this._editor.getPainter().getLineHeight();
        int n3 = this._editor.getFirstLine();
        int n4 = mouseEvent.getPoint().y / n2;
        int n5 = n4 + n3;
        int n6 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(Math.min(n5, this.\u0105), 0)));
        int n7 = this._editor.getLineStartOffset(this._editor.viewToModelLine(Math.max(n5, this.\u0105 + 1)));
        this._editor.select(n6, n7);
        if (n4 <= 0) {
            this._editor.setFirstLine(Math.max(0, n3 + n4 - 1));
        } else if (n4 > this._editor.getVisibleLines() - 1) {
            this._editor.setFirstLine(Math.min(this._editor.getVisualLineCount(), n5 - this._editor.getVisibleLines() + 1));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

