/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.margin.MarginSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CodeEditorMarginSupport
implements MarginSupport {
    protected CodeEditor _codeEditor;
    private Map<MarginSupport.RepaintCallback, FoldingSpanListener> \u0102;
    private DocumentListener \u0101;
    private PropertyChangeListener \u0103;

    public CodeEditorMarginSupport(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
        this.\u0102 = new HashMap<MarginSupport.RepaintCallback, FoldingSpanListener>();
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    @Override
    public int getViewPosition() {
        return this._codeEditor.getVerticalScrollBar().getValue();
    }

    @Override
    public int getViewSize() {
        return this._codeEditor.getHeight();
    }

    @Override
    public void installListeners(final MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        FoldingSpanListener foldingSpanListener = this.\u0102.get(repaintCallback);
        if (foldingSpanListener == null) {
            foldingSpanListener = new FoldingSpanListener(){

                @Override
                public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
                    if (!foldingSpanEvent.isAdjusting()) {
                        repaintCallback.repaint();
                    }
                }
            };
            this._codeEditor.getFoldingModel().addFoldingSpanListener(foldingSpanListener);
            this.\u0102.put(repaintCallback, foldingSpanListener);
        }
        if (modelChangedCallback != null) {
            if (this.\u0101 == null) {
                this.\u0101 = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }
                };
            }
            if (this.\u0103 == null) {
                this.\u0103 = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof Document) {
                            ((Document)object2).removeDocumentListener(CodeEditorMarginSupport.this.\u0101);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                            ((Document)object).addDocumentListener(CodeEditorMarginSupport.this.\u0101);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._codeEditor.addPropertyChangeListener("document", this.\u0103);
            SyntaxDocument syntaxDocument = this._codeEditor.getDocument();
            if (syntaxDocument != null) {
                syntaxDocument.addDocumentListener(this.\u0101);
            }
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        FoldingSpanListener foldingSpanListener;
        if (this.\u0103 != null) {
            this._codeEditor.removePropertyChangeListener("document", this.\u0103);
        }
        if (this.\u0101 != null && this._codeEditor.getDocument() != null) {
            this._codeEditor.getDocument().removeDocumentListener(this.\u0101);
        }
        if ((foldingSpanListener = this.\u0102.get(repaintCallback)) != null) {
            this._codeEditor.getFoldingModel().removeFoldingSpanListener(foldingSpanListener);
        }
    }
}

