/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.G;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class FrameFloatingContainer
extends ResizableFrame
implements FloatingContainer {
    private final DockingManager \u0165;
    private final FloatingContainer.FloatingContainerManager \u0164;
    private int \u0163 = 0;

    FrameFloatingContainer() throws HeadlessException {
        this((DockingManager)null, (FloatingContainer.FloatingContainerManager)null);
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager) throws HeadlessException {
        this(dockingManager, floatingContainerManager, "");
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, String string) throws HeadlessException {
        super(string);
        this.\u0165 = dockingManager;
        this.\u0164 = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.resetDockID();
    }

    protected void initListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                super.windowActivated(windowEvent);
                if (!(windowEvent.getOppositeWindow() instanceof FloatingContainer) && FrameFloatingContainer.this.\u0164 != null) {
                    FrameFloatingContainer.this.\u0164.floatingFrameActivated(windowEvent);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                super.windowDeactivated(windowEvent);
                if (FrameFloatingContainer.this.\u0164 != null) {
                    FrameFloatingContainer.this.\u0164.floatingFrameDeactivated(windowEvent);
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                DockingUtils.closeFloatingContainer(FrameFloatingContainer.this.getDockingManager(), FrameFloatingContainer.this);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                DockingUtils.closeFloatingContainer(FrameFloatingContainer.this.getDockingManager(), FrameFloatingContainer.this);
            }
        });
    }

    @Override
    public boolean hasTitleBar() {
        return !this.isUndecorated() || UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    @Override
    public Rectangle getInitialBounds(Rectangle rectangle) {
        return rectangle;
    }

    @Override
    public void updateUndecorated() {
        boolean bl = false;
        boolean bl2 = this.isVisible();
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            if (!JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                bl = true;
                this.setVisible(false);
                this.setUndecorated(false);
                this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder()));
            }
            if (this.isUndecorated()) {
                this.getRootPane().setWindowDecorationStyle(1);
            } else {
                this.getRootPane().setWindowDecorationStyle(0);
            }
        } else {
            if (JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                bl = true;
                this.setVisible(false);
                this.setUndecorated(true);
                this.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
            }
            this.getRootPane().setWindowDecorationStyle(0);
        }
        if (bl) {
            this.updateBorders();
        }
        if (this.getDockingManager().getMainContainer().isShowing() && (bl2 || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
        this.updateTitle();
    }

    @Override
    public void updateBorders() {
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.\u0102(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            DockingUtils.\u0101(this.getContentPane(), border);
            this.getResizable().setResizableCorners(0);
            if (this.\u0165.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            DockingUtils.\u0102(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            DockingUtils.\u0101(this.getContentPane(), border);
            this.getResizable().setResizableCorners(255);
            if (this.\u0165.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        }
    }

    @Override
    public Component getRoutingComponent() {
        return this.\u0165.getMainContainer();
    }

    @Override
    public DockingManager getDockingManager() {
        return this.\u0165;
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public void hideItselfIfEmpty() {
        List<DockableFrame> list = DockingUtils.\u0102(this.getContentPane());
        if (list == null || list.size() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void updateTitle() {
        Component[] componentArray = this.getContentPane().getComponents();
        Component component = null;
        for (Component component2 : componentArray) {
            if (!(component2 instanceof ContainerContainer) && !(component2 instanceof FrameContainer)) continue;
            if (component == null) {
                component = component2;
                continue;
            }
            component = null;
            break;
        }
        if (component != null) {
            if (component instanceof ContainerContainer) {
                String string;
                Object e2;
                List<Component> list = DockingUtils.\u0102((ContainerContainer)component);
                if (list.size() == 1) {
                    String string2;
                    Object e3 = list.get(0);
                    if (e3 instanceof DockableFrame && !(string2 = ((DockableFrame)e3).getTitle()).equals(this.getTitle())) {
                        this.setTitle(string2);
                    }
                } else if (list.size() > 1 && (e2 = list.get(0)) instanceof DockableFrame && !(string = ((DockableFrame)e2).getTitle() + " (" + list.size() + ")").equals(this.getTitle())) {
                    this.setTitle(string);
                }
            } else {
                String string;
                int n2 = ((FrameContainer)component).getTabCount();
                if (n2 == 1) {
                    String string3;
                    String string4 = string3 = ((FrameContainer)component).getSelectedFrame() == null ? "" : ((FrameContainer)component).getSelectedFrame().getTitle();
                    if (!string3.equals(this.getTitle())) {
                        this.setTitle(string3);
                    }
                } else if (n2 > 1 && !(string = ((FrameContainer)component).getFrame(0).getTitle() + " (" + n2 + ")").equals(this.getTitle())) {
                    this.setTitle(string);
                }
            }
        }
    }

    @Override
    public int getDockID() {
        return this.\u0163;
    }

    @Override
    public void setDockID(int n2) {
        this.\u0163 = n2;
    }

    @Override
    public void resetDockID() {
        this.\u0163 = -1;
        if (this.\u0165 != null) {
            this.\u0163 = G.\u0102(this.\u0165).\u0104(this.getDockID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component getMostRecentFocusOwner() {
        Component component;
        if (this.getContentPane().getComponentCount() < 1) return super.getMostRecentFocusOwner();
        Component component2 = this.getContentPane().getComponent(0);
        List<Component> list = null;
        if (component2 instanceof ContainerContainer) {
            list = DockingUtils.\u0102((ContainerContainer)component2);
        } else if (component2 instanceof FrameContainer) {
            list = DockingUtils.\u0104((FrameContainer)component2);
        }
        if (list == null || list.size() <= 0 || !((component = list.get(0)) instanceof DockableFrame)) return super.getMostRecentFocusOwner();
        DockableFrame dockableFrame = (DockableFrame)component;
        Container container = dockableFrame.getParent();
        if (container != null && container instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)container;
            DockableFrame dockableFrame2 = frameContainer.getSelectedFrame();
            if (dockableFrame2 == null) return frameContainer;
            Component component3 = dockableFrame2.getFocusedComponent();
            if (component3 == null || component3 == dockableFrame2) {
                component3 = dockableFrame2.getDefaultFocusComponent();
            }
            if (component3 == dockableFrame2) return super.getMostRecentFocusOwner();
            return component3;
        }
        Component component4 = dockableFrame.getFocusedComponent();
        if (component4 == dockableFrame) {
            component4 = dockableFrame.getDefaultFocusComponent();
        }
        if (component4 == dockableFrame) return super.getMostRecentFocusOwner();
        return component4;
    }

    @Override
    public void setResizable(boolean bl) {
        super.setResizable(bl);
        this.getResizable().setResizableCorners(bl ? 255 : 0);
    }

    @Override
    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }
}

