/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.diff;

import com.jidesoft.diff.BasicDiffPane;
import com.jidesoft.diff.C;
import com.jidesoft.diff.Diff;
import com.jidesoft.diff.DiffDivider;
import com.jidesoft.diff.DiffMargin;
import com.jidesoft.diff.DiffTableStyleProvider;
import com.jidesoft.diff.Difference;
import com.jidesoft.diff.LazyLoadTableRowData;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.TreeTableSearchable;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.margin.TableRowMarginSupport;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.marker.TableRowMarkerSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableDiffPane
extends BasicDiffPane<Object> {
    private Object[] \u0127;
    private Object[] \u0126;
    protected DiffTableStyleProvider _fromTableStyleProvider;
    protected DiffTableStyleProvider _toTableStyleProvider;

    public TableDiffPane() {
    }

    public TableDiffPane(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public void flip() {
        this.\u0127 = null;
        this.\u0126 = null;
        super.flip();
    }

    protected Object[] createArrayFromTableModel(TableModel tableModel) {
        Object[] objectArray = new Object[tableModel.getRowCount()];
        int n2 = 0;
        for (int i2 = 0; i2 < tableModel.getRowCount(); ++i2) {
            objectArray[i2] = this.getTableRowData(tableModel, i2);
            if (++n2 < 10000) continue;
            if (Thread.currentThread().isInterrupted()) {
                return new Object[0];
            }
            n2 = 0;
        }
        return objectArray;
    }

    protected Object getTableRowData(TableModel tableModel, int n2) {
        return new LazyLoadTableRowData(tableModel, n2);
    }

    private List<Object> \u0101(TableModel tableModel, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(){
            private static final long \u0102 = -3491850231727214748L;

            @Override
            public boolean equals(Object object) {
                return object instanceof List && JideSwingUtilities.equals(this, object, true);
            }
        };
        for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
            arrayList.add(tableModel.getValueAt(n2, i2));
        }
        return arrayList;
    }

    @Override
    protected void customizePane(JComponent jComponent, int n2) {
        super.customizePane(jComponent, n2);
        JTable jTable = null;
        if (n2 == 0) {
            jTable = (JTable)this._fromComponent;
            this._fromMarginArea.setBorder(BorderFactory.createEmptyBorder(jTable.getTableHeader().getPreferredSize().height + 1, 0, 1, 0));
            if (this._fromDiffMargin instanceof DiffMargin) {
                ((DiffMargin)this._fromDiffMargin).\u0102(-2);
            }
            if (this._fromDiffLineNumberMargin instanceof C) {
                ((C)this._fromDiffLineNumberMargin).\u0101(-2);
            }
            this._fromTableStyleProvider = new DiffTableStyleProvider(this, n2);
            if (jTable instanceof CellStyleTable) {
                ((CellStyleTable)jTable).setTableStyleProvider(this._fromTableStyleProvider);
                ((CellStyleTable)jTable).setGridColorProvider(this._fromTableStyleProvider);
            }
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    TableDiffPane.this.\u0102(0);
                }
            });
            jTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (((JTable)TableDiffPane.this._fromComponent).getModel() != tableModelEvent.getSource() && tableModelEvent.getSource() instanceof TableModel) {
                        ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
                        return;
                    }
                    TableDiffPane.\u0101(TableDiffPane.this, null);
                    if (TableDiffPane.this._diffed) {
                        TableDiffPane.this.runDiff();
                    }
                }
            });
        } else if (n2 == 1) {
            jTable = (JTable)this._toComponent;
            this._toMarginArea.setBorder(BorderFactory.createEmptyBorder(jTable.getTableHeader().getPreferredSize().height + 1, 0, 1, 0));
            if (this._toDiffMargin instanceof DiffMargin) {
                ((DiffMargin)this._toDiffMargin).\u0102(-2);
            }
            if (this._toDiffLineNumberMargin instanceof C) {
                ((C)this._toDiffLineNumberMargin).\u0101(-2);
            }
            this._toTableStyleProvider = new DiffTableStyleProvider(this, n2);
            if (jTable instanceof CellStyleTable) {
                ((CellStyleTable)jTable).setTableStyleProvider(this._toTableStyleProvider);
                ((CellStyleTable)jTable).setGridColorProvider(this._toTableStyleProvider);
            }
            jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    TableDiffPane.this.\u0102(1);
                }
            });
            jTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (((JTable)TableDiffPane.this._toComponent).getModel() != tableModelEvent.getSource() && tableModelEvent.getSource() instanceof TableModel) {
                        ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
                        return;
                    }
                    TableDiffPane.\u0102(TableDiffPane.this, null);
                    if (TableDiffPane.this._diffed) {
                        TableDiffPane.this.runDiff();
                    }
                }
            });
        }
        if (jTable instanceof JideTable) {
            jTable.setAutoResizeMode(256);
            ((JideTable)jTable).setColumnAutoResizable(true);
            new TreeTableSearchable(jTable);
        }
        if (jTable instanceof SortableTable) {
            ((SortableTable)jTable).setSortable(false);
        }
    }

    @Override
    protected void customizePanes(JComponent[] jComponentArray) {
        super.customizePanes(jComponentArray);
        TableUtils.synchronizeTableColumnWidthNow((JTable)this._fromComponent, (JTable)this._toComponent);
        TableUtils.synchronizeTableColumnWidth(new JTable[]{(JTable)this._fromComponent, (JTable)this._toComponent});
    }

    @Override
    protected MarkerSupport createMarkerSupport(JComponent jComponent) {
        return new TableRowMarkerSupport((JTable)jComponent);
    }

    @Override
    protected RowMarginSupport createRowMarginSupport(JComponent jComponent, JScrollPane jScrollPane) {
        return new TableRowMarginSupport((JTable)jComponent, jScrollPane);
    }

    @Override
    public JComponent createComponent(Object object, int n2) {
        return new SortableTable((TableModel)object);
    }

    @Override
    protected void adjustDividerOffset(DiffDivider diffDivider, int n2) {
        diffDivider.adjustFirstVerticalOffset(0, 2 + this._fromTitle.getPreferredSize().height + ((JTable)this._fromComponent).getTableHeader().getPreferredSize().height);
        diffDivider.adjustSecondVerticalOffset(0, 2 + this._toTitle.getPreferredSize().height + ((JTable)this._toComponent).getTableHeader().getPreferredSize().height);
        diffDivider.setFirstBottomMargin(this._fromScrollPane.getHorizontalScrollBar().isVisible() ? this._fromScrollPane.getHorizontalScrollBar().getPreferredSize().height : 0);
        diffDivider.setSecondBottomMargin(this._toScrollPane.getHorizontalScrollBar().isVisible() ? this._toScrollPane.getHorizontalScrollBar().getPreferredSize().height : 0);
    }

    @Override
    public Object[] getFromItems() {
        if (this.\u0127 == null) {
            this.\u0127 = this.createArrayFromTableModel(((JTable)this._fromComponent).getModel());
        }
        return this.\u0127;
    }

    @Override
    public Object[] getToItems() {
        if (this.\u0126 == null) {
            this.\u0126 = this.createArrayFromTableModel(((JTable)this._toComponent).getModel());
        }
        return this.\u0126;
    }

    protected List<Object> getFromItems(int n2, int n3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = Math.min(n2, n3); i2 <= Math.max(n2, n3); ++i2) {
            arrayList.addAll(this.\u0101(((JTable)this._fromComponent).getModel(), i2));
        }
        return arrayList;
    }

    protected List<Object> getToItems(int n2, int n3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = Math.min(n2, n3); i2 <= Math.max(n2, n3); ++i2) {
            arrayList.addAll(this.\u0101(((JTable)this._toComponent).getModel(), i2));
        }
        return arrayList;
    }

    @Override
    protected int getSelectedIndex(int n2) {
        JTable jTable = (JTable)(n2 == 0 ? this._fromComponent : this._toComponent);
        return jTable.getSelectedRow();
    }

    @Override
    protected Diff<?> createLinesDiff(int n2, int n3, int n4, int n5) {
        Diff<Object> diff = new Diff<Object>(this.getFromItems(n2, n3), this.getToItems(n4, n5));
        diff.setItemsConsistent(false);
        return diff;
    }

    @Override
    public void highlightChangedExactly(List<Difference> list, int n2, int n3, int n4, int n5, Color color, Color color2, String string) {
        if (list != null && list.size() >= 1) {
            super.highlightChangedExactly(list, n2, n3, n4, n5, color, color2, string);
            this._fromTableStyleProvider.addPositionHighlight(n2 - 1);
            this._fromTableStyleProvider.addPositionHighlight(n3);
            this._toTableStyleProvider.addPositionHighlight(n4 - 1);
            this._toTableStyleProvider.addPositionHighlight(n5);
            for (Difference difference : list) {
                int n6;
                int n7;
                int n8;
                for (n8 = difference.getDeletedStart(); n8 <= difference.getDeletedEnd(); ++n8) {
                    n7 = n2 + n8 / ((JTable)this._fromComponent).getColumnCount();
                    n6 = n8 % ((JTable)this._fromComponent).getColumnCount();
                    if (difference.getDeletedEnd() == -1) {
                        this._fromTableStyleProvider.addInsertedCellHighlight(n7, n6);
                        continue;
                    }
                    if (difference.getAddedEnd() == -1) {
                        this._fromTableStyleProvider.addDeletedCellHighlight(n7, n6);
                        continue;
                    }
                    this._fromTableStyleProvider.addChangedCellHighlight(n7, n6);
                }
                for (n8 = difference.getAddedStart(); n8 <= difference.getAddedEnd(); ++n8) {
                    n7 = n4 + n8 / ((JTable)this._toComponent).getColumnCount();
                    n6 = n8 % ((JTable)this._toComponent).getColumnCount();
                    if (difference.getAddedEnd() == -1) {
                        this._toTableStyleProvider.addDeletedCellHighlight(n7, n6);
                        continue;
                    }
                    if (difference.getDeletedEnd() == -1) {
                        this._toTableStyleProvider.addInsertedCellHighlight(n7, n6);
                        continue;
                    }
                    this._toTableStyleProvider.addChangedCellHighlight(n7, n6);
                }
            }
        } else {
            this.highlightChanged(n2, n3, n4, n5, color, color2, string);
        }
    }

    @Override
    public void highlightChanged(int n2, int n3, int n4, int n5, Color color, Color color2, String string) {
        super.highlightChanged(n2, n3, n4, n5, color, color2, string);
        this._fromTableStyleProvider.addChangedHighlight(n2, n3);
        this._toTableStyleProvider.addChangedHighlight(n4, n5);
    }

    @Override
    public void highlightInserted(int n2, int n3, int n4, Color color, Color color2, String string) {
        super.highlightInserted(n2, n3, n4, color, color2, string);
        if (n2 > 0) {
            this._fromTableStyleProvider.addPositionHighlight(n2 - 1);
        }
        this._toTableStyleProvider.addInsertedHighlight(n3, n4);
    }

    @Override
    public void highlightDeleted(int n2, int n3, int n4, Color color, Color color2, String string) {
        super.highlightDeleted(n2, n3, n4, color, color2, string);
        this._fromTableStyleProvider.addDeletedHighlight(n2, n3);
        if (n4 > 0) {
            this._toTableStyleProvider.addPositionHighlight(n4 - 1);
        }
    }

    @Override
    public void clearHighlights() {
        super.clearHighlights();
        this._fromTableStyleProvider.clearAllHighlights();
        this._toTableStyleProvider.clearAllHighlights();
    }

    @Override
    public boolean delete(int n2, int n3, boolean bl) {
        TableModel tableModel = ((JTable)this._toComponent).getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel);
        if (tableModel2 instanceof DefaultTableModel) {
            int n4;
            int[] nArray = new int[n3];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray[n4] = TableModelWrapperUtils.getActualRowAt(tableModel, n2 + n4);
            }
            Arrays.sort(nArray);
            for (n4 = nArray.length - 1; n4 >= 0; --n4) {
                ((DefaultTableModel)tableModel2).removeRow(nArray[n4]);
            }
            if (bl && this._diffed) {
                this.runDiff();
            }
            return true;
        }
        if (tableModel2 instanceof IExpandableTreeTableModel) {
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                ((IExpandableTreeTableModel)((Object)tableModel2)).removeRow(n2 + i2);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean insert(int n2, int n3, int n4, boolean bl) {
        TableModel tableModel = ((JTable)this._toComponent).getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel);
        if (tableModel2 instanceof DefaultTableModel) {
            int n5;
            Object[][] objectArrayArray = new Object[n4][];
            TableModel tableModel3 = ((JTable)this._fromComponent).getModel();
            for (n5 = 0; n5 < n4; ++n5) {
                int n6 = tableModel3.getColumnCount();
                Object[] objectArray = new Object[n6];
                for (int i2 = 0; i2 < n6; ++i2) {
                    objectArray[i2] = tableModel3.getValueAt(n5 + n3, i2);
                }
                objectArrayArray[n5] = objectArray;
            }
            for (n5 = objectArrayArray.length - 1; n5 >= 0; --n5) {
                ((DefaultTableModel)tableModel2).insertRow(n2, objectArrayArray[n5]);
            }
            if (bl && this._diffed) {
                this.runDiff();
            }
            return true;
        }
        if (tableModel2 instanceof IExpandableTreeTableModel) {
            Row row;
            TableModel tableModel4 = ((JTable)this._fromComponent).getModel();
            TableModel tableModel5 = TableModelWrapperUtils.getActualTableModel(tableModel4);
            if (!(tableModel5 instanceof IExpandableTreeTableModel)) {
                return false;
            }
            ArrayList<Row> arrayList = new ArrayList<Row>();
            Expandable expandable = null;
            for (int i3 = 0; i3 < n4; ++i3) {
                row = ((IExpandableTreeTableModel)((Object)tableModel5)).getRowAt(n3 + i3);
                arrayList.add(row);
                if (row == null) {
                    return false;
                }
                if (expandable == null) {
                    expandable = row.getParent();
                    continue;
                }
                if (row.getParent() == expandable) continue;
                return false;
            }
            Row row2 = ((IExpandableTreeTableModel)((Object)tableModel2)).getRowAt(n2 - 1);
            row = ((IExpandableTreeTableModel)((Object)tableModel2)).getRowAt(n2);
            if (row2 == null || row == null || row2.getParent() != row.getParent()) {
                return false;
            }
            int n7 = row2.getParent().getChildIndex(row);
            ((IExpandableTreeTableModel)((Object)tableModel2)).addRows((Row)((Object)row2.getParent()), n7, arrayList);
        }
        return false;
    }

    @Override
    public void setChangedColor(Color color) {
        super.setChangedColor(color);
        if (this._fromTableStyleProvider != null) {
            this._fromTableStyleProvider.setChangedColor(color);
        }
        if (this._toTableStyleProvider != null) {
            this._toTableStyleProvider.setChangedColor(color);
        }
    }

    @Override
    public void setInsertedColor(Color color) {
        super.setInsertedColor(color);
        if (this._fromTableStyleProvider != null) {
            this._fromTableStyleProvider.setInsertedColor(color);
        }
        if (this._toTableStyleProvider != null) {
            this._toTableStyleProvider.setInsertedColor(color);
        }
    }

    @Override
    public void setDeletedColor(Color color) {
        super.setDeletedColor(color);
        if (this._fromTableStyleProvider != null) {
            this._fromTableStyleProvider.setDeletedColor(color);
        }
        if (this._toTableStyleProvider != null) {
            this._toTableStyleProvider.setDeletedColor(color);
        }
    }

    static /* synthetic */ Object[] \u0101(TableDiffPane tableDiffPane, Object[] objectArray) {
        tableDiffPane.\u0127 = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[] \u0102(TableDiffPane tableDiffPane, Object[] objectArray) {
        tableDiffPane.\u0126 = objectArray;
        return objectArray;
    }
}

