/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.csv;

import com.jidesoft.csv.CsvParseEvent;
import com.jidesoft.csv.CsvParseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CsvReader {
    private static final Logger \u0104 = Logger.getLogger(CsvReader.class.getName());
    private BufferedReader \u0106;
    private char \u0105 = (char)44;
    private boolean \u0103 = true;
    private ArrayList<List<String>> \u0101 = new ArrayList();
    private com.jidesoft.csv.A \u0102 = new com.jidesoft.csv.A(this.\u0105);

    public CsvReader() {
        this(null, ',');
    }

    public CsvReader(char c2) {
        this(null, c2);
    }

    public CsvReader(Reader reader) {
        this(reader, ',');
    }

    public CsvReader(Reader reader, char c2) {
        this.setReader(reader);
        this.setSeparator(c2);
        A a2 = new A();
        this.\u0102.\u0102(a2);
    }

    public void ensureCapacity(int n2) {
        this.\u0101.ensureCapacity(n2);
    }

    public void setReader(Reader reader) {
        this.\u0106 = reader == null || CsvReader.isBufferedReader(reader) ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public Reader getReader() {
        return this.\u0106;
    }

    public void setSeparator(char c2) {
        this.\u0105 = c2;
        this.\u0102.\u0101(c2);
    }

    public char getSeparator() {
        return this.\u0105;
    }

    public boolean isTrimmingValues() {
        return this.\u0103;
    }

    public void setTrimmingValues(boolean bl) {
        this.\u0103 = bl;
        this.\u0102.\u0101(bl);
    }

    public List<List<String>> parse(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot parse a null File!");
        }
        FileReader fileReader = new FileReader(file);
        return this.parse(fileReader);
    }

    public List<List<String>> parse(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot parse a null Input Stream!");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return this.parse(bufferedReader);
    }

    public static boolean isBufferedReader(Reader reader) {
        return reader instanceof BufferedReader;
    }

    public List<List<String>> parse() throws IOException {
        if (this.\u0106 == null) {
            throw new IllegalStateException("Reader has not been set - use the setReader() method before calling this method");
        }
        this.\u0101.clear();
        String string = this.\u0106.readLine();
        while (string != null) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                this.\u0102.\u0102(c2);
            }
            this.\u0102.\u0104();
            string = this.\u0106.readLine();
        }
        return this.\u0101;
    }

    public List<List<String>> parse(Reader reader) throws IOException {
        this.setReader(reader);
        return this.parse();
    }

    public void parseForEffects(CsvParseListener csvParseListener) throws IOException {
        com.jidesoft.csv.A a2 = new com.jidesoft.csv.A(this.\u0105);
        a2.\u0102(csvParseListener);
        if (this.\u0106 == null) {
            throw new IllegalStateException("The reader must be set before calling parseForEffects");
        }
        CsvParseEvent csvParseEvent = new CsvParseEvent((Object)this, CsvParseEvent.EventType.INPUT_START);
        csvParseListener.parsed(csvParseEvent);
        String string = this.\u0106.readLine();
        while (string != null) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                a2.\u0102(c2);
            }
            a2.\u0104();
            string = this.\u0106.readLine();
        }
        CsvParseEvent csvParseEvent2 = new CsvParseEvent((Object)this, CsvParseEvent.EventType.INPUT_END);
        csvParseListener.parsed(csvParseEvent2);
    }

    class A
    implements CsvParseListener {
        A() {
        }

        @Override
        public void parsed(CsvParseEvent csvParseEvent) {
            if (csvParseEvent.getType() != CsvParseEvent.EventType.TOKEN && csvParseEvent.getType() == CsvParseEvent.EventType.LINE) {
                CsvReader.this.\u0101.add(csvParseEvent.getTokens());
            }
        }
    }
}

